# Pretrain Dataset Preparation
You can directly download the processed data for training ImOV3D from the following links: [google drive]()


## 3D branch Dataset Preparation

### Point_Cloud_Lifting_Module

(If you plan to run the Rotation Correction Module, this step can be skipped.)

This section primarily involves lifting 2D images into point clouds. Before applying the 2D images lifting process, you need to use [ZoeDepth](https://github.com/isl-org/ZoeDepth) to predict depth images. The corresponding inference file is `depth_estimation.py`. Subsequently, you need to use `Point_Cloud_Lifting.py` to lift RGBD into point clouds.


### 3D DATA REVISION
- **Rotation Correction Module**

    This section primarily focuses on ensuring that the pseudo point clouds remain level. First, use the [Normal Estimator](https://github.com/baegwangbin/surface_normal_uncertainty) to predict the normal map (replacing the original file with `test.py`). Then, use `Extract_horizontal_normal.py` to extract the horizontal normal mask. Then, calculate the rotation matrix using `Rotation_matrix_calculation.py`.  Finally, run `Point_Cloud_Lifting_for_Rotation_Correction.py`.

- **3D Box Filtering Module**

    This part is the final step to remove inaccurate 3D boxes. After replacing the path to the `_bbox.npy` file, simply run `3D_box_Filter.py`.

## 2D branch Dataset Preparation
This section is primarily intended for the preparation of generating high-quality textured images.


### Point Cloud Renderer

For more details, please see [installation](../../Point_Cloud_Renderer).

### Finetune 2D OV detector

For more details, please see [installation](../../Finetune-2DOVdetector).


