#!/bin/bash
clear
export OMP_NUM_THREADS=8

SPARSITY=${SPARSITY:-0.50}
ITERATIONS=${ITERATIONS:-3}
LR=${LR:-1e-5}

export TRANSFORMERS_CACHE=.

MODEL=facebook/opt-125m
SEED=0
#SEED=1234

CUDA_VISIBLE_DEVICES=0 python iht_with_full_gradient_update.py \
    --model_name_or_path ${MODEL} \
    --dtype bfloat16 \
    --dataset_name_or_path wikitext2 \
    --pre_decoder_modules 'model.decoder.embed_tokens' 'model.decoder.embed_positions' \
    --decoder_blocks 'model.decoder.layers' \
    --post_decoder_modules 'model.decoder.final_layer_norm' 'lm_head' \
    --module_regex '.*layers.*((q|k|v|out)_proj|fc\d+)$' \
    --low_cpu_mem_usage \
    --sequence_length 2048 \
    --calibration_dataset_size 128 \
    --iterations ${ITERATIONS} \
    --sparsity ${SPARSITY} \
    --pruning_method FastOBC \
    --sequential \
    --rel_damp 0.01 \
    --lr ${LR} \
    --finetune_batch_size 1 \
    --output_dir "./iht_results/${MODEL}/FastOBC/iterations=${ITERATIONS}-sp=${SPARSITY}-alpha=${ALPHA}-sequential=True_data-size=${DATA_SIZE}_seed=${SEED}"