# Safe Multi-Agent Mujoco

We introduce a safe Multi-Agent Reinforcement Learning Benchmark, **Safe Multi-Agent MuJoCo (Safe MAMujoco)**, a safety-aware modification of [MAMuJoCo](https://github.com/schroederdewitt/multiagent_mujoco).  Safe MAMuJoCo agents learn to not only skilfully manipulate a robot, but also to avoid dangerous obstacles and positions, Figure 1 shows example views of the environment. (This repository is under actively development. We appreciate any constructive comments and suggestions)



In particular, the background environment, agents, physics simulator, and the reward function are preserved. However, as oppose to its predecessor, Safe MAMuJoCo environments come with obstacles, like walls or bombs. Furthermore, with the increasing risk of an agent stumbling upon an obstacle, the environment emits cost.

<!--
<div align=center>
 <img src="https://github.com/chauncygu/Safe-Multi-Agent-Mujoco/blob/main/figures/Ant2x4_new_green_yellow.jpg" width="165"/> <img src="https://github.com/chauncygu/Safe-Multi-Agent-Mujoco/blob/main/figures/New_Ant4x2.jpg" width="175"/> <img src="https://github.com/chauncygu/Safe-Multi-Agent-Mujoco/blob/main/figures/couple_halfcheetah_p1p_color.jpg" width="213"/>
    <img src="https://github.com/chauncygu/Safe-Multi-Agent-Mujoco/blob/main/figures/New_HalfCheetah2x3.jpg" width="202"/>  
</div>
<div align=center>
<center style="color:#000000;text-decoration:underline">Figure.1 Example views of robots in Safe MAMuJoCo. Body parts of different colours are controlled by differentagents. Agents jointly learn to manipulate the robot, while avoiding crashing into unsafe areas. </center>
 </div>
-->
 
 
 <div align=center>
 <img src="https://github.com/chauncygu/Safe-Multi-Agent-Mujoco/blob/main/figures/all-mujoco.png" width="850"/> 
 </div>
<div align=center>
<center style="color:#000000;text-decoration:underline">Figure.1 Example views of robots in Safe MAMuJoCo. Body parts of different colours are controlled by differentagents. Agents jointly learn to manipulate the robot, while avoiding crashing into unsafe areas. </center>
 </div>
 




## Installation

- Install mujoco accoring to [mujoco-py](https://github.com/openai/mujoco-py) and [MuJoCo website](https://www.roboti.us/license.html).
- clone safety multi-agent mujoco to the env path.
&nbsp;

``` Bash
LD_LIBRARY_PATH=${HOME}/.mujoco/mujoco200/bin;
LD_PRELOAD=/usr/lib/x86_64-linux-gnu/libGLEW.so
pip install -r requirements.txt
```
     
 ``` Bash
# create conda environment
conda create -n marl python==3.8
conda activate marl
pip install torch==1.5.1+cu101 torchvision==0.6.1+cu101 -f https://download.pytorch.org/whl/torch_stable.html
 ```
        
## Train
Here we use train_mujoco.sh as an example:
 ```
cd scalable_mappo_lagr\scripts
chmod +x ./train_mujoco.sh
./train_mujoco.sh
 ```
Local results are stored in subfold scripts/results. Note that we use Weights & Bias as the default visualization platform; to use Weights & Bias, please register and login to the platform first. More instructions for using Weights&Bias can be found in the official [documentation](https://docs.wandb.ai/). Adding the `--use_wandb` in command line or in the .sh file will use Tensorboard instead of Weights & Biases. 

## Test
Run test.py

``` Bash
python test.py
```

## Tasks
``` Bash
    ManyAgent Ant
    
    env_args = {"scenario": "manyagent_ant",
                  "agent_conf": "2x3",
                  "agent_obsk": 3,
                  "episode_limit": 1000}

    env_args = {"scenario": "manyagent_ant",
                  "agent_conf": "3x2",
                  "agent_obsk": 2,
                  "episode_limit": 1000}
                  
    env_args = {"scenario": "manyagent_ant",
                  "agent_conf": "6x1",
                  "agent_obsk": 1,
                  "episode_limit": 1000}
                  
    Ant 
    env_args = {"scenario": "Ant-v2",
                "agent_conf": "2x4",
                "agent_obsk": 4,
                "episode_limit": 1000}

    env_args = {"scenario": "Ant-v2",
                "agent_conf": "4x2",
                "agent_obsk": 2,
                "episode_limit": 1000}  

    env_args = {"scenario": "Ant-v2",
                "agent_conf": "8x1",
                "agent_obsk": 1,
                "episode_limit": 1000}
                
   Coupled_half_cheetah
    env_args = {"scenario": "coupled_half_cheetah",
                "agent_conf": "2x6",
                "agent_obsk": 6,
                "episode_limit": 1000}
    
    env_args = {"scenario": "coupled_half_cheetah",
                "agent_conf": "6x2",
                "agent_obsk": 2,
                "episode_limit": 1000}

    env_args = {"scenario": "coupled_half_cheetah",
                "agent_conf": "12x1",
                "agent_obsk": 12,
                "episode_limit": 1000}

```


## Cite
Our work is based on that of the following paper.
 ```
@misc{yu2021surprising,
      title={The Surprising Effectiveness of MAPPO in Cooperative Multi-Agent Games}, 
      author={Chao Yu and Akash Velu and Eugene Vinitsky and Yu Wang and Alexandre Bayen and Yi Wu},
      year={2021},
      eprint={2103.01955},
      archivePrefix={arXiv},
      primaryClass={cs.LG}
 },
@article{gu2023safe,
      title={Safe multi-agent reinforcement learning for multi-robot control},
      author={Gu, Shangding and Kuba, Jakub Grudzien and Chen, Yuanpei and Du, Yali and Yang, Long and Knoll, Alois and Yang, Yaodong},
      journal={Artificial Intelligence},
      volume={319},
      pages={103905},
      year={2023},
      publisher={Elsevier}
}


```

# Acknowledgments

We thank the list of contributors from the following open source repositories: [MAMujoco](https://github.com/schroederdewitt/multiagent_mujoco), [safety-gym](https://github.com/openai/safety-gym), [CMBPO](https://github.com/anyboby/Constrained-Model-Based-Policy-Optimization). [aij-safe-marl](https://sites.google.com/view/aij-safe-marl/)





