import argparse
import yaml
import wandb
from dataset import load_dataset,TUData
from train_dist  import train_model_dist, data_loader
from utils import seed_everything
from ogb.graphproppred import Evaluator

parser = argparse.ArgumentParser(description='  ')

parser.add_argument('--model', default='GMT', type=str,help='train the XX model')
parser.add_argument('--dataset', default='IMDB-BINARY', type=str,help='on which dataset')
parser.add_argument('--device', required=False, default=2, type=int, help='Device Number' )
parser.add_argument("--seed", type=int, default=1234, help="random seed (default: 1234)")
parser.add_argument("--reg_term", type=float, default=0.1, help="random seed (default: 1234)")
parser.add_argument("--wandb_disabled", action='store_false', help="whether use wanbd")

args = parser.parse_args()

seed_everything(args.seed)

config_path="./config/example.yaml"
config=yaml.safe_load(open(config_path,'r'))

repeat_time= 10 
print(repeat_time)



if args.model=='GMT':
    config['k']=10
    config['heads']=config[args.dataset]['heads']
    
 
save_data=False

if __name__ == '__main__':
    
    dataset=load_dataset(args.dataset,args.model,shuffle=True,)
    dataloaders = data_loader(args.dataset, dataset, config[args.dataset]['batch_size'])
        
    for item in range(repeat_time):
        

        if args.dataset in TUData:
            model=train_model_dist(args.model,
                            dataloaders=dataloaders,
                            dataset=dataset,
                            config=config[args.dataset],
                            device=args.device,
                            wandb_record=False,
                            save_model=True,
                            seed=args.seed,
                            )     
        
        else:
            train_model_dist(args.model, 
                            dataset,
                            dataloaders=dataloaders,
                            config=config[args.dataset],
                            device=args.device,
                            wandb_record=False,
                            save_model=False,
                            seed=args.seed,
                            fromstore=False,
                            evaluator=None if args.dataset in TUData else Evaluator(args.dataset),
                            task_type=None if args.dataset in TUData else dataset.task_type)
        wandb.finish()

