 #!/bin/bash

# Define the classifier names
CLASSIFIER_NAMES="resnet18 resnet34 resnet50 vit_base_patch16_224 vit_small_patch16_224 vit_tiny_patch16_224"

# Define the output file name
OUTPUT_FILE="log_imagenet_random.txt"

# Remove the output file if it exists
if [ -f "$OUTPUT_FILE" ]; then
    rm "$OUTPUT_FILE"
fi

# Loop through the classifier names and run the two Python scripts for each one
for CLASSIFIER_NAME in $CLASSIFIER_NAMES; do
    # Check if the tree file already exists
    if [ -f "imagenet_test_random_${CLASSIFIER_NAME}.json" ]; then
        echo "Tree file already exists for ${CLASSIFIER_NAME}, skipping treev2.py" >> "$OUTPUT_FILE"
    else
        echo "Running treev2.py with classifier $CLASSIFIER_NAME..." >> "$OUTPUT_FILE"
        python random_imagenet.py \
        --support_data_dir /Checkpoint/user/data/tree_data/imagenet_images_256/ \
        --gpu_id 0 \
        --classifier "$CLASSIFIER_NAME" >> "$OUTPUT_FILE"
    fi
    
    echo "Running compute_TED.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_TED.py \
    imagenet_test_random_"$CLASSIFIER_NAME".json \
    imagenet_parsetree_gt.json >> "$OUTPUT_FILE"

    echo "Running compute_mcs.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_mcs.py \
    imagenet_test_random_"$CLASSIFIER_NAME".json \
    imagenet_parsetree_gt.json >> "$OUTPUT_FILE"

    echo "Running compute_tkd.py with classifier $CLASSIFIER_NAME..."
    PYTHONPATH="$PWD" python evaluate/compute_tkd.py \
    imagenet_test_random_"$CLASSIFIER_NAME".json \
    imagenet_parsetree_gt.json >> "$OUTPUT_FILE"
done

echo "All done! Results saved to $OUTPUT_FILE."
