### Code accompaning the paper "Understanding the differences in Foundation Models: Attention, State  Space Models, and Recurrent Neural Networks"
The provided code is a derivative of the [Zoology code base](https://github.com/HazyResearch/zoology) and we provide the necessary license (Apache 2) with the code.
We changed the original code in the following ways:
1. We slightly modified the LogConfig class to include grouping with wandb.
1. We added the mixers linear attention, normalized attention, DSS (Mamba-2), and qLSTM.
1. We modified the MambaBlock to remove the scaffolding.

#### Install instructions
First, ensure you have torch installed, or install it following the instructions [here](https://pytorch.org/get-started/locally/). Then, install Zoology with:
```bash
pip install -e .[extra,analysis]
```
Additional information on Zoology is provided in the [original repo](https://github.com/HazyResearch/zoology).
Finally, install `causal-conv1d` with `pip install causal-conv1d` and obtain the selective scan CUDA interface by installing `mamba-ssm` or building them yourself; all instructions are provided [here](https://github.com/state-spaces/mamba).

#### Reproduce results
Instructions to reproduce the results are stated in a separate README in `zoology/experiments/neurips24/`.