# Adaptive Randomized Smoothing: Certifying Multi-Step Defences against Adversarial Examples

This repository is the official implementation of [Adaptive Randomized Smoothing: Certifying Multi-Step Defences against Adversarial Examples](). *Please note, we are mostly including the code bits relevant to reproduce CIFAR-10 benchmark results here.*


# Our architecture

![pipeline](./assets/pipeline.png)

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Dataset links:
- To run our CIFAR-10 benchmarks, you'll need to download [BG-20k dataset](https://paperswithcode.com/dataset/bg-20k). Manually download the test folder from: https://drive.google.com/drive/folders/1ezt4cj7CNE5Y0Qaot6s4vufpbaf_cT1D and and the training folder from: https://drive.google.com/drive/folders/1NGfgvB5JoNERvCv7k1t2m4dwVxH4Ml30.


## CIFAR-10 benchmark

### Training

For k=48, edges location, 20kBG nature setup, use 

- Training:     ```bash train.sh``` (uses a UNET architecture as the mask model and cifar_resnet110 as the base classifier)
- Certification:   ```bash certify.sh```   (*make sure you pass the correct log path to the "log_folder" argument to this script*)

All our hyperparameters are listed in Table 3 in Appendix C.


## Results

This is a snapshot of our CIFAR-10 benchmark results from the paper:

![cifar10-benchmark](./assets/cifar-10-benchmark.jpeg)

<include the screenshot link>


## Contributing

>📋  See license