## Balance_prompt
balance_prompt = {
    "name": "Balance prompts",
    "definition": """
    Raw balance variables are integer variables that typically refer to an amount of currency owned by a single user.
    They are typically passed in as parameters, or field of parameters in functions that deposit, withdraw, mint, burn, pay, etc.
    "raw balance" variables typically have names that include keywords: "amount", "balance", and "user".
    """,
    "introp1": "Raw balance generally refers to an amount of some currency owned by a user. This is fundamentally different from reserve, which is an amount of currency owned by the contract or other non-user entities.", #The following are some examples of reserve token types. These should not be categorized as the balance financial type, and therefore should not be output."
    "introp2": "The following are examples of variables of the raw balance financial type. The format of the examples are: a snippet of code containing the variable followed by the name of the variables belonging to the category, followed by the reason it is categorized as such.",
    "ex1": "Code: 'function _deposit(uint256 _amount) internal override {\n// We receive bCVX -> Convert to bCVX\nCVX_VAULT.withdraw(_amount);\nuint256 toDeposit = IERC20Upgradeable(CVX).balanceOf(address(this));\n// Lock tokens for 17 weeks, send credit to strat, always use max boost cause why not?\nLOCKER.lock(address(this), toDeposit, LOCKER.maximumBoostPayment());\n}',\nVariables: '_amount'",
    "ex2": """Code: '/// @dev used to manage the governance and strategist fee on earned rewards, make sure to use it to get paid!
        function _processRewardsFees(uint256 _amount, address _token)
            internal
            returns (uint256 governanceRewardsFee, uint256 strategistRewardsFee)
        {
            governanceRewardsFee = _processFee(
                _token,
                _amount,
                performanceFeeGovernance,
                IController(controller).rewards()
            );

            strategistRewardsFee = _processFee(
                _token,
                _amount,
                performanceFeeStrategist,
                strategist
            );
        }'
        Raw Balance Variables: '_amount'
        Reason: ('_amount') The name '_amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount. 
        A user fee is generated from '_amount()' via the function "processFee()".
        """,
    "ex3": """Code: 'function transferFrom(address sender, address recipient, uint256 amount) public virtual override returns (bool) {
            /// The _balances mapping represents the underlying ibBTC shares ("non-rebased balances")
            /// Some naming confusion emerges due to maintaining original ERC20 var names

            uint256 amountInShares = balanceToShares(amount);

            _transfer(sender, recipient, amountInShares);
            _approve(sender, _msgSender(), _allowances[sender][_msgSender()].sub(amountInShares, "ERC20: transfer amount exceeds allowance"));
            return true;
        }'
        Raw Balance Variables: 'amount', 'amountInShares'
        Reason: ('amount') The name 'amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount. 
        It is converted to a 'raw balance' variable, 'amountInShares', representing an amount of another currency via the function 'balanceOfShares()'. 
        Reason: ('amountInShares') The name `amountInShares' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt.
        It seems to be converted from the variable 'amount' representing 'raw balance' in the function 'balanceToShares()'.
        It is used in the function '_transfer()', which transfers 'amountInShares' tokens from the 'sender' to the 'recipient'.
        It is decreased from the allowance of the user '_msgSender()'.
        The allowance of the user '_msgSender()' is decreased by 'amountInShares'. 
        """,
    "ex4": """Code: "function deposit(uint256 _amount) external whenNotPaused {
        _depositWithAuthorization(_amount, new bytes32[](0));
        }"
        Raw Balance Variables: "_amount"
        Reason: ('_amount') The name '_amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount.
        It is used in the function '_depositWithAuthorization()', which seems to deposit the '_amount' of a currency.
        """,
    "ex5": """Code: "function _calculateFee(uint256 amount, uint256 feeBps)
                internal
                pure
                returns (uint256)
            {
                if (feeBps == 0) {
                    return 0;
                }
                uint256 fee = (amount * feeBps) / MAX_BPS;
                return fee;
            }"
        Raw Balance Variables: "amount"
        Reason: ('amount') The name 'amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount.
        It is multiplied by 'compound fee ratio' variable 'feeBps' to generate a user fee, 'fee'.
        Compound Fee Ratio Variables: "feeBps"
        Reason: ('feeBps') The name 'feeBps' has the word 'fee' in it, implying it having to do with fees.
        It is multiplied by a raw balance, "amount" to create a user fee, "fee".
        Fee Variables: "fee"
        Reason: ('fee') The name 'fee' implies that it is a fee.
        It is generated by a raw balance, 'amount' being multiplied by the compound fee ratio, 'feeBps'
        """,
    "ex6": """Code:  "function sendFundsToUser(
                address tokenAddress,
                uint256 amount,
                address payable receiver,
                bytes memory depositHash,
                uint256 tokenGasPrice,
                uint256 fromChainId
            ) external nonReentrant onlyExecutor tokenChecks(tokenAddress) whenNotPaused {
                uint256 initialGas = gasleft();
                require(
                    tokenManager.getTransferConfig(tokenAddress).min <= amount &&
                        tokenManager.getTransferConfig(tokenAddress).max >= amount,
                    "Withdraw amnt not in Cap limits"
                );
                require(receiver != address(0), "Bad receiver address");

                (bytes32 hashSendTransaction, bool status) = checkHashStatus(tokenAddress, amount, receiver, depositHash);

                require(!status, "Already Processed");
                processedHash[hashSendTransaction] = true;

                uint256 amountToTransfer = getAmountToTransfer(initialGas, tokenAddress, amount, tokenGasPrice);
                liquidityProviders.decreaseCurrentLiquidity(tokenAddress, amountToTransfer);

                if (tokenAddress == NATIVE) {
                    require(address(this).balance >= amountToTransfer, "Not Enough Balance");
                    (bool success, ) = receiver.call{value: amountToTransfer}("");
                    require(success, "Native Transfer Failed");
                } else {
                    require(IERC20Upgradeable(tokenAddress).balanceOf(address(this)) >= amountToTransfer, "Not Enough Balance");
                    SafeERC20Upgradeable.safeTransfer(IERC20Upgradeable(tokenAddress), receiver, amountToTransfer);
                }

                emit AssetSent(tokenAddress, amount, amountToTransfer, receiver, depositHash, fromChainId);"
        Raw Balance Variables: "amount", "amountToTransfer"
        Reason: ("amount") The name 'amount' seems to refer to an amount of some kind of currency.
        There is a mesage in the first "require()" statement that reads: "Withdraw amnt not in Cap Limits", which is thrown when the variable "amount" does not fall within a certain range.
        It is used in the function "computeAmountToTransfer" to compute "amountToTransfer", which is a raw balance variable, as demonstrated in the next explanation:
        Reason: ("amountToTransfer") The name 'amountToTransfer' seems to refer to an amount of some kind of currency.
        The message from the two "require()" statements comparing 'amountToTransfer' read: "Not Enough Balance", further alluding to its usage as a balance.
        It is used in both a "call()" function, as well as an ERC20.safeTransfer() function, both of which are typically used to transfer balances.
        Reserve Variables: "address(this).balance", "IERC20Upgradeable(tokenAddress).balanceOf(address(this)"
        Reason: ("address(this).balance") The name 'address(this).balance' alludes to the variable representing a balance of some currency.
        However, address(this) represents the address of the contract, not a user.
        Hence, it is not a raw balance, and is more likely to be a reserve.
        """ #TODO?
        ,
    "ex7": """Code: "function safeConcurTransfer(address _to, uint _amount) private {
                uint concurBalance = concur.balanceOf(address(this));
                bool transferSuccess = false;
                if (_amount > concurBalance) {
                    transferSuccess = concur.transfer(_to, concurBalance);
                } else {
                    transferSuccess = concur.transfer(_to, _amount);
                }
                require(transferSuccess, "safeConcurTransfer: transfer failed");
            }"
        Raw Balance Variable: "_amount"
        """,
    "ex8": """Code: "function withdraw(uint256 _amount) external returns (uint256 _retVal) {
                uint256 _supply = totalSupply();
                require(_supply != 0, "ERROR: NO_AVAILABLE_LIQUIDITY");

                uint256 _liquidity = originalLiquidity();
                _retVal = (_amount * _liquidity) / _supply;

                require(
                    marketStatus == MarketStatus.Trading,
                    "ERROR: WITHDRAWAL_PENDING"
                );
                require(
                    withdrawalReq[msg.sender].timestamp +
                        parameters.getLockup(msg.sender) <
                        block.timestamp,
                    "ERROR: WITHDRAWAL_QUEUE"
                );
                require(
                    withdrawalReq[msg.sender].timestamp +
                        parameters.getLockup(msg.sender) +
                        parameters.getWithdrawable(msg.sender) >
                        block.timestamp,
                    "ERROR: WITHDRAWAL_NO_ACTIVE_REQUEST"
                );
                require(
                    withdrawalReq[msg.sender].amount >= _amount,
                    "ERROR: WITHDRAWAL_EXCEEDED_REQUEST"
                );
                require(_amount > 0, "ERROR: WITHDRAWAL_ZERO");
                require(
                    _retVal <= availableBalance(),
                    "ERROR: WITHDRAW_INSUFFICIENT_LIQUIDITY"
                );
                //reduce requested amount
                withdrawalReq[msg.sender].amount -= _amount;

                //Burn iToken
                _burn(msg.sender, _amount);

                //Withdraw liquidity
                vault.withdrawValue(_retVal, msg.sender);

                emit Withdraw(msg.sender, _amount, _retVal); ..."
        Raw Balance Variables: "_amount", "_retVal"
        """,
    "ex9": """Code: " function depositAVAX()
                        external
                        payable
                        isStopped(false)
                        atPhase(Phase.PhaseOne)
                    {
                        require(msg.sender != issuer, "LaunchEvent: issuer cannot participate");
                        require(
                            msg.value > 0,
                            "LaunchEvent: expected non-zero AVAX to deposit"
                        );

                        UserInfo storage user = getUserInfo[msg.sender];
                        uint256 newAllocation = user.balance + msg.value;
                        require(
                            newAllocation <= maxAllocation,
                            "LaunchEvent: amount exceeds max allocation"
                        );

                        uint256 rJoeNeeded;
                        // check if additional allocation is required.
                        if (newAllocation > user.allocation) {
                            // Burn tokens and update allocation.
                            rJoeNeeded = getRJoeAmount(newAllocation - user.allocation);
                            // Set allocation to the current balance as it's impossible
                            // to buy more allocation without sending AVAX too
                            user.allocation = newAllocation;
                        }

                        user.balance = newAllocation;
                        wavaxReserve += msg.value;

                        if (rJoeNeeded > 0) {
                            rJoe.burnFrom(msg.sender, rJoeNeeded);
                        }

                        WAVAX.deposit{value: msg.value}();"
                Raw Balance Variables: "msg.value", "user.balance", "newAllocation"
                Reason ('msg.value'): 'msg.value' is a special variable that represents an amount of currency passed in when calling a payable function.
                It is also added with variable 'user.balance', which can be infered to be a "raw balance" from its name.
                There is a require statement that reverts when 'msg.value' is 0, stating that the "deposited currency must be greater than 0".
                Reason ('user.balance'): The name 'user.balance' implies that the variable is a balance of a user.
                It is used in operations with 'msg.value', which is an amount of currency passed in by the user in a payable function call.
                Reason ('newAllocation'): There is an operation that assigns "user.balance" = "newAllocation".
                "user.balance" is a raw balance, so "newAllocation" must also be a raw balance.
                Reserve Variables: "wavaxReserve"
                Reason ('wavaxReserve'): 'wavaxReserve' is appended by 'msg.value', hence it is an amount of a currency.
                The name 'wavaxReserve' implies that the variable is a reserve, or balance of the contract.
                'wavaxReserve' is a global variable, hence it is not likely to be a user balance.
                

                """,
    "ex10": """Code: " function initiateVaultFillingZcTokenInitiate(Hash.Order calldata o, uint256 a, Sig.Components calldata c) internal {
            // checks order signature, order cancellation and order expiry
            bytes32 hash = validOrderHash(o, c);

            // checks the taker amount passed to amount available in the order
            require(a <= (o.premium - filled[hash]), 'taker amount > available volume');

            // adds the taker amount to the order's filled amount
            filled[hash] += a;

            // calculate principal filled and fee
            uint256 principalFilled = (((a * 1e18) / o.premium) * o.principal) / 1e18;
            uint256 fee = ((principalFilled * 1e18) / fenominator[2]) / 1e18;

            // transfer underlying tokens
            Erc20 uToken = Erc20(o.underlying);
            uToken.transferFrom(msg.sender, o.maker, a);
            uToken.transferFrom(o.maker, address(this), principalFilled);

            // deposit underlying to Compound and mint cTokens
            MarketPlace mPlace = MarketPlace(marketPlace);
            address cTokenAddr = mPlace.cTokenAddress(o.underlying, o.maturity);
            uToken.approve(cTokenAddr, principalFilled);
            require(CErc20(cTokenAddr).mint(principalFilled) == 0, 'minting CToken failed');

            // mint <principalFilled> zcTokens + nTokens and allocate appropriately in marketplace
            require(mPlace.custodialInitiate(o.underlying, o.maturity, o.maker, msg.sender, principalFilled), 'custodial initiate failed');

            // transfer fee in vault notional to swivel (from msg.sender)
            require(mPlace.transferVaultNotionalFee(o.underlying, o.maturity, msg.sender, fee), "notional fee transfer failed");

            emit Initiate(o.key, hash, o.maker, o.vault, o.exit, msg.sender, a, principalFilled);
        }"
        Raw Balance Variable: "a"
        """
    
}

## Debt prompt
debt_prompt = {
    "definition":"""
    Debt variables represent an amount of currency that a user has borrowed, or the user owes.
    They are commonly found in functions that perform borrowing/lending.
    Keywords include: "debt".
    """,
    "ex1":"""function deposit(address _recipient, uint _pid, uint _amount) external nonReentrant onlyDepositor {
        PoolInfo storage pool = poolInfo[_pid];
        UserInfo storage user = userInfo[_pid][_msgSender()];
        updatePool(_pid);

        if(user.amount > 0) {
            uint pending = user.amount * pool.accConcurPerShare / _concurShareMultiplier - user.rewardDebt;
            if (pending > 0) {
                safeConcurTransfer(_recipient, pending);
            }
        }

        if (_amount > 0) {
            if (pool.depositFeeBP > 0) {
                uint depositFee = _amount.mul(pool.depositFeeBP).div(_perMille);
                user.amount = SafeCast.toUint128(user.amount + _amount - depositFee);
            } else {
                user.amount = SafeCast.toUint128(user.amount + _amount);
            }
        }

        user.rewardDebt = SafeCast.toUint128(user.amount * pool.accConcurPerShare / _concurShareMultiplier);
        emit Deposit(_recipient, _pid, _amount);
            }"
        Reason("user.rewardDebt"): "user.rewardDebt" is decreased from the raw balance, "_amount" in the deposit function. Intuitively, it seems to be decrementing the amount owned by a user.
        """ 
        ,
        "ex2":"""function pendingRJoe(address _user) external view returns (uint256) {
        UserInfo storage user = userInfo[_user];
        uint256 joeSupply = joe.balanceOf(address(this));
        uint256 _accRJoePerShare = accRJoePerShare;

        if (block.timestamp > lastRewardTimestamp && joeSupply != 0) {
            uint256 multiplier = block.timestamp - lastRewardTimestamp;
            uint256 rJoeReward = multiplier * rJoePerSec;
            _accRJoePerShare += (rJoeReward * PRECISION) / joeSupply;
        }
        return (user.amount * _accRJoePerShare) / PRECISION - user.rewardDebt;
    } Reason("user.rewardDebt"): The name seems to apply that the varialbe represents a debt. Furthermore, the debt is decremented from user.amount, which appears to be a raw balance, hence representing a user paying off some owed amount""",

    "ex3":""""function payOff(address _user, uint256 amount) external nonReentrant returns (uint256){
                if(amount > userDebt[_user]){
                    _deposit(_user, amount - userDebt[_user]);
                    userDebt[_user] = 0;
                }       
                else{
                    userDebt[_user] -= amount;
                }
                return(userDebt[_user])
    }" Reason ("userDebt"): "userDebt seems to keep track of the amount of debt owned by a user. As evidence, the function name 'payoff' appears to mean that some debt is being paid off. Furthermore, the userDebt is decreased by the raw balance, amount that is passed as a parameter.
"""
}

## Price prompt
price_prompt = {
    "definition":"""
    Price variables represent a price to convert an amount of one currency to another.
    They are typically multiplied/divided by "raw balance" variables.
    Alternatively, they can be created by dividing two "raw balance" variables.
    Keywords that may identify price variables include: "price", "AToB", and "APerB", where A and B are names of currencies.
    """
    ,
    "ex1": """Code: "function allocateCredit(uint256 _credit)
        external
        override
        returns (uint256 _pending)
    {
        require(
            IRegistry(registry).isListed(msg.sender),
            "ERROR: ALLOCATE_CREDIT_BAD_CONDITIONS"
        );
        IndexInfo storage _index = indicies[msg.sender];
        uint256 _rewardPerCredit = rewardPerCredit;
        if (_index.exist == false) {
            _index.exist = true;
            indexList.push(msg.sender);
        } else if (_index.credit > 0) {
            _pending = _sub(
                (_index.credit * _rewardPerCredit) / MAGIC_SCALE_1E6,
                _index.rewardDebt
            );
            if (_pending > 0) {
                vault.transferAttribution(_pending, msg.sender);
                attributionDebt -= _pending;
            }
        }
        if (_credit > 0) {
            totalCredit += _credit;
            _index.credit += _credit;
            emit CreditIncrease(msg.sender, _credit);
        }
        _index.rewardDebt =
            (_index.credit * _rewardPerCredit) /
            MAGIC_SCALE_1E6;
    }"
    Raw Balance Variable: "_credit"
    Reason ("_credit"): The name "_credit", and the variable being a "uint256" integer implies that it is an amount of a currency.
    It is multiplied by a "price" variable, "_reservePerCredit", and the result is used in a "transfer" function, "transferAttribution()".
    Price Variable: "_reservePerCredit"
    Reason "_reservePerCredit": The name "_reservePerCredit" contains the word "Per", implying that it is an amount of currency per another amount of currency, i.e. a price.
    It is multiplied by a "raw balance" variable, "_credit".
    Reserve Variable: "totalCredit"
    Reason "totalCredit": The variable "totalCredit" is a global variable.
    It is increased by "_credit" in the function, which represents an increase to the total amount of currency stored in the various acounts in the contract.
    """
    ,
    "ex2":"""Code: ""function _withdrawSome(uint256 _amount)
        internal
        override
        returns (uint256)
    {
        uint256 max = IERC20Upgradeable(want).balanceOf(address(this));

        if (withdrawalSafetyCheck) {
            uint256 bCVXToCVX = CVX_VAULT.getPricePerFullShare(); // 18 decimals
            require(bCVXToCVX > 10**18, "Loss Of Peg"); // Avoid trying to redeem for less / loss of peg
            require(
                max >= _amount.mul(9_980).div(MAX_BPS),
                "Withdrawal Safety Check"
            ); // 20 BP of slippage
        }

        if (max < _amount) {
            return max;
        }

        return _amount;
    }"
    Raw Balance Variable: "_amount"
    Reason ("_amount"): The name "_amount", and the variable being a "uint256" integer implies that it is an amount of a currency.
    The fuction appears to perform a withdraw operation, evidenced by it's name: "_withdrawSome", and the variable "_amount" seems to represent the amount of currency to withdraw.
    Price Variable: "bCXToCVX"
    Reason ("bCXToCVX"): The name "bCXToCVX" implies that it is a price variable due to it including the word "to".
    Additionally, it is obtained by calling the function "CVX.getPricePerFullShare()", which also implies that it is a price, more specifically, for the CVX currency.
    """
    ,
    "ex3":"""function balanceOfToken(address addr) external view override returns (uint256 mAssets) {
        uint256 exchangeRate = savings.exchangeRate();
        mAssets = (imBalances[addr] * exchangeRate) / 1e18;
    }
    Raw Balance Variable: "imBalances[]"
    Reason ("imBalances[]"): The name of "imBalances[]" implies that is used to store "balances". 
    Additionally, it is observed that "imBalances[]" takes as keys addresses, hence the array is likely to hold the "balance" of an "address", and is likely to store user balances.
    Price Variable: "exchangeRate"
    Reason("exchangeRate"): The name "exchangeRate" implies that the variable is an exchange rate from one currency to another, and hence a price.
    Additionally, it is obtained by calling the function "savings.exchangeRate()", which supports the idea of it being a price.
    """
    ,
    "ex4":"""
    """
}

## Fee Prompt
simple_fee_prompt = {
    "definition": """
    Fee Rate Variables are variables that refer to the percentage of a "balance" variable that is collected by the contract.
    Typical signs of "fee rate" variables are the word "fee" appearing in the variable name.
    Simple fee rates result in a "balance" variable after they are applied, while complex fee rates result in an intermediate "fee"value that is eventually added or subtracted from a "balance".
    """,
    "ex1": """Code:
    function calculatingFee(uint256 amount) public view returns (uint256) {
        return (originationFee * amount) / WAD;
    }
    Raw Balance Variable: "amount"
    Reason ("amount"): The name "amount" implies that it is an amount of a currency.
    Fee Rate Variable: "originationFee"
    Reason ("originationFee"): The name "originationFee" implies that it has relation to a "fee".
    Additionally, it is multiplied by a raw balance variable, hence providing evidence that it is a ratio or rate, and hence the variable is a fee ratio variable.
    """
    ,
    "ex2":"""Code:
    function repay(uint256 tokenId, bool skim) public returns (uint256 amount) {
        TokenLoan memory loan = tokenLoan[tokenId];
        require(loan.status == LOAN_OUTSTANDING, "NFTPair: no loan");
        TokenLoanParams memory loanParams = tokenLoanParams[tokenId];
        require(
            // Addition is safe: both summands are smaller than 256 bits
            uint256(loan.startTime) + loanParams.duration > block.timestamp,
            "NFTPair: loan expired"
        );

        uint128 principal = loanParams.valuation;

        // No underflow: loan.startTime is only ever set to a block timestamp
        // Cast is safe: if this overflows, then all loans have expired anyway
        uint256 interest = calculateInterest(principal, uint64(block.timestamp - loan.startTime), loanParams.annualInterestBPS).to128();
        uint256 fee = (interest * PROTOCOL_FEE_BPS) / BPS;
        amount = principal + interest;

        uint256 totalShare = bentoBox.toShare(asset, amount, false);
        uint256 feeShare = bentoBox.toShare(asset, fee, false);

        address from;
        if (skim) {
            require(bentoBox.balanceOf(asset, address(this)) >= (totalShare + feesEarnedShare), "NFTPair: skim too much");
            from = address(this);
            // No overflow: result fits in BentoBox
        } else {
            bentoBox.transfer(asset, msg.sender, address(this), feeShare);
            from = msg.sender;
        }
        // No underflow: PROTOCOL_FEE_BPS < BPS by construction.
        feesEarnedShare += feeShare;
        delete tokenLoan[tokenId];

        bentoBox.transfer(asset, from, loan.lender, totalShare - feeShare);
        collateral.transferFrom(address(this), loan.borrower, tokenId);

        emit LogRepay(from, tokenId);
    }
    """,
    "ex3":"""Code:
    function redeem(uint256 _longAmount, uint256 _shortAmount) external override nonReentrant {
    require(longToken.balanceOf(msg.sender) >= _longAmount, "Insufficient long tokens");
    require(shortToken.balanceOf(msg.sender) >= _shortAmount, "Insufficient short tokens");

    uint256 _collateralAmount;
    if (finalLongPayout <= MAX_PAYOUT) {
      uint256 _shortPayout = MAX_PAYOUT - finalLongPayout;
      _collateralAmount = (finalLongPayout * _longAmount + _shortPayout * _shortAmount) / MAX_PAYOUT;
    } else {
      require(_longAmount == _shortAmount, "Long and Short must be equal");
      _collateralAmount = _longAmount;
    }

    uint256 _actualFee;
    uint256 _expectedFee = (_collateralAmount * redemptionFee) / FEE_DENOMINATOR;
    if (redemptionFee > 0) { require(_expectedFee > 0, "fee = 0"); }
    else { require(_collateralAmount > 0, "amount = 0"); }
    if (address(_redeemHook) != address(0)) {
      collateral.approve(address(_redeemHook), _expectedFee);
      uint256 _collateralAllowanceBefore = collateral.allowance(address(this), address(_redeemHook));
      _redeemHook.hook(msg.sender, _collateralAmount, _collateralAmount - _expectedFee);
      _actualFee = _collateralAllowanceBefore - collateral.allowance(address(this), address(_redeemHook));
      collateral.approve(address(_redeemHook), 0);
    } else { _actualFee = 0; }

    longToken.burnFrom(msg.sender, _longAmount);
    shortToken.burnFrom(msg.sender, _shortAmount);
    uint256 _collateralAfterFee = _collateralAmount - _actualFee;
    collateral.transfer(msg.sender, _collateralAfterFee);

    emit Redemption(msg.sender, _collateralAfterFee, _actualFee);
  }
    """
}

## Interest rate Prompt
interest_prompt = {
    "definition":"""
    Interest Rate Variables are variables that refer to the interest rate applied to a "debt" or "balance" variable.
    They are often used together with variables that represent a "balance" to create interest.
    Typically, debt is accrued as time passes, and interest rate variables store the rate.
    Simple interest rates directly result in a "debt" or "balance" variable after they are applied, while complex interest rates results in an intermediate "interest" value that is eventually added or subtracted from a "debt" or "balance" variable.
    In the event that simple/complex is not able to be determined, assume complex.
    """,
    "definition_v2":"""
    Interest Rate Variables are integer variables that define an "interest" taken from a "debt" or "balance" variable.
    They are rates, which means that their operations consist of a pair of a numerator and a denominator.
    However, the denominator should not be treated as another interest rate variable.
    They also have, or are used in functions or operations with other variables that have the word "interest" in them.
    Interest Rates can be added or subtracted to other interest rates.
    Balance variables (integer variables that store an amount of a currency or token) are multiplied or divided by Interest Rate Variables.
    Interest Rate Variables are either Simple or Complex.
    When Balance variables are multiplied by Simple Interest Variables, the result is a "Balance" variable.
    Sometimes this function can be done using a "*=" operation.
    When Balance variables are multiplied by Complex Interest Variables, the result is a "Interest" variable.
    "Interest" Variables are added or subtracted from a "Balance" variable, usually in a later operation.
    They often have the word "interest" in their names.
    """,
    "ex1": """Code: "function interestPerSecond(uint256 _principal) public view returns (uint256) {
        uint256 _interest = ((_principal).mul(poolConstants.borrowRate)).div(365 days);
        return _interest;
    }"
    Raw Balance: "_principal"
    Reason ("_principal"): The name "_principal" implies that it is an amount of a currency.
    Additionally, "_principal" is used to generate the variable "_interest" by multiplying by a variable "poolConstants.borrowRate", which seems to be an "interest rate" variable.
    This means that "_principal" previously had not had interest applied to it, and hence should be a "raw balance".
    Complex Interest Rate: "poolConstants.borrowRate": The name implies that the variable represents a rate.
    The value "365 days" can be treated as the denominator of the rate pair, along with "poolConstants.borrowRate".
    It is used to multiply the variable "_principal" in order to create the variable "_interest".
    The the name of the result "_interest" implies that "poolConstants.borrowRate" has relation to "Interest".
    Hence, it can be inferred that the variable "poolConstants.borrowRate" is an "Interest Rate" Variable.
    """
    ,
    "ex2":"""Code: "function _deposit(uint256 yieldTokenAmount, address recipient)
        internal
        returns (
            uint256 mintedShares,
            uint256 depositedBT,
            uint256 fee,
            uint256 rate
        )
    {
        require(!matured, "Maturity reached.");
        rate = updateInterestRate();
        require(rate >= initialInterestRate, "Negative yield!");

        // Collect fees if they are set, reducing the number of tokens for the sender
        // thus leaving more YBT in the TempusPool than there are minted TPS/TYS
        uint256 tokenAmount = yieldTokenAmount;
        uint256 depositFees = feesConfig.depositPercent;
        if (depositFees != 0) {
            fee = tokenAmount.mulfV(depositFees, yieldBearingONE);
            tokenAmount -= fee;
            totalFees += fee;
        }

        // Issue appropriate shares
        depositedBT = numAssetsPerYieldToken(tokenAmount, rate);
        mintedShares = numSharesToMint(depositedBT, rate);

        PrincipalShare(address(principalShare)).mint(recipient, mintedShares);
        YieldShare(address(yieldShare)).mint(recipient, mintedShares);
    }"
    Raw Balance: "tokenAmount"
    Interest Rate: "rate", "initialInterestRate"
    Reason ("rate"): The variable "rate" is implied to be a rate from the name.
    It is set as the result of the function "updateInterestRate()", hence has relation to "Interest".
    Additionally, it is compared to a variable "initialInterestRate", which from the name, is implied to be an interest rate.
    It is used as a parameter in the function "numAssetsPerYieldToken()", along with "tokenAmount", which is a "raw balance".
    It can be infered that this function is applying the interest rate to the raw balanace.
    It is used as a parameter in the function "numSharesToMint()", along with "depositedBT", which is a "raw balance".
    It can be infered that this function is applying the interest rate to the raw balanace.
    However, simple/complex cannot be determined from the code, as the two functions are not included.
    Fee Rate: depositFees
    """
    ,
    "ex3":"""Code: "function _accrueInterest(address _token) internal {
        uint blocksElapsed = block.number - lastBlockAccrued;
        uint newInterest = _borrowRatePerBlock(_token) * blocksElapsed;
        cumulativeInterestRate[_token] += newInterest;
    }"
    Interest Rate: "cumulativeInterestRate"
    Reason ("cumulativeInterestRate"): The name implies that the variable is an interest rate.
    Additionally, it is added with variable "newInterst", which is an interest rate.
    """
    ,
    "ex4":"""Code: function getSupplyRate(uint256 reserveFactorMantissa) public view override returns (uint256) {
        require(reserveFactorMantissa <= 1e18, "reserveFactorMantissa error");
        uint256 ratio = uint256(1e18) - reserveFactorMantissa;
        return (interestRatePerBlock * ratio) / 1e18;
    }
    Interest Rate: "interestRateperBlock"
    Reason ("interestRatePerBlock"): The name implies that the variable is used as an interest rate.
    """
    ,
    "ex5":"""Code:
    function getRedemptionAmounts(
        uint256 principalAmount,
        uint256 yieldAmount,
        uint256 currentRate
    )
        private
        view
        returns (
            uint256 redeemableYieldTokens,
            uint256 redeemableBackingTokens,
            uint256 redeemFeeAmount,
            uint256 interestRate
        )
    {
        interestRate = effectiveRate(currentRate);

        if (interestRate < initialInterestRate) {
            redeemableBackingTokens = (principalAmount * interestRate) / initialInterestRate;
        } else {
            uint256 rateDiff = interestRate - initialInterestRate;
            // this is expressed in percent with exchangeRate precision
            uint256 yieldPercent = rateDiff.divfV(initialInterestRate, exchangeRateONE);
            uint256 redeemAmountFromYieldShares = yieldAmount.mulfV(yieldPercent, exchangeRateONE);

            // TODO: Scale based on number of decimals for tokens
            redeemableBackingTokens = principalAmount + redeemAmountFromYieldShares;

            // after maturity, all additional yield is being collected as fee
            if (matured && currentRate > interestRate) {
                uint256 additionalYieldRate = currentRate - interestRate;
                uint256 feeBackingAmount = yieldAmount.mulfV(
                    additionalYieldRate.mulfV(initialInterestRate, exchangeRateONE),
                    exchangeRateONE
                );
                redeemFeeAmount = numYieldTokensPerAsset(feeBackingAmount, currentRate);
            }
        }

        redeemableYieldTokens = numYieldTokensPerAsset(redeemableBackingTokens, currentRate);

        uint256 redeemFeePercent = matured ? feesConfig.matureRedeemPercent : feesConfig.earlyRedeemPercent;
        if (redeemFeePercent != 0) {
            uint256 regularRedeemFee = redeemableYieldTokens.mulfV(redeemFeePercent, yieldBearingONE);
            redeemableYieldTokens -= regularRedeemFee;
            redeemFeeAmount += regularRedeemFee;

            redeemableBackingTokens = numAssetsPerYieldToken(redeemableYieldTokens, currentRate);
        }
    }
    """
}

## Reserve prompt

reserve_prompt = {
    "definition":"""
    Reserve Variables represent the total amount of a currency owned by a contract.
    They are typically integer global variables.
    They are typically incremented/decremented in functions that deposit/withdraw currency, respectively.
    """,
    "ex1": """Code: " function timelockDepositTo(
    address to,
    uint256 amount,
    address controlledToken
  )
    external
    onlyControlledToken(controlledToken)
    canAddLiquidity(amount)
    nonReentrant
  {
    address operator = _msgSender();
    _mint(to, amount, controlledToken, address(0));
    _timelockBalances[operator] = _timelockBalances[operator].sub(amount);
    timelockTotalSupply = timelockTotalSupply.sub(amount);

    emit TimelockDeposited(operator, to, controlledToken, amount); "
    Raw Balance Variables: "amount", "_timelockBalances"
    Reason ("amount"): The name "amount" implies that the integer is an amount of a currency.
    It is a parameter, hence is not likely to be a "reserve" variable.
    It is used in a mint operation, "_mint()" to mint the amount to a user.
    Reason ("_timelockBalances"): The name of the array includes the word "Balances", and takes as key the variable "operator".
    Hence, it can be implied to store the balance of all of the users.
    As the balance is stored per user, and there are no fees applied to the balance, it is a "raw balance".
    
    Reserve Variables: "timelockTotalSupply"
    Raw Balance Variables: "amount", "_timelockBalaces[]"
    """
    ,
    "ex2":"""Code:
    function fund(address[] calldata _recipient, uint256[] calldata _amount) external nonReentrant {
        require(!initialised, "initialised already");

        uint256 totalAmount = 0;
        for (uint256 i = 0; i < _recipient.length; i++) {
            uint256 amount = _amount[i];

            totalLocked[_recipient[i]] += amount;
            totalAmount += amount;

            emit Funded(_recipient[i], amount);
        }
        rewardToken.safeTransferFrom(msg.sender, address(this), totalAmount);
        initialised = true;
    }
    """
    ,
    "ex3":"""Code:
    function processWithdrawals() external {
        uint reserve = reserveToken.balanceOf(address(this));
        require(reserve >= withdrawals[start].amount, 'Cannot process withdrawals at this time: Not enough balance');
        uint i = start;
        while (i < withdrawals.length && (i - start) <= maxWithdrawalProcesses) {
            Withdrawal memory withdrawal = withdrawals[i];
            if (reserve < withdrawal.amount) {
                break;
            }
            reserveToken.safeTransfer(withdrawal.usr, withdrawal.amount);
            reserve -= withdrawal.amount;
            i += 1;
        }
        start = i;
    }
    """
}
