# NeurIPS 2024 Submission: ABAuditor


ABAuditor is a hybrid LLM and rule-based reasoning system for detecting accounting bugs in smart contracts.

This code package contains the code as well as instructions to run the code.

We have also provided one benchmark case and its dependencies, and include a detailed description and explanation of the expected output.

## Source

The source code for our tool can be found in the directory: `slither/detectors/my_detectors`. In particular, `tcheck.py` is the main engine.

The few-shot prompts we used in our tool can found in the file `few-shot prompts.py`.
Each the 6 financial meanings has a dictionary which includes the `"definition"` of the financial meaning, along with a few examples of real-world Solidity functions containing variables of the financial meaning, labeled `"ex1"`, `"ex2"`, ... .

Here is one few-shot example included for the financial meaning of `balance`:
```
"ex2": """Code: '/// @dev used to manage the governance and strategist fee on earned rewards, make sure to use it to get paid!
        function _processRewardsFees(uint256 _amount, address _token)
            internal
            returns (uint256 governanceRewardsFee, uint256 strategistRewardsFee)
        {
            governanceRewardsFee = _processFee(
                _token,
                _amount,
                performanceFeeGovernance,
                IController(controller).rewards()
            );

            strategistRewardsFee = _processFee(
                _token,
                _amount,
                performanceFeeStrategist,
                strategist
            );
        }'
        Raw Balance Variables: '_amount'
        Reason: ('_amount') The name '_amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount. 
        A user fee is generated from '_amount()' via the function "processFee()".
```
The example depicts how variable `_amount` in the function `_processRewardsFee` is a raw balance.

The format prompt for our reasoning trace can be found in file `reasoning_trace_prompts.txt`. It will be combined with the related operations trace generated for an accounting bug, and prompted to GPT

## Setup

To setup our tool, please run the command `./onlyBuild.sh` in the currenct directory. 
The command should automatically install ABAuditor in the system. 
To test, please run the command `slither`. The result should be something like so:

```
/your/working/directory$ slither
usage: slither target [flag]

target can be:
        - file.sol // a Solidity file
        - project_directory // a project directory. See https://github.com/crytic/crytic-compile/#crytic-compile for the supported platforms
...
```
Additionally, fill in your OPENAI_API_KEY to the file `my_api_key.py`. Doing so is necessary to invoke the GPT API.


## Benchmark

Our benchmark test case can be found in the `Benchmark` directory. 
Due to space concerns (the full benchmark requires > 20 GB), we only provide one project, `MarginSwap`.

The benchmark test is run on the `HourlyBondSubscriptionLending.sol` file in `Benchmark/MarginSwap/contracts/`.

## Tests

To run the reduced tests, run the following code: `./test_minbenchmark.sh` in a Linux environment.

The expected results are:
```
/your/working/directory$ ./test_benchmark_final.sh 1 > output.txt
'solc --version' running
'solc HourlyBondSubscriptionLending.sol --combined-json abi,ast,bin,bin-runtime,srcmap,srcmap-runtime,userdoc,devdoc,hashes,compact-format --allow-paths .,/your/working/directory/ABAuditor/Benchmark/MarginSwap/contracts' running

 typecheck error: Var name: TMP_28 Func name: applyInterest in RETURN (balance * accumulatorFP) / yieldQuotientFP
 typecheck error: Var name: TMP_57 Func name: updateHourlyBondAmount in NEW VARIABLE deltaAmount = bond.amount - oldAmount
Reference: Initialized i guess?
HourlyBondSubscriptionLending.sol analyzed (2 contracts with 1 detectors), 2 result(s) found
```


### Explanation of Output

ABAuditor reports two accounting bug warnings for the benchmark project.
Namely, there are financial meaning violations in the operation `deltaAmount = bond.amount - oldAmount` and operation `(balance * accumulatorFP) / yieldQuotientFP` in function `applyInterest()`.

The both warnings correspond to the real-world report located in this link: https://github.com/code-423n4/2021-04-marginswap-findings/issues/64,

Essentially, in the first warning,  variable `bond.amount` is a raw balance that has had interest applied to it (hence an accrued balance). Intuitively, such an operation is similar to paying off a certain amount of debt using the raw balance from the user.
However, oldAmount is a raw balance, not an accrued one (i.e. it has not had interest applied to it).

Hence, there is an accounting bug in the subtraction due to the mismatch of financial meanings. Variable `oldAmount` should have had an interest applied to it before the subtraction. 

The second warning is reported for the same reason and is a direct consequence of the first. We omit the specific details as they are not essential.

### For more in-depth detail on the annotations and hallucination remedy, please refer to the file `comparison_of_annotations.md` in the directory `Benchmark/saved_results2`.

The file contains the initial annotations performed by the analysis, examples of reasoning traces generated for the analysis, and how the annotations compare to those performed by humans.

