#!/bin/bash


# Function to execute a numbered group of commands
execute_group() {
  group_number=$1
  shift
  echo "Executing Group $group_number"
  "$@"
  echo "Group $group_number complete"
}

# Group 1: MarginSwap
if [[ $# -eq 0 || $1 -eq 1 ]]; then
  solc-select use 0.8.3
  cd "Benchmark/MarginSwap/contracts"
  slither --detect tcheck HourlyBondSubscriptionLending.sol > output.txt
  cd "../../../"
  execute_group 1 echo "[*] Tested 1 warning for MarginSwap"
  sleep 3
fi

