function [amari_scores_cgf_total, ... 
          amari_scores_chf_total, ...
          amari_scores_kurtosis_total, ...
          amari_scores_kurtosis_prime_total, ...
          amari_scores_aiyou_total, ...
          amari_scores_jade_total, ...
          amari_scores_fastica_total, ...
          amari_scores_meta_total] = run_algorithms(dataset, ...
                                                    experiment_type, ...
                                                    noise_power, ...
                                                    s_size, ...
                                                    num_experiments, ...
                                                    p_val, ...
                                                    run)

    addpath(genpath('./FastICA_25/'));
    
    
    k                  = 9;
    maxruns            = 20;
    verbose_flag       = false;
    
    sample_sizes = [s_size];

    if(not(p_val == 0))
        p_vals = [1e-3, 5e-3, 1e-2, 5e-2, 1e-1, 0.15, 1/2 - sqrt(1/12)];
        p = p_vals(p_val);
        fprintf("Probability parameter = %.5f\n", p);
        k=5;
    else
        p = 0;
    end

    if(k == 9)
        B = [0.3175   -0.9259   -0.4594    0.7967   -0.3507    0.6462    0.3316   -0.2903  1.2321;
             0.4813    0.1237    0.5299    1.2479    0.5493   -0.5761   -0.0520    0.2569  -0.3199;
             -1.1326   -0.4329    0.6435    0.3616   -0.4940   -0.3085    0.3345   -0.0493  -0.2063;
             0.4087   -0.7299    0.8755   -0.6444    0.7951    0.4749    0.8641    0.0717  0.0270;
             0.1631    0.7741   -0.0572    0.1253   -1.1738    0.0493    0.0499    1.0300 0.8116;
             0.3521   -1.0594   -0.2978    0.0582   -0.5542    0.2866   -0.5187    0.5630 -0.3212;
             -0.3513    1.0874    0.5375   -0.0708   -0.4345    1.1174   -0.5680   -0.1517  -0.0000;
             -0.9420    0.0717   -0.5846    0.2159    0.7213    1.0357    0.5871    0.6148    -0.1014;
             -1.0494   -0.5347    0.2006    0.2077    0.5169   -0.3007   -1.1130    0.5811  0.4759;];
    
        B
    else
        B = [    1.2065    0.4904    0.0411    0.6185    1.3333
   -1.4615    1.5608    0.4255    0.0277    0.8313
    0.6444    0.3776   -0.0027    1.2494   -0.9154
   -0.7013   -0.7793    1.2695    1.0910   -0.5975
   -0.6701   -0.3464   -1.2811    1.3622    0.6718];
        
        B 
    end

    l = length(sample_sizes);
    
    amari_scores_cgf_total            = zeros(num_experiments,l);
    amari_scores_chf_total            = zeros(num_experiments,l);
    amari_scores_kurtosis_total       = zeros(num_experiments,l);
    amari_scores_kurtosis_prime_total = zeros(num_experiments,l);
    amari_scores_aiyou_total          = zeros(num_experiments,l);
    amari_scores_jade_total           = zeros(num_experiments,l);
    amari_scores_fastica_total        = zeros(num_experiments,l);
    amari_scores_meta_total           = zeros(num_experiments,l);
    
    for itr=1:length(sample_sizes) 
    
        corner_scores_cgf      = zeros(num_experiments,1);
        corner_scores_chf      = zeros(num_experiments,1);
        corner_scores_kurtosis = zeros(num_experiments,1);
        corner_scores_kurtosis_prime = zeros(num_experiments,1);
        corner_scores_aiyou    = zeros(num_experiments,1);
        corner_scores_jade     = zeros(num_experiments,1);
        corner_scores_fastica  = zeros(num_experiments,1);
        corner_scores_meta     = zeros(num_experiments,1);
        
        amari_scores_cgf       = zeros(num_experiments,1);
        amari_scores_chf       = zeros(num_experiments,1);
        amari_scores_kurtosis  = zeros(num_experiments,1);
        amari_scores_kurtosis_prime = zeros(num_experiments,1);
        amari_scores_aiyou     = zeros(num_experiments,1);
        amari_scores_jade      = zeros(num_experiments,1);
        amari_scores_fastica   = zeros(num_experiments,1);
        amari_scores_meta      = zeros(num_experiments,1);
        
        sinr_scores_cgf        = zeros(num_experiments,1);
        sinr_scores_chf        = zeros(num_experiments,1);
        sinr_scores_kurtosis   = zeros(num_experiments,1);
        sinr_scores_kurtosis_prime = zeros(num_experiments,1);
        sinr_scores_aiyou      = zeros(num_experiments,1);
        sinr_scores_jade       = zeros(num_experiments,1);
        sinr_scores_fastica    = zeros(num_experiments,1);
        sinr_scores_meta       = zeros(num_experiments,1);
    
    for exp=1:num_experiments
        fprintf("Experiment %d\n", exp);
        
        % noise_power   = 0.67;
        n             = sample_sizes(itr);
        num_trials    = 200;
       
        if(dataset == "ours")
            k = 11;
            [Sigma,B,X,z,e] = generate_data("all",n,k,noise_power);
        elseif(dataset == "belkin")
            k = 9;
            [Sigma,B,X,z,e] = generate_data_belkin(n,k,noise_power,B);
        else
            % p = 1/2 + sqrt(1/12);
            % p = 0.5;
            % p = 0.1;
            % p = p_vals(p_val);
            k = 5;
            
            z_bernoulli = binornd(1,p,n,k)-p;
            z_bernoulli = z_bernoulli/sqrt(p*(1-p));
            
            z_uniform = unifrnd(-sqrt(3),sqrt(3),n,k);
            
            z_exp     = exprnd(0.1,n,k);
            z_exp     = (z_exp-ones(n,1)*mean(z_exp))./std(z_exp);

            lambda                      = 1/2; 
            d                           = k;
            multiplier                  = binornd(1,1/2,n,d);
            z_zero_kurtosis_poisson     = multiplier.*(sqrt(poissrnd(lambda,n,d))) + ...
                                          (1-multiplier).*(-1*sqrt(poissrnd(lambda,n,d)));
            z_zero_kurtosis_poisson     = z_zero_kurtosis_poisson - ...
                                          ones(n,d)*mean(z_zero_kurtosis_poisson,"all");
            
            % z  = cat(2, z_exp, z_zero_kurtosis_bernoulli);
            z = z_bernoulli;
            % z = z_uniform;
            % z = z_zero_kurtosis_poisson;
              
            % U      = gallery('qmult',k);
            % Lambda = diag(rand(k,1)*2 + 1);
            % V      = gallery('qmult',k);
            % B      = U*Lambda*V'; % Mixing matrix
            % U = randn(k,k);
            % B = eye(k) + 0.5*(U*U');
            % B = eye(k);
            % B = randn(k,k);
                 
            rho   = noise_power;
            % V      = gallery('qmult',k);
            V = randn(k,k);
            Sigma = rho*(1/k)*(V*V');
            % Sigma = rho*eye(k);
            % Sigma = rho*(10*eye(k) - B*B');
            
            e  = mvnrnd(zeros(k,1), Sigma, n);
            X  = z*B' + e;
        end

        random_projections   = randn(2*num_trials,k);
    
        A_aiyou       = inv(PCF_ica(X'));
        fprintf("PFICA completed\n");
        A_jade        = jade(X');
        fprintf("JADE completed\n");
        [A_fastica,~] = fastica(X');
        fprintf("FASTICA completed\n");
       
        cgf_fn          = cgf(X);
        chf_fn          = symmetric_chf(X);
        kurtosis_fn     = kurtosis(X);
        C_cgf_og        = cgf_fn.estimate_C(20);
        fprintf("C matrix generation for CGF complete\n");
        C_chf_og        = chf_fn.estimate_C(20);
        fprintf("C matrix generation for CHF complete\n");
        C_kurtosis      = kurtosis_fn.estimate_C(20);
        fprintf("C matrix generation for Kurtosis complete\n");
        
        A = A_aiyou;
        C_cgf      = A*A';
        C_chf      = A*A';
        C_kurtosis_prime = A*A';
        pinv_C_cgf      = pinv(C_cgf);
        pinv_C_chf      = pinv(C_chf);
        pinv_C_kurtosis = pinv(C_kurtosis);
        pinv_C_kurtosis_prime = pinv(C_kurtosis_prime);
    
        A_cgf       = zeros(k,k);
        B1_cgf      = zeros(k,k);
        A_chf       = zeros(k,k);
        B1_chf      = zeros(k,k);
        A_kurtosis  = zeros(k,k);
        B1_kurtosis = zeros(k,k);
        A_kurtosis_prime  = zeros(k,k);
        B1_kurtosis_prime = zeros(k,k);
        A_meta      = zeros(k,k);
        B1_meta     = zeros(k,k);
     
        for i=1:k
            fprintf('Column %d\n',i);
            % u_init = randn(k,1);
            u_init = A_aiyou(:,i);
            u_init = u_init/norm(u_init);
            
            fprintf('CGF run\n');
            M_cgf = eye(k) - A_cgf*B1_cgf;
            [u_cgf,~,~,~] = ICA_power(X, ...
                                      maxruns, ...
                                      B, ...
                                      verbose_flag, ...
                                      cgf_fn, ...
                                      u_init, ...
                                      C_cgf, ...
                                      M_cgf);
    
            A_cgf(:,i)=u_cgf';
            u1=pinv_C_cgf*A_cgf(:,i);
            B1_cgf(i,:)=u1/(u1'*A_cgf(:,i));
    
            fprintf('CHF run\n');
            M_chf = eye(k) - A_chf*B1_chf;
            [u_chf,~,~,~] = ICA_power(X, ...
                                      maxruns, ...
                                      B, ...
                                      verbose_flag, ...
                                      chf_fn, ...
                                      u_init, ...
                                      C_chf, ...
                                      M_chf);
    
            A_chf(:,i)=u_chf';
            u1=pinv_C_chf*A_chf(:,i);
            B1_chf(i,:)=u1/(u1'*A_chf(:,i));
    
            fprintf('Kurtosis original run\n');
            M_kurtosis = eye(k) - A_kurtosis*B1_kurtosis;
            [u_kurtosis,~,~,~] = ICA_power(X, ...
                                           maxruns, ...
                                           B, ...
                                           verbose_flag, ...
                                           kurtosis_fn, ...
                                           u_init, ...
                                           C_kurtosis, ...
                                           M_kurtosis);
    
            A_kurtosis(:,i)=u_kurtosis';
            u1=pinv_C_kurtosis*A_kurtosis(:,i);
            B1_kurtosis(i,:)=u1/(u1'*A_kurtosis(:,i));
    
            fprintf('Kurtosis with PFICA C run\n');
            M_kurtosis_prime = eye(k) - A_kurtosis_prime*B1_kurtosis_prime;
            [u_kurtosis_prime,~,~,~] = ICA_power(X, ...
                                           maxruns, ...
                                           B, ...
                                           verbose_flag, ...
                                           kurtosis_fn, ...
                                           u_init, ...
                                           C_kurtosis_prime, ...
                                           M_kurtosis_prime);
    
            A_kurtosis_prime(:,i)=u_kurtosis_prime';
            u1=pinv_C_kurtosis_prime*A_kurtosis_prime(:,i);
            B1_kurtosis_prime(i,:)=u1/(u1'*A_kurtosis_prime(:,i));
    
            % fprintf('Meta run\n');
            % M_meta = eye(k) - A_meta*B1_meta;
            % [u_meta,C_meta] = ICA_power_meta(X, ...
            %                                  maxruns, ...
            %                                  B, ...
            %                                  verbose_flag, ...
            %                                  kurtosis_fn, ...
            %                                  chf_fn, ...
            %                                  cgf_fn, ...
            %                                  A_aiyou, ...
            %                                  A_jade, ...
            %                                  A_fastica, ...
            %                                  u_init, ...
            %                                  C_kurtosis, ...
            %                                  C_chf, ...
            %                                  C_cgf, ...
            %                                  num_trials, ...
            %                                  projections, ...
            %                                  M_meta);
    
            % A_meta(:,i)=u_meta';
            % pinv_C_meta=pinv(C_meta);
            % u1=pinv_C_meta*A_meta(:,i);
            % B1_meta(i,:)=u1/(u1'*A_meta(:,i));
    
            fprintf('=====================\n');
            fprintf('=====================\n');
        end

        fprintf('Meta run\n');

        ind_scores_chf = Delta_Score_Total(X,C_chf_og,A_chf,random_projections,num_trials);
        ind_scores_cgf = Delta_Score_Total(X,C_cgf_og,A_cgf,random_projections,num_trials);
        ind_scores_kurtosis = Delta_Score_Total(X,C_kurtosis,A_kurtosis,random_projections,num_trials);
        ind_scores_pfica = Delta_Score_Total(X,A_aiyou*A_aiyou',A_aiyou,random_projections,num_trials);
        ind_scores_jade = Delta_Score_Total(X,A_jade*A_jade',A_jade,random_projections,num_trials);
        ind_scores_fastica = Delta_Score_Total(X,A_fastica*A_fastica',A_fastica,random_projections,num_trials);
        
        fprintf("Independence Score CHF : %.5f\n", ind_scores_chf);
        fprintf("Independence Score CGF : %.5f\n", ind_scores_cgf);
        fprintf("Independence Score Kurtosis : %.5f\n", ind_scores_kurtosis);
        fprintf("Independence Score PFICA : %.5f\n", ind_scores_pfica);
        fprintf("Independence Score JADE : %.5f\n", ind_scores_jade);
        fprintf("Independence Score FASTICA : %.5f\n", ind_scores_fastica);

        A_matrices = {A_cgf, A_chf, A_kurtosis, A_aiyou, A_jade, A_fastica};
        scores     = [ind_scores_cgf, ind_scores_chf, ind_scores_kurtosis, ...
                      ind_scores_pfica, ind_scores_jade, ind_scores_fastica];
        [~,min_index] = min(scores);
        A_meta = A_matrices{min_index};

        fprintf('Metric Computation\n');
        
        avg_thresh = 0;
        num_repetitions = 5;
        for t=1:num_repetitions
            [~,match_matrix] = compute_corner_score(randn(k,k),B,-1);
            avg_thresh = avg_thresh + mean(max(match_matrix,[],1));
        end
        thresh_random = avg_thresh/num_repetitions;
        fprintf("Random threshold for corner score = %.5f\n", thresh_random);
    
        [corner_scores_cgf(exp), match_matrix_cgf] = ...
                              compute_corner_score(A_cgf,B,thresh_random);
        [corner_scores_chf(exp), match_matrix_chf] = ...
                              compute_corner_score(A_chf,B,thresh_random);
        [corner_scores_kurtosis(exp), match_matrix_kurtosis] = ...
                              compute_corner_score(A_kurtosis,B,thresh_random);
        [corner_scores_kurtosis_prime(exp), match_matrix_kurtosis_prime] = ...
                      compute_corner_score(A_kurtosis_prime,B,thresh_random);
        [corner_scores_aiyou(exp), match_matrix_aiyou] = ...
                              compute_corner_score(A_aiyou,B,thresh_random);
        [corner_scores_jade(exp), match_matrix_jade] = ...
                              compute_corner_score(A_jade,B,thresh_random);
        [corner_scores_meta(exp), match_matrix_meta] = ...
                              compute_corner_score(A_meta,B,thresh_random);
        if(size(A_fastica,1) == k && size(A_fastica,2) == k)
            [corner_scores_fastica(exp), match_matrix_fastica] = ...
                              compute_corner_score(A_fastica,B,thresh_random);
        end
    
        amari_scores_cgf(exp)      = compute_amari_score(A_cgf,B);
        amari_scores_chf(exp)      = compute_amari_score(A_chf,B);
        amari_scores_kurtosis(exp) = compute_amari_score(A_kurtosis,B);
        amari_scores_kurtosis_prime(exp) = compute_amari_score(A_kurtosis_prime,B);
        amari_scores_aiyou(exp)    = compute_amari_score(A_aiyou,B);
        amari_scores_jade(exp)     = compute_amari_score(A_jade,B);
        amari_scores_meta(exp)     = compute_amari_score(A_meta,B);
        if(size(A_fastica,1) == k && size(A_fastica,2) == k)
            amari_scores_fastica(exp)  = compute_amari_score(A_fastica,B);
        else
            amari_scores_fastica(exp)  = 5;
        end
    
        sinr_scores_cgf(exp)      = compute_sinr(A_cgf,X,B,z,e,Sigma);
        sinr_scores_chf(exp)      = compute_sinr(A_chf,X,B,z,e,Sigma);
        sinr_scores_kurtosis(exp) = compute_sinr(A_kurtosis,X,B,z,e,Sigma);
        sinr_scores_kurtosis_prime(exp) = compute_sinr(A_kurtosis_prime,X,B,z,e,Sigma);
        sinr_scores_aiyou(exp)    = compute_sinr(A_aiyou,X,B,z,e,Sigma);
        sinr_scores_jade(exp)     = compute_sinr(A_jade,X,B,z,e,Sigma);
        sinr_scores_meta(exp)     = compute_sinr(A_meta,X,B,z,e,Sigma);
        if(size(A_fastica,1) == k && size(A_fastica,2) == k)
            sinr_scores_fastica(exp)  = compute_sinr(A_fastica,X,B,z,e,Sigma);
        end
    
        fprintf("Corner Score for CGF = %.5f\n", ...
                 corner_scores_cgf(exp));
        fprintf("Corner Score for CHF = %.5f\n", ...
                 corner_scores_chf(exp));
        fprintf("Corner Score for Kurtosis = %.5f\n", ...
                 corner_scores_kurtosis(exp));
        fprintf("Corner Score for Kurtosis with PFICA C = %.5f\n", ...
                 corner_scores_kurtosis_prime(exp));
        fprintf("Corner Score for Meta = %.5f\n", ...
                 corner_scores_meta(exp));
        fprintf("Corner Score for PFICA = %.5f\n", ...
                 corner_scores_aiyou(exp));
        fprintf("Corner Score for JADE = %.5f\n", ...
                 corner_scores_jade(exp));
        fprintf("Corner Score for FASTICA = %.5f\n", ...
                 corner_scores_fastica(exp));
    
        fprintf("Amari Score for CGF = %.5f\n", ...
                 amari_scores_cgf(exp));
        fprintf("Amari Score for CHF = %.5f\n", ...
                 amari_scores_chf(exp));
        fprintf("Amari Score for Kurtosis = %.5f\n", ...
                 amari_scores_kurtosis(exp));
        fprintf("Amari Score for Kurtosis prime = %.5f\n", ...
                 amari_scores_kurtosis_prime(exp));
        fprintf("Amari Score for Meta = %.5f\n", ...
                 amari_scores_meta(exp));
        fprintf("Amari Score for PFICA %.5f\n", ...
                 amari_scores_aiyou(exp));
        fprintf("Amari Score for JADE %.5f\n", ...
                 amari_scores_jade(exp));
        fprintf("Amari Score for FASTICA = %.5f\n", ...
                 amari_scores_fastica(exp));
    
        fprintf("SINR Score for CGF = %.5f\n", ...
                 sinr_scores_cgf(exp));
        fprintf("SINR Score for CHF = %.5f\n", ...
                 sinr_scores_chf(exp));
        fprintf("SINR Score for Kurtosis = %.5f\n", ...
                 sinr_scores_kurtosis(exp));
        fprintf("SINR Score for Kurtosis prime = %.5f\n", ...
                 sinr_scores_kurtosis_prime(exp));
        fprintf("SINR Score for Meta = %.5f\n", ...
                 sinr_scores_meta(exp));
        fprintf("SINR Score for PFICA = %.5f\n", ...
                 sinr_scores_aiyou(exp));
        fprintf("SINR Score for JADE = %.5f\n", ...
                 sinr_scores_jade(exp));
        fprintf("SINR Score for FASTICA = %.5f\n", ...
                 sinr_scores_fastica(exp));
    
        fprintf('=====================\n');
        fprintf('=====================\n');
        fprintf('=====================\n');
    end
        fprintf("Average Corner Score for CGF = %.5f +- %.5f\n", ...
            mean(corner_scores_cgf), std(corner_scores_cgf));
        fprintf("Average Corner Score for CHF = %.5f +- %.5f\n", ...
            mean(corner_scores_chf), std(corner_scores_chf));
        fprintf("Average Corner Score for Kurtosis = %.5f +- %.5f\n", ...
            mean(corner_scores_kurtosis), std(corner_scores_kurtosis));
        fprintf("Average Corner Score for Kurtosis prime = %.5f +- %.5f\n", ...
            mean(corner_scores_kurtosis_prime), std(corner_scores_kurtosis_prime));
        fprintf("Average Corner Score for Meta = %.5f +- %.5f\n", ...
            mean(corner_scores_meta), std(corner_scores_meta));
        fprintf("Average Corner Score for PFICA = %.5f +- %.5f\n", ...
            mean(corner_scores_aiyou), std(corner_scores_aiyou));
        fprintf("Average Corner Score for JADE = %.5f +- %.5f\n", ...
            mean(corner_scores_jade), std(corner_scores_jade));
        fprintf("Average Corner Score for FASTICA = %.5f +- %.5f\n", ...
            mean(corner_scores_fastica), std(corner_scores_fastica));
        fprintf('=====================\n');
        
        fprintf("Average Amari Score for CGF = %.5f +- %.5f\n", ...
            mean(amari_scores_cgf), std(amari_scores_cgf));
        fprintf("Average Amari Score for CHF = %.5f +- %.5f\n", ...
            mean(amari_scores_chf), std(amari_scores_chf));
        fprintf("Average Amari Score for Kurtosis = %.5f +- %.5f\n", ...
            mean(amari_scores_kurtosis), std(amari_scores_kurtosis));
        fprintf("Average Amari Score for Kurtosis prime = %.5f +- %.5f\n", ...
            mean(amari_scores_kurtosis_prime), std(amari_scores_kurtosis_prime));
        fprintf("Average Amari Score for Meta = %.5f +- %.5f\n", ...
            mean(amari_scores_meta), std(amari_scores_meta));
        fprintf("Average Amari Score for PFICA = %.5f +- %.5f\n", ...
            mean(amari_scores_aiyou), std(amari_scores_aiyou));
        fprintf("Average Amari Score for JADE = %.5f +- %.5f\n", ...
            mean(amari_scores_jade), std(amari_scores_jade));
        fprintf("Average Amari Score for FASTICA = %.5f +- %.5f\n", ...
            mean(amari_scores_fastica), std(amari_scores_fastica));
        fprintf('=====================\n');
        
        fprintf("Average SINR Score for CGF = %.5f +- %.5f\n", ...
            mean(sinr_scores_cgf), std(sinr_scores_cgf));
        fprintf("Average SINR Score for CHF = %.5f +- %.5f\n", ...
            mean(sinr_scores_chf), std(sinr_scores_chf));
        fprintf("Average SINR Score for Kurtosis = %.5f +- %.5f\n", ...
            mean(sinr_scores_kurtosis), std(sinr_scores_kurtosis));
        fprintf("Average SINR Score for Kurtosis prime = %.5f +- %.5f\n", ...
            mean(sinr_scores_kurtosis_prime), std(sinr_scores_kurtosis_prime));
        fprintf("Average SINR Score for Meta = %.5f +- %.5f\n", ...
            mean(sinr_scores_meta), std(sinr_scores_meta));
        fprintf("Average SINR Score for PFICA = %.5f +- %.5f\n", ...
            mean(sinr_scores_aiyou), std(sinr_scores_aiyou));
        fprintf("Average SINR Score for JADE = %.5f +- %.5f\n", ...
            mean(sinr_scores_jade), std(sinr_scores_jade));
        fprintf("Average SINR Score for FASTICA = %.5f +- %.5f\n", ...
            mean(sinr_scores_fastica), std(sinr_scores_fastica));
    
        amari_scores_cgf_total(:,itr)            = amari_scores_cgf;
        amari_scores_chf_total(:,itr)            = amari_scores_chf;
        amari_scores_kurtosis_total(:,itr)       = amari_scores_kurtosis;
        amari_scores_kurtosis_prime_total(:,itr) = amari_scores_kurtosis_prime;
        amari_scores_meta_total(:,itr)           = amari_scores_meta;
        amari_scores_aiyou_total(:,itr)          = amari_scores_aiyou;
        amari_scores_jade_total(:,itr)           = amari_scores_jade;
        amari_scores_fastica_total(:,itr)        = amari_scores_fastica;
    end

    filename = sprintf("%s_noise_power_%.3f_sample_size_%d_k_%d_dataset_%s_num_experiments_%d_p_%.5f_run_%d.mat", ...
                      experiment_type, ...
                      noise_power, ...
                      s_size, ...
                      k, ...
                      dataset, ...
                      num_experiments, ...
                      p, ...
                      run);
    filename
    save(filename,"amari_scores_cgf_total", ...
                  "amari_scores_chf_total", ...
                  "amari_scores_kurtosis_total", ...
                  "amari_scores_kurtosis_prime_total", ...
                  "amari_scores_meta_total", ...
                  "amari_scores_aiyou_total", ...
                  "amari_scores_jade_total", ...
                  "amari_scores_fastica_total");
end