function [pics, file_names, npics, inverted, pic_size] = read_sources(file_names)
    disp('Reading images');
    [pics, valid_file_names] = read_imgs(file_names);
    npics = length(pics);
    if npics < 2
        error('Less than 2 pictures...');
    end
    inverted = false(1, npics);
    disp('Cropping images');
    [pics, common_h, common_w] = crop_arrays(pics);
    pic_size = [common_h, common_w];
    file_names = valid_file_names;
end