# -*- coding: utf-8 -*-
"""
Created on Thu Apr 11 18:59:31 2024

@author: ZJ
"""

import matplotlib.pyplot as plt
import pandas as pd

plt.rcParams.update({"font.size": 16})
distribution = 7
epsilon = 1
f_new = "result_{}_{}_new.csv".format(distribution, epsilon)
f_base = "result_{}_{}_baseline.csv".format(distribution, epsilon)
dnew = pd.read_csv(f_new)
dbase = pd.read_csv(f_base)
marray = dnew["m"]
nlist = ["1000", "10000"]
plt.figure(figsize=(6,5))
plt.xscale('log')
plt.yscale('log')
for n in nlist:
    col_err = "std_" + n
    plt.errorbar(marray, dnew[n], elinewidth = 3, yerr = dnew[col_err] / 2, \
                 marker = 'o', markersize = 6, linewidth = 2)
    plt.errorbar(marray, dbase[n], elinewidth = 3, yerr = dbase[col_err] / 2, \
             marker = 'o', markersize = 6, linewidth = 2, linestyle = '--')
plt.legend(['HLM, n=1000', 'WME, n=1000',\
            'HLM, n=10000', 'WME, n=10000'], loc = 'upper right', frameon = False, fontsize = 14)
plt.xlabel('m')
plt.ylabel('mean squared error')
#plt.ylim(1e2,1e9)
figname = "{}_{}.pdf".format(distribution, epsilon)
plt.tight_layout()
plt.savefig(figname, format = 'pdf')

