import cv2
import os

def process_image(image):

    black_pixels_mask = (image[:, :, 0] == 0) & (image[:, :, 1] == 0) & (image[:, :, 2] == 0)
    # black_pixels_mask = (image[:, :, 0] == 166) & (image[:, :, 1] == 166) & (image[:, :, 2] == 166)

    image[black_pixels_mask] = [186, 186, 186]  
    return image

def process_images_in_folder(input_folder, output_folder):

    if not os.path.exists(output_folder):
        os.makedirs(output_folder)


    for filename in os.listdir(input_folder):
        if filename.endswith(".jpg") or filename.endswith(".png"):

            image_path = os.path.join(input_folder, filename)
            image = cv2.imread(image_path)


            processed_image = process_image(image)


            output_path = os.path.join(output_folder, filename)
            cv2.imwrite(output_path, processed_image)

            print(f"Processed image: {filename}")


input_folder = "D:/2024/3DGS/dataset/nerf_synthetic/ship_colmap_easy/renders_old"
output_folder = "D:/2024/3DGS/dataset/nerf_synthetic/ship_colmap_easy/renders"
process_images_in_folder(input_folder, output_folder)