import os
import cv2

def generate_video_from_images(folder_path, output_video_path, fps=25):

    image_files = [f for f in os.listdir(folder_path) if f.endswith(('.png', '.jpg', '.jpeg'))]
    if not image_files:
        print("No image files found in the specified folder.")
        return
    

    first_image_path = os.path.join(folder_path, image_files[0])
    first_image = cv2.imread(first_image_path)
    height, width, _ = first_image.shape


    fourcc = cv2.VideoWriter_fourcc(*'mp4v')
    video_writer = cv2.VideoWriter(output_video_path, fourcc, fps, (width, height))


    for image_file in image_files:
        image_path = os.path.join(folder_path, image_file)
        image = cv2.imread(image_path)
        video_writer.write(image)


    video_writer.release()
    cv2.destroyAllWindows()

generate_video_from_images("D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/renders_R", "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/train_R.mp4", fps=25)
generate_video_from_images("D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/renders_G", "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/train_G.mp4", fps=25)
generate_video_from_images("D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/renders_B", "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/train_B.mp4", fps=25)