import os
import cv2

def split_channels(source_folder, red_folder, green_folder, blue_folder):

    if not os.path.exists(red_folder):
        os.makedirs(red_folder)
    if not os.path.exists(green_folder):
        os.makedirs(green_folder)
    if not os.path.exists(blue_folder):
        os.makedirs(blue_folder)
    

    image_files = [file for file in os.listdir(source_folder) if file.endswith(('.png', '.jpg', '.jpeg', '.bmp', '.tiff'))]
    
    for file in image_files:

        img_path = os.path.join(source_folder, file)
        img = cv2.imread(img_path)
        

        blue_channel, green_channel, red_channel = cv2.split(img)
        

        cv2.imwrite(os.path.join(red_folder, file), red_channel)
        cv2.imwrite(os.path.join(green_folder, file), green_channel)
        cv2.imwrite(os.path.join(blue_folder, file), blue_channel)

source_folder = 'D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/images_true'
red_folder = 'D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/renders_R'
green_folder = 'D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/renders_G'
blue_folder = 'D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/renders_B'

split_channels(source_folder, red_folder, green_folder, blue_folder)