import cv2
import os
import sys
import numpy as np


sys.path.append("../../src")

from event_buffer import EventBuffer
from dvs_sensor import init_bgn_hist_cpp, DvsSensor
from event_display import EventDisplay
import dsi


input_folder = "D:/2024/3DGS/dataset/nerf_synthetic/lego/True/train/ours_7999/renders"


lat = 100
jit = 10
ref = 100
tau = 300
th = 0.3
th_noise = 0.01

dt = 200



ev_full = EventBuffer(1)
# ed = EventDisplay("Events", 1920, 1080, dt*2)


image_files = sorted(os.listdir(input_folder))
image_files = [file for file in image_files if len(file) <= 10]

time = 0
isInit = False

i = 0
for image_file in image_files:

    # if i>67:
    #     break
    i=i+1
    image_path = os.path.join(input_folder, image_file)
    

    im = cv2.imread(image_path)
    
    

    im = cv2.cvtColor(im, cv2.COLOR_RGB2LUV)[:, :, 0]
    cv2.imshow("im",im)
    cv2.waitKey()

    if not isInit:
        dsi.initSimu(int(im.shape[0]), int(im.shape[1]))  
        dsi.initLatency(lat, jit, ref, tau)
        dsi.initContrast(th, th, th_noise)
        init_bgn_hist_cpp("D:/2023/computional imaging/my_pbrt/IEBCS-main/data/noise_neg_161lux.npy", "D:/2023/computional imaging/my_pbrt/IEBCS-main/data/noise_neg_161lux.npy")
        dsi.initImg(im)
        ed = EventDisplay("Events", int(im.shape[1]), int(im.shape[0]), dt*2)

        isInit = True
    else:
        buf = dsi.updateImg(im, dt)
        ev = EventBuffer(1)
        ev.add_array(np.array(buf["ts"], dtype=np.uint64),
                     np.array(buf["x"], dtype=np.uint16),
                     np.array(buf["y"], dtype=np.uint16),
                     np.array(buf["p"], dtype=np.uint64),
                     10000000)
        ed.update(ev, dt)
        ev_full.increase_ev(ev)
        time += dt
        if time > 0.1e19:
            break
ev_full.write("D:/2024/3DGS/dataset/nerf_synthetic/lego/raw2.dat")