from data_simulator import gtest
import numpy as np
'''
input: data
output: 'xtoy', 'ytox', or 'xindy'. If undecided, output one of them with 1/3 chance each
'''
def causal_de_finetti(data):
    x1 = data['x1']
    x2 = data['x2']
    y1 = data['y1']
    y2 = data['y2']
    _, sigx = gtest(x1, y2, x2.reshape(-1, 1))
    _, sigy = gtest(y1, x2, y2.reshape(-1, 1))
    _, sig = gtest(x1, y1, np.matrix([]))
    voteXtoY = sigx
    voteYtoX = sigy
    voteind = sig
    if (voteXtoY >= 0.05) and (voteYtoX <= 0.05) and (voteind <= 0.05):
        return 'xtoy'
    elif (voteYtoX >= 0.05) and (voteXtoY <= 0.05) and (voteind <= 0.05):
        return 'ytox'
    elif voteind >=0.05:
        return 'xindy'
    else:
        return np.random.choice(['xtoy', 'ytox', 'xindy'])


def iid_cd(data):
    x = np.concatenate((data['x1'], data['x2']))
    y = np.concatenate((data['y1'], data['y2']))
    _, sig = gtest(x, y, np.matrix([]))

    voteind = sig
    if voteind >= 0.05:
        return 'xindy'
    else:
        return np.random.choice(['xtoy', 'ytox'])