

### Installation
```
conda create -n GraphSSM python=3.9
conda activate GraphSSM

pip install torch==1.13.1+cu117 -f https://download.pytorch.org/whl/torch/
pip install torch-sparse==0.6.17 -f https://data.pyg.org/whl/torch-1.13.1+cu117.html
pip install torch-scatter==2.1.1 -f https://data.pyg.org/whl/torch-1.13.1+cu117.html
pip install pyg-lib -f https://data.pyg.org/whl/torch-1.13.1+cu117.html
pip install torch-geometric
pip install -r requirements.txt
```


### Run

```
export PYTHONPATH="$pwd:$PYTHONPATH"
unzip data.zip
bash scripts/s4_dblp.sh
```
You can change `s4_dblp.sh` to other model and dataset under `scripts/`.


### File structure
```
.
├── data.zip
├── README.md
├── requirements.txt
├── scripts
├── SSM
│   ├── layers
│   │   └── ssm.py
│   ├── logger.py
│   ├── models
│   │   ├── mamba.py
│   │   ├── mamba_v2.py
│   │   └── ssm.py
│   ├── ssm_batch.py
│   ├── ssm_main.py
│   └── star.py
└── temporal_graph
    ├── data
    │   ├── __init__.py
    │   └── temporal.py
    ├── datasets
    │   ├── __init__.py
    │   ├── dblp.py
    │   ├── star_dataset.py
    │   └── tmall.py
    ├── models
    │   ├── __init__.py
    │   └── star.py
    └── transforms
        ├── __init__.py
        ├── prefit.py
        ├── random_node_split.py
        ├── temporal_split.py
        └── to_temporal_undirected.py
```