# Skinned Motion Retargeting with Dense Geometric Interaction Perception

This repository is the official implementation of *Skinned Motion Retargeting with Dense Geometric Interaction Perception*.


## Demo Video

For the demo video, please refer to the `MeshRetDemo.mp4` file.


## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```
## Dataset

Due to the limitations of current network storage tools that support anonymous link sharing, we are unable to host all our data files for sharing during the anonymous peer review phase. However, we have placed a single data example in the 'artifact/scanret' folder of our code, which can be loaded and accessed using Python's `pickle` library.

## Training

To train the model(s) in the paper, run this command:

```train
python -m run.train_retnet fit --config artifact/mixamo_all_ret/config.yaml
```

## Evaluation

To evaluate my model on Mixamo+ScanRet, run:

```eval
python -m run.train_retnet test --config artifact/mixamo_all_ret/config.yaml --ckpt_path artifact/mixamo_all_ret/pretrained.ckpt --data.split uc+um --data.sample_stride 30
```

You can specify different data splits through `data.split` parameter.
