import numpy as np
from numba import njit


@njit
def average_last_percent(x, perc=0.2):
    result = np.zeros_like(x)
    upper = np.arange(len(x))
    lower = ((1 - perc) * upper).astype(np.int32)
    val = 0
    last_l = 0
    for i, (l, u) in enumerate(zip(lower, upper)):
        if l != last_l:
            val -= x[last_l]
        val += x[u]
        result[i] = val / (u - l + 1)
        last_l = l
    return result
