from unittest import TestCase
import raven.src.config as config
import src.adaptiveRaven as ver
from src.common import Dataset, RavenMode
import os
import dill

class TestRaven(TestCase):
    def test_mnist_uap_scheduling_conv_small(self):
        net_names = [config.MNIST_CONV_SMALL_SABR_1]
        
        for eps in [0.14]:
            for count_per_prop in [50]:
                args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                    count_per_prop= count_per_prop, prop_count=10, eps=eps,
                    threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                    baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                    refine_intermediate_bounds =True, optimize_layers_count=2, 
                    bounds_for_individual_refinement=True, dataloading_seed = 0,
                    parallelize_executions=False,
                    lp_threshold=-0.5,
                    max_linear_apprx=6,
                    device='cuda:0', 
                    always_correct_cross_execution = False,
                    result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                    execution_count_dct = {2: 20 ,3: 20, 4: 16}, bias = 0.1, use_ib_refinement = False,  refinement_batch_size = 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
                
                ver.adptiveRaven(raven_args=args) 
    
    def test_mnist_uap_scheduling_conv_small76(self):
        net_names = [config.MNIST_CONV_SMALL_CITRUS_1]
        
        for eps in [0.15]:
            for count_per_prop in [50]:
                args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                    count_per_prop= count_per_prop, prop_count=10, eps=eps,
                    threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                    baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                    refine_intermediate_bounds =True, optimize_layers_count=2, 
                    bounds_for_individual_refinement=True, dataloading_seed = 0,
                    parallelize_executions=False,
                    lp_threshold=-0.5,
                    max_linear_apprx=6,
                    device='cuda:3', 
                    always_correct_cross_execution = False,
                    result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= False, run_abc= True,
                    execution_count_dct = {2: 20 ,3: 20, 4: 16}, bias = 0.1, use_ib_refinement = False,  refinement_batch_size = 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
                
                ver.adptiveRaven(raven_args=args) 
        
        net_names = [config.MNIST_CONV_SMALL_DIFFAI]
        for eps in [0.13]:
            for count_per_prop in [50]:
                args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                    count_per_prop= count_per_prop, prop_count=10, eps=eps,
                    threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                    baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                    refine_intermediate_bounds =True, optimize_layers_count=2, 
                    bounds_for_individual_refinement=True, dataloading_seed = 0,
                    parallelize_executions=False,
                    lp_threshold=-0.5,
                    max_linear_apprx=6,
                    device='cuda:3', 
                    always_correct_cross_execution = False,
                    result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= False, run_abc= True,
                    execution_count_dct = {2: 20 ,3: 20, 4: 16}, bias = 0.1, use_ib_refinement = False,  refinement_batch_size = 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
                
                ver.adptiveRaven(raven_args=args) 
    
    def test_mnist_uap_scheduling_conv_small92(self):
        net_names = [config.MNIST_CONV_SMALL_CITRUS_1]
        
        for eps in [0.14, 0.145, 0.155, 0.16]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                count_per_prop=50, prop_count=2, eps=eps,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:1', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 20 ,3: 18, 4: 8}, bias = 0.1, use_ib_refinement = False,  refinement_batch_size = 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args) 
    
    def test_mnist_uap_scheduling_conv_small2h(self):
        net_names = [config.MNIST_CONV_SMALL]
        
        for eps in [0.1]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:1', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 20 ,3: 20, 4: 8}, bias = 0.1, use_ib_refinement = False,  refinement_batch_size = 100, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args) 

    
    def test_mnist_uap_scheduling_conv_smallh2(self):
        net_names = [config.MNIST_CONV_SMALL]
        
        for eps in [0.15]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP_BINARY, dataset=Dataset.MNIST, net_names=net_names,
                count_per_prop=50, prop_count=1, eps=eps,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:1', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 20 ,3: 18}, bias = 0.1, use_ib_refinement = False,  refinement_batch_size = 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args) 

    
    def test_cifar_uap_scheduling_conv_test(self):
        net_names =  [config.CIFAR_CONV_BIG]
        for eps in [2.0]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:2', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= False, run_abc= True,
                execution_count_dct = {2: 10 ,3: 8, 4:8}, bias = 0.1, use_ib_refinement = False, overall_batch_size= 16, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)
    
    def test_cifar_uap_scheduling_conv_test5(self):
        net_names =  [config.CIFAR_RESNET2B]
        for eps in [1.0]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:3', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 10 ,3: 10, 4:8}, bias = 0.1, use_ib_refinement = False, overall_batch_size= 16, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)
    
    
    def test_cifar_uap_scheduling_conv_test904(self):
        net_names =  [config.CIFAR_CONV_DIFFAI]
        for eps in [5.0]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:3', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, run_topk= True, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 10 ,3: 10, 4:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)
    
    
    def test_cifar_uap_scheduling_conv_test914(self):
        net_names =  [config.CIFAR_RESNET2B]
        for eps in [1.0]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:3', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, run_topk= True, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 10 ,3: 10, 4:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)
    
    def test_cifar_uap_scheduling_conv_test91(self):
        net_names =  [config.MNIST_CONV_BIG]
        for eps in [0.12]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:3', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, run_topk= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 20 ,3: 20, 4:10}, bias = 0.1, use_ib_refinement = False, refinement_batch_size= 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)
    
    def test_mnist_uap_scheduling_conv_test92(self):
        net_names =  [config.MNIST_CONV_SMALL_SABR_1]
        for eps in [0.15]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:1', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, run_topk= True, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 20 ,3: 20, 4:10}, bias = 0.1, use_ib_refinement = False, refinement_batch_size= 150, bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)
    
    def test_cifar_uap_scheduling_conv_test93(self):
        net_names =  [config.CIFAR_CONV_DIFFAI]
        for eps in [5.0]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=1, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:3', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, run_topk= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 10 ,3: 10, 4:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace= False)
            
            ver.adptiveRaven(raven_args=args)


    def test_cifar_uap_scheduling_conv_test10(self):
        net_names =  [config.CIFAR_CONV_SMALL_CITRUS_2]
        for eps in [1.0, 1.5, 2.5, 3]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=2, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:2', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 10 ,3: 8, 4:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace= False, num_targetted= 0)
            
            ver.adptiveRaven(raven_args=args)
        
        
    def test_cifar_uap_scheduling_conv_test121(self):
        net_names =  [config.CIFAR_CONV_SMALL_CITRUS_2]
        for eps in [1.0, 1.5, 2.5, 3]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=2, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:2', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= False, run_abc= True,
                execution_count_dct = {2: 10 ,3: 8, 4:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace= False, num_targetted= 0)
            
            ver.adptiveRaven(raven_args=args)
    
    
    # def test_cifar_uap_scheduling_conv_test9(self):
    #     net_names =  [config.CIFAR_CONV_DIFFAI]
    #     for eps in [5.0]:
    #         for ex in [6, 8]:
    #             args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
    #                 count_per_prop=50, prop_count=5, eps=eps/255,
    #                 threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
    #                 baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
    #                 refine_intermediate_bounds =True, optimize_layers_count=2, 
    #                 bounds_for_individual_refinement=True, dataloading_seed = 0,
    #                 parallelize_executions=False,
    #                 lp_threshold=-0.5,
    #                 max_linear_apprx=6,
    #                 device='cuda:1', 
    #                 always_correct_cross_execution = False,
    #                 result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
    #                 execution_count_dct = {2: 10 ,3: 10, 4:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace= False)
                
    #             ver.adptiveRaven(raven_args=args)



    def test_cifar_uap_scheduling_conv_test223(self):
        net_names =  [config.CIFAR_CONV_SMALL_CITRUS_2]
        for eps in [2.0]:
            for count_per_prop in [30]:
                args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                    count_per_prop= count_per_prop, prop_count=10, eps=eps/255,
                    threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                    baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                    refine_intermediate_bounds =True, optimize_layers_count=2, 
                    bounds_for_individual_refinement=True, dataloading_seed = 0,
                    parallelize_executions=False,
                    lp_threshold=-0.5,
                    max_linear_apprx=6,
                    device='cuda:1', 
                    always_correct_cross_execution = False,
                    result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                    execution_count_dct = {2: 10 ,3: 8, 4:8, 5:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4)
                
                ver.adptiveRaven(raven_args=args)
    
    
    def test_cifar_uap_scheduling_conv_test332(self):
        net_names =  [config.CIFAR_CONV_SMALL_CITRUS_2]
        for eps in [2.0]:
            for count_per_prop in [40]:
                args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                    count_per_prop= count_per_prop, prop_count=10, eps=eps/255,
                    threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                    baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                    refine_intermediate_bounds =True, optimize_layers_count=2, 
                    bounds_for_individual_refinement=True, dataloading_seed = 0,
                    parallelize_executions=False,
                    lp_threshold=-0.5,
                    max_linear_apprx=6,
                    device='cuda:1', 
                    always_correct_cross_execution = False,
                    result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                    execution_count_dct = {2: 10 ,3: 8, 4:8, 5:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4)
                
                ver.adptiveRaven(raven_args=args)
                
    
    def test_cifar_uap_scheduling_conv_test3(self):
        net_names =  [config.CIFAR_RESNET2B]
        for eps in [1.0]:
            for count_per_prop in [50]:
                args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                    count_per_prop= count_per_prop, prop_count=11, eps=eps/255,
                    threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                    baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                    refine_intermediate_bounds =True, optimize_layers_count=2, 
                    bounds_for_individual_refinement=True, dataloading_seed = 0,
                    parallelize_executions=False,
                    lp_threshold=-0.5,
                    max_linear_apprx=6,
                    device='cuda:0', 
                    always_correct_cross_execution = False,
                    result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                    execution_count_dct = {2: 10 ,3: 8, 4:8, 5:8}, bias = 0.1, use_ib_refinement = False,  bab_timeout = 60, max_targetted= 4, store_time_trace = False)
                
                ver.adptiveRaven(raven_args=args)


    def test_cifar_uap_scheduling_conv_test4(self):
        net_names =  [config.CIFAR_CONV_SMALL_CITRUS_2]
        for eps in [2.0]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.CIFAR10, net_names=net_names,
                count_per_prop=50, prop_count=2, eps=eps/255,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:2', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 10, 3:8, 4:8, 5:8 }, branching_execution_counts = {3, 4, 5}, bias = 0.1, use_ib_refinement = False, refinement_batch_size= 150,  bab_timeout = 60, max_targetted= 4, store_time_trace = False)
            
            ver.adptiveRaven(raven_args=args)
        

    
    def test_mnist_uap_scheduling_conv_test3(self):
        net_names =  [config.MNIST_CONV_BIG]
        for eps in [0.2]:
            args = ver.RavenArgs(raven_mode=RavenMode.UAP, dataset=Dataset.MNIST, net_names=net_names,
                count_per_prop=50, prop_count=10, eps=eps,
                threshold_execution=4, cross_executional_threshold=5, maximum_cross_execution_count=4, 
                baseline_iteration=20, refinement_iterations=20, unroll_layers = False, unroll_layer_count=3, 
                refine_intermediate_bounds =True, optimize_layers_count=2, 
                bounds_for_individual_refinement=True, dataloading_seed = 0,
                parallelize_executions=False,
                lp_threshold=-0.5,
                max_linear_apprx=6,
                device='cuda:3', 
                always_correct_cross_execution = False,
                result_dir='icml_results_new', write_file=True, complete_verification= True, use_lp_bab= False, meta_scheduling= True, run_abc= False,
                execution_count_dct = {2: 16,3: 16, 4:8, 5: 8}, bias = 0.1, use_ib_refinement = False, overall_batch_size= 32, refinement_batch_size= 150,  bab_timeout = 60, max_targetted= 4, store_time_trace= False, num_targetted=20)
            
            ver.adptiveRaven(raven_args=args)
        
        