import gensim

"""
This script converts a binary word2vec model to a text file.
This is needed to integrate the word2vec model with the SentenceTransformer library.
You need to run only once.
"""
W2V_BIN_PATH = "data/GoogleNews-vectors-negative300.bin"
W2V_TXT_PATH = "data/GoogleNews-vectors-negative300.txt"
W2V_VOCAB_PATH = "data/GoogleNews-vectors-negative300.vocab"

if __name__ == "__main__":
    print("Loading word2vec Model...")
    model = gensim.models.KeyedVectors.load_word2vec_format(W2V_BIN_PATH, binary=True)
    print("Saving word2vec Model...")
    model.save_word2vec_format(W2V_TXT_PATH, fvocab=W2V_VOCAB_PATH, binary=False)
    print("Done.")
