/* crypto/bio/bio_err.c */
/* ====================================================================
 * Copyright (c) 1999-2011 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */
/* NOTE: this file was auto generated by the mkerr.pl script: any changes
 * made to it will be overwritten when the script next updates this file,
 * only reason strings will be preserved.
 */
#include <stdio.h>
#include <openssl/err.h>
#include <openssl/bio.h>
/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR
#define ERR_FUNC(func) ERR_PACK(ERR_LIB_BIO,func,0)
#define ERR_REASON(reason) ERR_PACK(ERR_LIB_BIO,0,reason)
#include <string.h> 
#include <sys/stat.h> 
#include <sys/ipc.h> 
#include <sys/shm.h> 
#include <sys/types.h> 
#include <stonesoup/stonesoup_trace.h> 
static ERR_STRING_DATA BIO_str_functs[] = {{((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )100) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("ACPT_STATE")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )101) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_accept")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )102) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_BER_GET_HEADER")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )131) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_callback_ctrl")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )103) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_ctrl")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )120) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_gethostbyname")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )104) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_gets")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )105) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_get_accept_socket")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )106) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_get_host_ip")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )107) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_get_port")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )121) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_MAKE_PAIR")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )108) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_new")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )109) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_new_file")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )126) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_new_mem_buf")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )123) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_nread")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )124) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_nread0")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )125) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_nwrite")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )122) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_nwrite0")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )110) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_puts")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )111) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_read")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )112) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_sock_init")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )113) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BIO_write")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )114) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("BUFFER_CTRL")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )127) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("CONN_CTRL")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )115) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("CONN_STATE")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )132) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("DGRAM_SCTP_READ")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )116) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("FILE_CTRL")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )130) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("FILE_READ")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )129) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("LINEBUFFER_CTRL")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )128) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("MEM_READ")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )117) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("MEM_WRITE")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )118) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("SSL_new")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )119) & 0xfffL) * 0x1000 | ((unsigned long )0) & 0xfffL), ("WSASTARTUP")}, {(0), (((void *)0))}};
static ERR_STRING_DATA BIO_str_reasons[] = {{((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )100) & 0xfffL), ("accept error")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )101) & 0xfffL), ("bad fopen mode")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )102) & 0xfffL), ("bad hostname lookup")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )124) & 0xfffL), ("broken pipe")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )103) & 0xfffL), ("connect error")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )127) & 0xfffL), ("EOF on memory BIO")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )104) & 0xfffL), ("error setting nbio")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )105) & 0xfffL), ("error setting nbio on accepted socket")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )106) & 0xfffL), ("error setting nbio on accept socket")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )107) & 0xfffL), ("gethostbyname addr is not af inet")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )125) & 0xfffL), ("invalid argument")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )108) & 0xfffL), ("invalid ip address")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )123) & 0xfffL), ("in use")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )109) & 0xfffL), ("keepalive")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )110) & 0xfffL), ("nbio connect error")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )111) & 0xfffL), ("no accept port specified")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )112) & 0xfffL), ("no hostname specified")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )113) & 0xfffL), ("no port defined")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )114) & 0xfffL), ("no port specified")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )128) & 0xfffL), ("no such file")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )115) & 0xfffL), ("null parameter")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )116) & 0xfffL), ("tag mismatch")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )117) & 0xfffL), ("unable to bind socket")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )118) & 0xfffL), ("unable to create socket")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )119) & 0xfffL), ("unable to listen socket")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )120) & 0xfffL), ("uninitialized")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )121) & 0xfffL), ("unsupported method")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )126) & 0xfffL), ("write to read only BIO")}, {((((unsigned long )32) & 0xffL) * 0x1000000 | (((unsigned long )0) & 0xfffL) * 0x1000 | ((unsigned long )122) & 0xfffL), ("WSAStartup")}, {(0), (((void *)0))}};
#endif
int niobrara_stelliferous = 0;
int stonesoup_global_variable;

union unpulverize_unskirmished 
{
  char *oxidises_peachblossom;
  double gluteofemoral_graciously;
  char *nos_nontaxer;
  char deodorizes_grantiidae;
  int marshberries_daniglacial;
}
;
void* stonesoup_printf_context = NULL;
void stonesoup_setup_printf_context() {
    struct stat st = {0};
    char * ss_tc_root = NULL;
    char * dirpath = NULL;
    int size_dirpath = 0;
    char * filepath = NULL;
    int size_filepath = 0;
    int retval = 0;
    ss_tc_root = getenv("SS_TC_ROOT");
    if (ss_tc_root != NULL) {
        size_dirpath = strlen(ss_tc_root) + strlen("testData") + 2;
        dirpath = (char*) malloc (size_dirpath * sizeof(char));
        if (dirpath != NULL) {
            sprintf(dirpath, "%s/%s", ss_tc_root, "testData");
            retval = 0;
            if (stat(dirpath, &st) == -1) {
                retval = mkdir(dirpath, 0700);
            }
            if (retval == 0) {
                size_filepath = strlen(dirpath) + strlen("logfile.txt") + 2;
                filepath = (char*) malloc (size_filepath * sizeof(char));
                if (filepath != NULL) {
                    sprintf(filepath, "%s/%s", dirpath, "logfile.txt");
                    stonesoup_printf_context = fopen(filepath, "w");
                    free(filepath);
                }
            }
            free(dirpath);
        }
    }
    if (stonesoup_printf_context == NULL) {
        stonesoup_printf_context = stderr;
    }
}
void stonesoup_printf(char * format, ...) {
    va_list argptr;
    va_start(argptr, format);
    vfprintf(stonesoup_printf_context, format, argptr);
    va_end(argptr);
    fflush(stonesoup_printf_context);
}
void stonesoup_close_printf_context() {
    if (stonesoup_printf_context != NULL &&
        stonesoup_printf_context != stderr) {
        fclose(stonesoup_printf_context);
    }
}
void stonesoup_read_taint(char** stonesoup_tainted_buff, char* stonesoup_envKey, int stonesoup_shmsz) {
    int stonesoup_shmid;
 key_t stonesoup_key;
 char *stonesoup_shm, *stonesoup_s;
 char* stonesoup_envSize = NULL;
 *stonesoup_tainted_buff = NULL;
    if (getenv("STONESOUP_DISABLE_WEAKNESS") == NULL ||
        strcmp(getenv("STONESOUP_DISABLE_WEAKNESS"), "1") != 0) {
        if(stonesoup_envKey != NULL) {
            if(sscanf(stonesoup_envKey, "%d", &stonesoup_key) > 0) {
                if ((stonesoup_shmid = shmget(stonesoup_key, stonesoup_shmsz, 0666)) >= 0) {
                    if ((stonesoup_shm = shmat(stonesoup_shmid, NULL, 0)) != (char *) -1) {
                        *stonesoup_tainted_buff = (char*)calloc(stonesoup_shmsz, sizeof(char));
                        /* STONESOUP: SOURCE-TAINT (Shared Memory) */
                        for (stonesoup_s = stonesoup_shm; *stonesoup_s != (char)0; stonesoup_s++) {
                            (*stonesoup_tainted_buff)[stonesoup_s - stonesoup_shm] = *stonesoup_s;
                        }
                    }
                }
            }
        }
    } else {
        *stonesoup_tainted_buff = NULL;
    }
}
void haggadot_gasts(union unpulverize_unskirmished *florideae_russniak);
void bisulphide_polygala(union unpulverize_unskirmished *shored_grandness);
void apoplectic_duplicity(union unpulverize_unskirmished *blissfully_chime);
void myrmecochorous_unilamellate(union unpulverize_unskirmished *illuminated_carpetbag);
void noddingly_coyanosa(union unpulverize_unskirmished *scop_cheatery);
void abrege_sporotrichosis(union unpulverize_unskirmished *josser_resupination);
void morgun_fissureless(union unpulverize_unskirmished *plumtree_presbyteral);
void foreship_giterne(union unpulverize_unskirmished *ural_gibbed);
void frizzling_overfee(union unpulverize_unskirmished *stegosaurian_fugitive);
void ushijima_micrander(union unpulverize_unskirmished *streak_bloomier);
void maurise_waddlers(union unpulverize_unskirmished *congestus_sertion);
void jonis_farver(union unpulverize_unskirmished *casandra_pondbush);
void thorax_tinnient(union unpulverize_unskirmished *chirpiest_repulses);
void combiners_kayenta(union unpulverize_unskirmished *yokkaichi_ambystoma);
void photoetcher_pentastom(union unpulverize_unskirmished *waistcoatless_emigration);
void aristocratism_santapee(union unpulverize_unskirmished *meletius_masterson);
void clumplike_amylolysis(union unpulverize_unskirmished *nonexportable_ramulose);
void aani_ogdoad(union unpulverize_unskirmished *stuffs_churinga);
void preinduce_vinosulphureous(union unpulverize_unskirmished *blennometritis_heracleum);
void ichthyopsida_authenticated(union unpulverize_unskirmished *impearl_obbenite);
void befret_overgently(union unpulverize_unskirmished *erysipelous_candida);
void generated_wifing(union unpulverize_unskirmished *lashlite_duskier);
void thinia_eumoirous(union unpulverize_unskirmished *resizes_reticello);
void mycorrhizic_forbare(union unpulverize_unskirmished *jacksmelts_alerion);
void skieppe_outstair(union unpulverize_unskirmished *tabret_polymastodon);
void clark_tat(union unpulverize_unskirmished *phenylcarbamic_quitted);
void disburden_survivors(union unpulverize_unskirmished *unwarmed_rifest);
void dualizes_detestability(union unpulverize_unskirmished *sheepshank_exrx);
void templia_frostings(union unpulverize_unskirmished *dimensive_ludibrious);
void runology_seiches(union unpulverize_unskirmished *louanne_convocational);
void merotropism_reitboks(union unpulverize_unskirmished *astomatous_polykaryocyte);
void internships_shortliffe(union unpulverize_unskirmished *witchwoman_molds);
void subclassed_equiseta(union unpulverize_unskirmished *goddammit_pirouettist);
void observant_tremetol(union unpulverize_unskirmished *divestitive_professionalist);
void printings_protracheate(union unpulverize_unskirmished *impetrated_monosepalous);
void unalluringly_amagansett(union unpulverize_unskirmished *infaust_overtarry);
void chaldaic_protista(union unpulverize_unskirmished *narrawood_marrin);
void leucorrheal_hydromechanical(union unpulverize_unskirmished *cochranea_airbrick);
void untaped_demiplate(union unpulverize_unskirmished *twofolds_anatiferous);
void foreheads_tedesca(union unpulverize_unskirmished *thirst_notum);
void phoby_murarium(union unpulverize_unskirmished *imposingness_dinuba);
void unfairer_indissolubility(union unpulverize_unskirmished *aminobenzoic_chab);
void parnell_skemmel(union unpulverize_unskirmished *epityphlon_pulmobranchiate);
void camponotus_wincher(union unpulverize_unskirmished *priorates_compatience);
void myxomatosis_leibnitz(union unpulverize_unskirmished *epicure_tailwise);
void sanataria_hoppercar(union unpulverize_unskirmished *escribientes_philodinidae);
void algie_disrober(union unpulverize_unskirmished *patrimonies_preliberally);
void dochmiac_polyuresis(union unpulverize_unskirmished *lasing_unconscionably);
void urotoxicity_daisybush(union unpulverize_unskirmished *truing_twaddleize);
void aircraftmen_superoratorical(union unpulverize_unskirmished *statesmanese_outburnt);
char stonesoup_process_buffer(char *buffer_param)
{
  tracepoint(stonesoup_trace, trace_location, "/tmp/tmpTOfelJ_ss_testcase/src-rose/crypto/bio/bio_err.c", "stonesoup_process_buffer");
  char first_char;
  first_char = buffer_param[0] - 97;
  free(buffer_param);
  return first_char;
}
int stonesoup_toupper(int c)
{
  if (c >= 97 && c <= 122) {
    return c - 32;
  }
  return c;
}

void ERR_load_BIO_strings()
{
  int jarnut_augurer;
  union unpulverize_unskirmished *metisses_nonintervention = {0};
  union unpulverize_unskirmished *anticipant_availingly = {0};
  union unpulverize_unskirmished provection_faso;
  int mentorship_ghauts = 44;
  char *muralists_parodyproof;;
  if (__sync_bool_compare_and_swap(&niobrara_stelliferous,0,1)) {;
    if (mkdir("/opt/stonesoup/workspace/lockDir",509U) == 0) {;
      tracepoint(stonesoup_trace,trace_location,"/tmp/tmpTOfelJ_ss_testcase/src-rose/crypto/bio/bio_err.c","ERR_load_BIO_strings");
      stonesoup_setup_printf_context();
      stonesoup_read_taint(&muralists_parodyproof,"8207",mentorship_ghauts);
      if (muralists_parodyproof != 0) {;
        provection_faso . oxidises_peachblossom = muralists_parodyproof;
        jarnut_augurer = 1;
        metisses_nonintervention = &provection_faso;
        anticipant_availingly = ((union unpulverize_unskirmished *)(((unsigned long )metisses_nonintervention) * jarnut_augurer * jarnut_augurer)) + 5;
        haggadot_gasts(anticipant_availingly);
      }
    }
  }
  ;
#ifndef OPENSSL_NO_ERR
  if (ERR_func_error_string(BIO_str_functs[0] . error) == ((void *)0)) {
    ERR_load_strings(0,BIO_str_functs);
    ERR_load_strings(0,BIO_str_reasons);
  }
#endif
}

void haggadot_gasts(union unpulverize_unskirmished *florideae_russniak)
{
  ++stonesoup_global_variable;;
  bisulphide_polygala(florideae_russniak);
}

void bisulphide_polygala(union unpulverize_unskirmished *shored_grandness)
{
  ++stonesoup_global_variable;;
  apoplectic_duplicity(shored_grandness);
}

void apoplectic_duplicity(union unpulverize_unskirmished *blissfully_chime)
{
  ++stonesoup_global_variable;;
  myrmecochorous_unilamellate(blissfully_chime);
}

void myrmecochorous_unilamellate(union unpulverize_unskirmished *illuminated_carpetbag)
{
  ++stonesoup_global_variable;;
  noddingly_coyanosa(illuminated_carpetbag);
}

void noddingly_coyanosa(union unpulverize_unskirmished *scop_cheatery)
{
  ++stonesoup_global_variable;;
  abrege_sporotrichosis(scop_cheatery);
}

void abrege_sporotrichosis(union unpulverize_unskirmished *josser_resupination)
{
  ++stonesoup_global_variable;;
  morgun_fissureless(josser_resupination);
}

void morgun_fissureless(union unpulverize_unskirmished *plumtree_presbyteral)
{
  ++stonesoup_global_variable;;
  foreship_giterne(plumtree_presbyteral);
}

void foreship_giterne(union unpulverize_unskirmished *ural_gibbed)
{
  ++stonesoup_global_variable;;
  frizzling_overfee(ural_gibbed);
}

void frizzling_overfee(union unpulverize_unskirmished *stegosaurian_fugitive)
{
  ++stonesoup_global_variable;;
  ushijima_micrander(stegosaurian_fugitive);
}

void ushijima_micrander(union unpulverize_unskirmished *streak_bloomier)
{
  ++stonesoup_global_variable;;
  maurise_waddlers(streak_bloomier);
}

void maurise_waddlers(union unpulverize_unskirmished *congestus_sertion)
{
  ++stonesoup_global_variable;;
  jonis_farver(congestus_sertion);
}

void jonis_farver(union unpulverize_unskirmished *casandra_pondbush)
{
  ++stonesoup_global_variable;;
  thorax_tinnient(casandra_pondbush);
}

void thorax_tinnient(union unpulverize_unskirmished *chirpiest_repulses)
{
  ++stonesoup_global_variable;;
  combiners_kayenta(chirpiest_repulses);
}

void combiners_kayenta(union unpulverize_unskirmished *yokkaichi_ambystoma)
{
  ++stonesoup_global_variable;;
  photoetcher_pentastom(yokkaichi_ambystoma);
}

void photoetcher_pentastom(union unpulverize_unskirmished *waistcoatless_emigration)
{
  ++stonesoup_global_variable;;
  aristocratism_santapee(waistcoatless_emigration);
}

void aristocratism_santapee(union unpulverize_unskirmished *meletius_masterson)
{
  ++stonesoup_global_variable;;
  clumplike_amylolysis(meletius_masterson);
}

void clumplike_amylolysis(union unpulverize_unskirmished *nonexportable_ramulose)
{
  ++stonesoup_global_variable;;
  aani_ogdoad(nonexportable_ramulose);
}

void aani_ogdoad(union unpulverize_unskirmished *stuffs_churinga)
{
  ++stonesoup_global_variable;;
  preinduce_vinosulphureous(stuffs_churinga);
}

void preinduce_vinosulphureous(union unpulverize_unskirmished *blennometritis_heracleum)
{
  ++stonesoup_global_variable;;
  ichthyopsida_authenticated(blennometritis_heracleum);
}

void ichthyopsida_authenticated(union unpulverize_unskirmished *impearl_obbenite)
{
  ++stonesoup_global_variable;;
  befret_overgently(impearl_obbenite);
}

void befret_overgently(union unpulverize_unskirmished *erysipelous_candida)
{
  ++stonesoup_global_variable;;
  generated_wifing(erysipelous_candida);
}

void generated_wifing(union unpulverize_unskirmished *lashlite_duskier)
{
  ++stonesoup_global_variable;;
  thinia_eumoirous(lashlite_duskier);
}

void thinia_eumoirous(union unpulverize_unskirmished *resizes_reticello)
{
  ++stonesoup_global_variable;;
  mycorrhizic_forbare(resizes_reticello);
}

void mycorrhizic_forbare(union unpulverize_unskirmished *jacksmelts_alerion)
{
  ++stonesoup_global_variable;;
  skieppe_outstair(jacksmelts_alerion);
}

void skieppe_outstair(union unpulverize_unskirmished *tabret_polymastodon)
{
  ++stonesoup_global_variable;;
  clark_tat(tabret_polymastodon);
}

void clark_tat(union unpulverize_unskirmished *phenylcarbamic_quitted)
{
  ++stonesoup_global_variable;;
  disburden_survivors(phenylcarbamic_quitted);
}

void disburden_survivors(union unpulverize_unskirmished *unwarmed_rifest)
{
  ++stonesoup_global_variable;;
  dualizes_detestability(unwarmed_rifest);
}

void dualizes_detestability(union unpulverize_unskirmished *sheepshank_exrx)
{
  ++stonesoup_global_variable;;
  templia_frostings(sheepshank_exrx);
}

void templia_frostings(union unpulverize_unskirmished *dimensive_ludibrious)
{
  ++stonesoup_global_variable;;
  runology_seiches(dimensive_ludibrious);
}

void runology_seiches(union unpulverize_unskirmished *louanne_convocational)
{
  ++stonesoup_global_variable;;
  merotropism_reitboks(louanne_convocational);
}

void merotropism_reitboks(union unpulverize_unskirmished *astomatous_polykaryocyte)
{
  ++stonesoup_global_variable;;
  internships_shortliffe(astomatous_polykaryocyte);
}

void internships_shortliffe(union unpulverize_unskirmished *witchwoman_molds)
{
  ++stonesoup_global_variable;;
  subclassed_equiseta(witchwoman_molds);
}

void subclassed_equiseta(union unpulverize_unskirmished *goddammit_pirouettist)
{
  ++stonesoup_global_variable;;
  observant_tremetol(goddammit_pirouettist);
}

void observant_tremetol(union unpulverize_unskirmished *divestitive_professionalist)
{
  ++stonesoup_global_variable;;
  printings_protracheate(divestitive_professionalist);
}

void printings_protracheate(union unpulverize_unskirmished *impetrated_monosepalous)
{
  ++stonesoup_global_variable;;
  unalluringly_amagansett(impetrated_monosepalous);
}

void unalluringly_amagansett(union unpulverize_unskirmished *infaust_overtarry)
{
  ++stonesoup_global_variable;;
  chaldaic_protista(infaust_overtarry);
}

void chaldaic_protista(union unpulverize_unskirmished *narrawood_marrin)
{
  ++stonesoup_global_variable;;
  leucorrheal_hydromechanical(narrawood_marrin);
}

void leucorrheal_hydromechanical(union unpulverize_unskirmished *cochranea_airbrick)
{
  ++stonesoup_global_variable;;
  untaped_demiplate(cochranea_airbrick);
}

void untaped_demiplate(union unpulverize_unskirmished *twofolds_anatiferous)
{
  ++stonesoup_global_variable;;
  foreheads_tedesca(twofolds_anatiferous);
}

void foreheads_tedesca(union unpulverize_unskirmished *thirst_notum)
{
  ++stonesoup_global_variable;;
  phoby_murarium(thirst_notum);
}

void phoby_murarium(union unpulverize_unskirmished *imposingness_dinuba)
{
  ++stonesoup_global_variable;;
  unfairer_indissolubility(imposingness_dinuba);
}

void unfairer_indissolubility(union unpulverize_unskirmished *aminobenzoic_chab)
{
  ++stonesoup_global_variable;;
  parnell_skemmel(aminobenzoic_chab);
}

void parnell_skemmel(union unpulverize_unskirmished *epityphlon_pulmobranchiate)
{
  ++stonesoup_global_variable;;
  camponotus_wincher(epityphlon_pulmobranchiate);
}

void camponotus_wincher(union unpulverize_unskirmished *priorates_compatience)
{
  ++stonesoup_global_variable;;
  myxomatosis_leibnitz(priorates_compatience);
}

void myxomatosis_leibnitz(union unpulverize_unskirmished *epicure_tailwise)
{
  ++stonesoup_global_variable;;
  sanataria_hoppercar(epicure_tailwise);
}

void sanataria_hoppercar(union unpulverize_unskirmished *escribientes_philodinidae)
{
  ++stonesoup_global_variable;;
  algie_disrober(escribientes_philodinidae);
}

void algie_disrober(union unpulverize_unskirmished *patrimonies_preliberally)
{
  ++stonesoup_global_variable;;
  dochmiac_polyuresis(patrimonies_preliberally);
}

void dochmiac_polyuresis(union unpulverize_unskirmished *lasing_unconscionably)
{
  ++stonesoup_global_variable;;
  urotoxicity_daisybush(lasing_unconscionably);
}

void urotoxicity_daisybush(union unpulverize_unskirmished *truing_twaddleize)
{
  ++stonesoup_global_variable;;
  aircraftmen_superoratorical(truing_twaddleize);
}

void aircraftmen_superoratorical(union unpulverize_unskirmished *statesmanese_outburnt)
{
    int stonesoup_oc_i = 0;
    int stonesoup_tainted_len;
    char **stonesoup_buffer_ptr = 0;
    int stonesoup_main_first_char = 0;
    int stonesoup_buffer_len;
    char *stonesoup_buffer = 0;
  char *professing_lucent = 0;
  ++stonesoup_global_variable;;
  professing_lucent = ((char *)( *(statesmanese_outburnt - 5)) . oxidises_peachblossom);
    tracepoint(stonesoup_trace, weakness_start, "CWE416", "A", "Use After Free");
    stonesoup_buffer_len = 4;
    stonesoup_buffer = malloc(65528);
    if (stonesoup_buffer != NULL) {
        strncpy(stonesoup_buffer, professing_lucent, stonesoup_buffer_len);
        stonesoup_buffer[stonesoup_buffer_len - 1] = 0;
        stonesoup_printf("%s\n", stonesoup_buffer);
        tracepoint(stonesoup_trace, variable_signed_integral, "stonesoup_oc_i", stonesoup_oc_i, &stonesoup_oc_i, "INITIAL-STATE");
        tracepoint(stonesoup_trace, variable_signed_integral, "stonesoup_tainted_len", stonesoup_tainted_len, &stonesoup_tainted_len, "INITIAL-STATE");
        tracepoint(stonesoup_trace, variable_address, "stonesoup_buffer_ptr", stonesoup_buffer_ptr, "INITIAL-STATE");
        tracepoint(stonesoup_trace, variable_signed_integral, "stonesoup_main_first_char", stonesoup_main_first_char, &stonesoup_main_first_char, "INITIAL-STATE");
        tracepoint(stonesoup_trace, variable_signed_integral, "stonesoup_buffer_len", stonesoup_buffer_len, &stonesoup_buffer_len, "INITIAL-STATE");
        tracepoint(stonesoup_trace, variable_address, "stonesoup_buffer", stonesoup_buffer, "INITIAL-STATE");
        tracepoint(stonesoup_trace, trace_point, "CROSSOVER-POINT: BEFORE");
        /* STONESOUP: CROSSOVER-POINT (Use After Free) */
        if (stonesoup_buffer[0] >= 97) {
            tracepoint(stonesoup_trace, variable_address, "stonesoup_buffer", stonesoup_buffer, "CROSSOVER-STATE");
            stonesoup_main_first_char = stonesoup_process_buffer(stonesoup_buffer);
        }
        tracepoint(stonesoup_trace, trace_point, "CROSSOVER-POINT: AFTER");
        stonesoup_buffer_ptr = malloc(65528);
        tracepoint(stonesoup_trace, variable_address, "stonesoup_buffer_ptr", stonesoup_buffer_ptr, "CROSSOVER-STATE");
        if (stonesoup_buffer_ptr != NULL) {
            *stonesoup_buffer_ptr = professing_lucent;
            tracepoint(stonesoup_trace, trace_point, "TRIGGER-POINT: BEFORE");
            tracepoint(stonesoup_trace, variable_address, "stonesoup_buffer", stonesoup_buffer, "TRIGGER-STATE");
            tracepoint(stonesoup_trace, variable_address, "stonesoup_buffer_ptr", stonesoup_buffer_ptr, "TRIGGER-STATE");
            tracepoint(stonesoup_trace, variable_address, "*stonesoup_buffer_ptr", *stonesoup_buffer_ptr, "TRIGGER-STATE");
            /* STONESOUP: TRIGGER-POINT (Use After Free) */
            strncpy(stonesoup_buffer, professing_lucent, stonesoup_buffer_len);
            stonesoup_buffer[stonesoup_buffer_len - 1] = '\0';
            stonesoup_tainted_len = strlen( *stonesoup_buffer_ptr); /* fail*/
            tracepoint(stonesoup_trace, trace_point, "TRIGGER-POINT: AFTER");
            stonesoup_printf("%c\n", stonesoup_main_first_char);
            for (; stonesoup_oc_i < stonesoup_buffer_len; ++stonesoup_oc_i) {
                stonesoup_buffer[stonesoup_oc_i] = stonesoup_toupper(stonesoup_buffer[stonesoup_oc_i]);
            }
            stonesoup_printf("%s\n", stonesoup_buffer);
            if (stonesoup_main_first_char == 0) {
                if (stonesoup_buffer != 0) {
                    free(stonesoup_buffer);
                }
            }
            if (stonesoup_buffer_ptr != 0) {
                free(stonesoup_buffer_ptr);
            }
        }
    }
    tracepoint(stonesoup_trace, weakness_end);
;
  if (( *(statesmanese_outburnt - 5)) . oxidises_peachblossom != 0) 
    free(((char *)( *(statesmanese_outburnt - 5)) . oxidises_peachblossom));
stonesoup_close_printf_context();
}
