"""
Trains a ResNet emulator for the 1D advection equation under high difficulty
(advection_gamma=CFL=10.5) with increasing supervised unrolling steps.
"""

CONFIGS = [
    {
        "scenario": "diff_adv",
        "task": "predict",
        "net": "Res;26;8;relu",  # 32'943 params, 16 receptive field per direction
        "train": f"sup;{rollout:02d}",
        "start_seed": s,
        "num_seeds": 10,
        "advection_gamma": 10.5,
    }
    for s in [0, 10, 20, 30, 40]
    for rollout in [
        1,
        2,
        3,
        5,
        10,
        15,
    ]
]
