"""
Produces the 2D results of the broad comparison across architectures and
dynamics.

Full prediction learning with one-step supervised training.
"""
CONFIGS = [
    {
        "scenario": scene,
        "task": "predict",
        "net": net,
        "train": "one",
        "start_seed": s,
        "num_seeds": 1,
        "num_spatial_dims": 2,
    }
    for s in range(20)
    for net in [
        "Conv;26;11;relu",  # 61'595 params, 12 receptive field per direction
        "UNet;10;2;relu",  # 55'661 params, 29 receptive field per direction
        "Res;26;5;relu",  # 61'179 params, 10 receptive field per direction
        "FNO;10;6;4;gelu",  # 57'787 params, inf receptive field per direction
        "Dil;2;26;2;relu",  # 61'699 params, 20 receptive field per direction
    ]
    for scene in [
        "phy_aniso_diff",
        "diff_burgers",  # Uses the two-channel version in 2D
        "diff_ks",
        "phy_kolm_flow",
        "phy_gs_type",
    ]
]
