import numpy as np
from gym import utils
from gym.envs.mujoco import mujoco_env
import os.path as osp
from mtrl.mtenv.envs.gym_extensions.wall_envs import MazeFactory
from mtrl.mtenv.envs.gym_extensions.gravity_envs import GravityEnvFactory
from mtrl.mtenv.envs.gym_extensions.perturbed_bodypart_env import ModifiedSizeEnvFactory

from gym.envs.mujoco.ant import AntEnv

import os
import gym


AntGravityEnv = lambda *args, **kwargs : GravityEnvFactory(ModifiedAntEnv)(model_path=os.path.dirname(gym.envs.mujoco.__file__) + "/assets/ant.xml", *args, **kwargs)


AntMaze = lambda *args, **kwargs : MazeFactory(ModifiedAntEnv)(model_path=os.path.dirname(gym.envs.mujoco.__file__) + "/assets/ant.xml", ori_ind=0, *args, **kwargs)




class ModifiedAntEnv(AntEnv, utils.EzPickle):
    """
    Simply allows changing of XML file, probably not necessary if we pull request the xml name as a kwarg in openai gym
    """
    def __init__(self, **kwargs):
        mujoco_env.MujocoEnv.__init__(self, kwargs["model_path"], 4)
        utils.EzPickle.__init__(self)
