# DMPlug: A Plug-in Method for Solving Inverse Problems with Diffusion Models

## Dataset

We provide you with example data of CelebA, FFHQ and LSUN-Bedroom under ./data/.

## Dependencies

```
conda env create -f environment.yml
conda activate dmplug
```

## Download pretrained checkpoint

From the [link](https://onedrive.live.com/?authkey=%21AOIJGI8FUQXvFf8&id=72419B431C262344%21103807&cid=72419B431C262344), download the checkpoint "celebahq_p2.pt" and paste it to ./models/;

From the [link](https://drive.google.com/drive/folders/1jElnRoFv7b31fG0v6pTSQkelbSX3xGZh), download the checkpoint "ffhq_10m.pt" and paste it to ./models/;

From the [link](https://github.com/openai/guided-diffusion), download the checkpoint "lsun_bedroom.pt" and paste it to ./models/.

From the [link](https://drive.google.com/file/d/1vRoDpIsrTRYZKsOMPNbPcMtFDpCT6Foy/view), download the checkpoint "GOPRO_wVAE.pth" and paste it to ./experiments/pretrained/.

## Task Configurations

```
# Linear inverse problems
- configs/tasks/super_resolution_config.yaml
- configs/tasks/inpainting_config.yaml

# Non-linear inverse problems
- configs/tasks/nonuniform_deblur_config.yaml
- configs/tasks/gaussian_deblur_config.yaml
- configs/tasks/motion_deblur_config.yaml
- configs/tasks/turbulence_config.yaml
```

## Inference

```
# Superresolution, inpainting, non-uniform deblurring
python sr_inp_nonuniform.py --task 'super_resolution'
python sr_inp_nonuniform.py --task 'inpainting'
python sr_inp_nonuniform.py --task 'nonuniform_deblur'

# BID
python bid.py --kernel 'motion'
python bid.py --kernel 'gaussian'

# BID with turbulence
python turbulence.py
```

## References
This repo is developed based on [DPS](https://github.com/DPS2022/diffusion-posterior-sampling) and [BlindDPS](https://github.com/BlindDPS/blind-dps), especially for forward operations. For motion and non-uniform deblurring, we use the code from [motionblur](https://github.com/LeviBorodenko/motionblur) and [bkse](https://github.com/VinAIResearch/blur-kernel-space-exploring), respectively. Please also consider citing them if you use this repo.