_base_ = [
    '../swin/mask-rcnn_swin-t-p4-w7_fpn_1x_coco.py'
]

model = dict(
    backbone=dict(
        type='MM_VSSM',
        out_indices=(0, 1, 2, 3),
        pretrained="../ckpts/small/ckpt_epoch_280.pth",
        dims=64,
        depths=(2, 6, 2, 2),
        ssm_d_state=1,
        ssm_dt_rank="auto",
        ssm_ratio=1.0,
        mlp_ratio=4.0,
        downsample_version="v3",
        patchembed_version="v2",
        ssm_conv_bias=False,
        ssm_conv = 3,
        forward_type="v05_noz", # if you want exactly the same
    ),
    neck=dict(in_channels=[64, 128, 256, 512]),
)

# too big
train_dataloader = dict(batch_size=1) # as gpus=16



"""
MODEL:
  TYPE: vssm
  NAME: vssm1_tiny_0230
  DROP_PATH_RATE: 0.2
  VSSM:
    EMBED_DIM: 96
    DEPTHS: [ 2, 2, 5, 2 ]
    SSM_D_STATE: 1
    SSM_DT_RANK: "auto"
    SSM_RATIO: 2.0
    SSM_CONV: 3
    SSM_CONV_BIAS: false
    SSM_FORWARDTYPE: "v05_noz" # v3_noz
    MLP_RATIO: 4.0
    DOWNSAMPLE: "v3"
    PATCHEMBED: "v2"

"""