import torch.nn as nn

from dcrl.utils.model_utils import layer_init


class StateCriticModel(nn.Module):
    def __init__(
        self,
        obs_space,
        recurrent=False,
        hidden_size_list=None,
        rnn_hidden_size=None,
        get_representation_net_func=None,
    ):
        super().__init__()

        self.recurrent = recurrent
        self.hidden_size_list = hidden_size_list
        self.rnn_hidden_size = rnn_hidden_size

        # Define representation net
        self.representation_net, self.tensor_type, self.rep_size = get_representation_net_func(obs_space["state"])

        self.embedding_size = self.rep_size

        # Define value net
        self.value_net = []
        input_size = self.embedding_size
        for i in range(len(self.hidden_size_list)):
            self.value_net.append(layer_init(nn.Linear(input_size, self.hidden_size_list[i])))
            self.value_net.append(nn.ReLU())
            input_size = self.hidden_size_list[i]
        self.value_net = nn.Sequential(*self.value_net)

        self.value_head = layer_init(nn.Linear(input_size, 1), std=1.0)

    @property
    def memory_size(self):
        return 2 * self.rnn_hidden_size

    @property
    def value_size(self):
        return 1

    def forward(self, obs, memory=None):
        x = obs["state"].type(self.tensor_type)
        embedding = self.representation_net(x)

        output = self.value_net(embedding)
        value = self.value_head(output)

        return value, memory
