# Advancing Training Efficiency of Deep Spiking Neural Networks through Rate-based Backpropagation

This repository is the PyTorch implementation of the paper: Advancing Training Efficiency of Deep Spiking Neural
Networks through Rate-based Backpropagation.

## Dependencies

- Python >= 3.6
- PyTorch >= 1.7.1
- Spikingjelly
- Torchvision
- Python packages: `pip install numpy matplotlib progress`

## Training

Please run the following code. The hyperparameters in the code are the same as in the paper.

### CIFAR-10

    python experiment/cifar/main.py --arch rate_resnet18 --rate_flag --auto_aug --cutout --wd 5e-4 --dataset CIFAR100 --T 6 --decay 0.2 --thresh 1.0 --data_path [data_path] --num_workers 0

### CIFAR-100

	python experiment/cifar/main.py --arch rate_resnet18 --rate_flag --auto_aug --cutout --wd 5e-4 --dataset CIFAR100 --T 6 --decay 0.2 --thresh 1.0 --data_path [data_path] --num_workers 0

