import argparse


parser = argparse.ArgumentParser()
# Seed and Gpu ID
parser.add_argument('--seed', type=int, default=273, help="Seed")
parser.add_argument("--gpu", type=int, default=-1, help="GPU ID")
# Dataset
parser.add_argument('--dataset', type=str, default='airport',
                    help="Dataset name: [cora, citeseer, wikics, airport, disease, amz]")
# Training Setting
parser.add_argument("--lr", type=float, default=0.01, help="Learning rate")
parser.add_argument('--weight-decay', type=float, default=0.00, help="Weight decay")
parser.add_argument("--patient", type=int, default=800,
                    help="Early stop")
parser.add_argument('--s-epochs', type=int, default=1600, help="Epochs")
parser.add_argument('--mode', type=str, default='mi', help="Training mode")
parser.add_argument('--tofull', type=int, default=200, help="Change mode to full after tofull epochs")
# Euclidean Teacher Model Setting
parser.add_argument("--et_layer_num", type=int, default=2, help="Euclidean Teacher model's hidden layer num")
parser.add_argument("--et_hidden_num", type=int, default=128, help="Euclidean Teacher model's hidden layer dimension")
# Hyperbolic Teacher Model Setting
parser.add_argument("--ht_layer_num", type=int, default=2, help="Hyperbolic Teacher model's hidden layer num")
parser.add_argument("--ht_hidden_num", type=int, default=128, help="Hyperbolic Teacher model's hidden layer dimension")
parser.add_argument("--normalize-feats", type=int, default=1, help="Whether to normalize input node features")
parser.add_argument("--normalize-adj", type=int, default=1, help="Whether to row-normalize the adjacency matrix")
parser.add_argument("--use-feats", type=int, default=1, help="Whether to use node features or not")
parser.add_argument('--manifold', type=str, default='PoincareBall',
                    help="Hyperbolic space models [Euclidean, Hyperboloid, PoincareBall]")
parser.add_argument("--c", type=float, default=None, help="Hyperbolic teacher model's curvature")
parser.add_argument("--dropout", type=float, default=0.0, help="Hyperbolic teacher model's dropout")
parser.add_argument('--act', type=str, default='relu',
                    help="Hyperbolic teacher model's activation function")
parser.add_argument('--optimizer', type=str, default='Adam',
                    help="Hyperbolic teacher model's optimizer, [Adam, RiemannianAdam]")
# Student Model Setting
parser.add_argument("--s_layer_num", type=int, default=2, help="Student model's hidden layer num")
parser.add_argument("--s_hidden_num", type=int, default=16, help="Student model's hidden layer dimension")

args = parser.parse_args()

