import numpy as np
from torch_geometric.data import Batch
from torch.utils.data import DataLoader
from torch_geometric.loader import NeighborLoader


class DataLoaders:
    def __init__(
            self,
            datasets,
            batch_size: int,
            workers: int = 0,
            collate_fn=None,
            shuffle_train=True,
            shuffle_val=False
    ):
        super().__init__()
        self.train_dataset = datasets
        self.batch_size = batch_size

        self.workers = workers
        self.collate_fn = collate_fn
        self.shuffle_train, self.shuffle_val = shuffle_train, shuffle_val

        self.train = self.train_dataloader()
        # self.valid = self.val_dataloader()
        # self.test = self.test_dataloader()

    def train_dataloader(self):
        return self._make_dloader("train", shuffle=self.shuffle_train)

    def val_dataloader(self):
        return self._make_dloader("val", shuffle=self.shuffle_val)

    def test_dataloader(self):
        return self._make_dloader("test", shuffle=False)

    def _make_dloader(self, split, shuffle=False):
        dataset = None
        if split == 'train':
            dataset = self.train_dataset
        elif split == 'val':
            dataset = self.valid_dataset
        elif split == 'test':
            dataset = self.test_dataset
        if len(dataset) == 0: return None
        return NeighborLoader(
            dataset,
            shuffle=shuffle,
            batch_size=self.batch_size,
            num_neighbors=[10]
        )


