/*
 * Decompiled with CFR 0.152.
 */
package language.runtime.runners;

import java.io.Serializable;
import language.model.ClassDef;
import language.model.PropertyFunction;
import language.model.Statement;
import language.runtime.Interpreter;
import language.runtime.Interpreter$;
import language.runtime.runners.PredicateRunner$;
import language.struct.DynamicValue;
import language.struct.EnvObject;
import language.struct.ScopedVariableLUT;
import language.struct.Taxonomy;
import language.struct.WalkControl;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.sys.package$;
import scala.util.control.Breaks$;
import scala.util.parsing.input.Positional;

public final class ObjectPropertyRunner$ {
    public static ObjectPropertyRunner$ MODULE$;

    static {
        new ObjectPropertyRunner$();
    }

    public void populateRunnableProperties(EnvObject objTreeRoot, Map<String, ClassDef> classDefsLUT, Taxonomy taxonomy, Interpreter fauxInterpreter) {
        Set<EnvObject> allObjects = PredicateRunner$.MODULE$.collectObjects(objTreeRoot);
        allObjects.foreach((Function1<EnvObject, Object> & Serializable & scala.Serializable)obj -> {
            Breaks$.MODULE$.breakable((JFunction0$mcV$sp & scala.Serializable)() -> {
                String objType = obj.getType();
                if (!classDefsLUT$1.contains(objType)) {
                    String string = objType;
                    String string2 = Interpreter$.MODULE$.DEFAULT_ROOT_OBJECT_NAME();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw Breaks$.MODULE$.break();
                    }
                    String string3 = objType;
                    String string4 = "Any";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        throw Breaks$.MODULE$.break();
                    }
                    Predef$.MODULE$.println(new StringBuilder(77).append("ERROR: Found object of type (").append(objType).append("), but there is no class definition for type (").append(objType).append(")\n").toString());
                    Predef$.MODULE$.println(obj.toString());
                    throw package$.MODULE$.exit(1);
                }
                ClassDef classDef = (ClassDef)classDefsLUT$1.apply(objType);
                List<PropertyFunction> propFunctions = classDef.propertyFunctions();
                propFunctions.foreach((Function1<PropertyFunction, Tuple2> & Serializable & scala.Serializable)propFunction -> ObjectPropertyRunner$.MODULE$.runPropertyFunction(obj, (PropertyFunction)propFunction, fauxInterpreter$1, objTreeRoot$1, classDefsLUT$1));
            });
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<Object, String> runPropertyFunction(EnvObject obj, PropertyFunction propFunction, Interpreter fauxInterpreter, EnvObject objTreeRoot, Map<String, ClassDef> classDefLUT) {
        String className = obj.getType();
        if (!classDefLUT.contains(className)) {
            return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(false), new StringBuilder(57).append("ERROR: Unable to find class (").append(className).append(") specified in object type.\n").append(obj.toString()).toString());
        }
        ClassDef classDef = (ClassDef)classDefLUT.apply(className);
        String propName = propFunction.propName();
        List<Statement> codeblock = propFunction.codeblock();
        fauxInterpreter.setRunPropertyFunctions(propFunction.calculateAtRuntime());
        fauxInterpreter.setObjectTreeRoot(objTreeRoot);
        ScopedVariableLUT propFunctVarLUT = new ScopedVariableLUT();
        propFunctVarLUT.set("this", new DynamicValue(obj));
        fauxInterpreter.setVariableLUT(propFunctVarLUT);
        WalkControl result = fauxInterpreter.walkOneStep(codeblock);
        if (result.failed()) {
            Predef$.MODULE$.println(new StringBuilder(108).append("Interpreter exited with error while running property function (").append(propName).append(") for object type (").append(className).append(") on the specific object:\n").append(obj.toString()).toString());
            throw package$.MODULE$.exit(1);
        }
        fauxInterpreter.setRunPropertyFunctions(false);
        if (!result.hasReturnValue()) {
            Predef$.MODULE$.println(new StringBuilder(96).append("ERROR: Property function (").append(propName).append(") for object type (").append(className).append(") does not appear to have generated a return value.").toString());
            if (!codeblock.isEmpty()) {
                Predef$.MODULE$.println(new StringBuilder(15).append("Around line ").append(((Positional)codeblock.last()).pos().line()).append(":\n ").append(((Positional)codeblock.last()).pos().longString()).toString());
            } else {
                Predef$.MODULE$.println(new StringBuilder(12).append("Around line ").append(classDef.pos()).toString());
            }
            throw package$.MODULE$.exit(1);
        }
        obj.setProperty(propName, result.returnValue().get());
        return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(true), "");
    }

    public Map<String, ClassDef> mkClassDefLUT(Option<List<ClassDef>> in) {
        scala.collection.mutable.Map out = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        if (in.isEmpty()) {
            return out.toMap(Predef$.MODULE$.$conforms());
        }
        in.get().foreach((Function1<ClassDef, Object> & Serializable & scala.Serializable)classDef -> {
            out.update(classDef.name(), classDef);
            return BoxedUnit.UNIT;
        });
        return out.toMap(Predef$.MODULE$.$conforms());
    }

    private ObjectPropertyRunner$() {
        MODULE$ = this;
    }
}

