import sqlite3

# List of titles to keep
with open('data/titles_to_keep.txt', 'r') as fp:
    titles_to_keep = fp.readlines()
titles_to_keep = [t.strip() for t in titles_to_keep]

# Convert the list to a tuple for the SQL query
titles_tuple = tuple(titles_to_keep)

# Connect to the SQLite3 database
conn = sqlite3.connect('/Users/cherian/Projects/FActscore/factscore/.cache/factscore/enwiki-20230401-shrunk.db')
cursor = conn.cursor()

# Create a new table for the documents you want to keep
cursor.execute("CREATE TABLE IF NOT EXISTS documents_to_keep AS SELECT * FROM documents WHERE 1=0")

# Insert the documents you want to keep into the new table
cursor.execute(f"""
INSERT INTO documents_to_keep
SELECT * FROM documents
WHERE title IN ({','.join('?' for _ in titles_tuple)})
""", titles_tuple)

# Commit the changes
conn.commit()

# Drop the old table
cursor.execute("DROP TABLE documents")

# Rename the new table to the old table name
cursor.execute("ALTER TABLE documents_to_keep RENAME TO documents")

# Commit the changes and close the connection
conn.commit()

import IPython; IPython.embed()
conn.close()

print("Deletion complete.")
