# GovSim: Governance of the Commons Simulation

This repository is the official implementation of Cooperate or Collapse: Emergence of Sustainability in a Society of LLM Agents. 


## Requirements

To install requirements:

```setup
bash ./setup.sh
```


## Simulation

Each experiment is defined by hydra configuration. To run an experiment, use 
`python3 -m generative_agents.main experiment=<scenario_name>_<experiment_name>`.
For example, to run the experiment `fish_baseline_concurrent` , use
`python3 -m generative_agents.main experiment=fish_baseline_concurrent`. See below for the list of experiments and their ids.

```
python3 -m generative_agents.main experiment=<experiment_id> llm.path=<path_to_llm>
```

### Table of experiments ids
| Experiment in the paper      | Fishing Pond  | Sheep Grazing Pasture | River Pollution | 
| ------------------------------------ |---------------- |-------------------- | -------------- |
| Default setting   |     fish_baseline_concurrent         |      sheep_baseline_concurrent       | pollution_baseline_concurrent |
| Introuducing universalization | fish_baseline_concurrent_universalization | sheep_baseline_concurrent_universalization | pollution_baseline_concurrent_universalization |
| Ablation: no language | fish_perturbation_no_language | sheep_perturbation_no_language | pollution_perturbation_no_language |
| Greedy newcomer | fish_perturbation_outsider | - | - |

## Subskills

To run the subskill evaluation, use the following command:

```
python3 -m llm_subskills_check.<scenario_name> llm.path=<path_to_llm>
```