import pandas as pd
from pprint import pprint

import openai_api

ori = pd.read_csv('../data/event_blocks.csv')
q_map = ori[['question_category', 'question_text', 'question_id']]

#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_type4_prompt-2.csv')
#data = pd.read_csv('../results/predictions_claude1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_text-davinci-001_gpt-3.5-turbo-1106_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_text-davinci-001_gpt-3.5-turbo-1106_type4_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_text-davinci-001_gpt-3.5-turbo-1106_type5_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_text-davinci-001_gpt-3.5-turbo-1106_type7_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_text-davinci-001_gpt-3.5-turbo-1106_type8_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_type8_text-davinci-001_gpt-3.5-turbo-1106_type7_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-3.5-turbo-1106_type7_text-davinci-001_gpt-3.5-turbo-1106_type8_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-4-1106-preview_text-davinci-001_gpt-4-1106-preview_prompt-1.csv')
#data = pd.read_csv('../results/predictions_gpt-4-1106-preview_text-babbage-001_gpt-4-1106-preview_prompt-1.csv')
data = pd.read_csv('../results/predictions_gpt-4-1106-preview_davinci_gpt-4-1106-preview_prompt-1.csv')
print(data.columns)
input()

prompt = 'Please summarize the above explanations about why they give high scores on fluency metric:'

free_texts = data['helpfulness_freetext'].tolist()
free_texts = '\n'.join(free_texts)

prompt = '\n'.join([free_texts, prompt])
messages = [{'role': 'user', 'content': prompt}]

print(messages[0]['content'])

prediction = openai_api.call_chat(messages, max_tokens=500)
print('outputs:', prediction)
print('fluency:', data['fluency'].mean())
print('helpfulness:', data['helpfulness'].mean())
print()

#data = pd.read_csv('../data/survey_responses.csv')
#data = data.groupby(by='model')
#for name, group in data:
#
#    prompt = 'Please summarize the following explanations:'
#    
#    free_texts = group['helpfulness_freetext'].tolist()
#    free_texts = '\n'.join(free_texts)
#    
#    prompt = '\n'.join([prompt, free_texts])
#    messages = [{'role': 'user', 'content': prompt}]
#    
#    prediction = openai_api.call_chat(messages)
#    print(name, ':', prediction)
#    print('fluency:', group['fluency'].mean())
#    print('helpfulness:', group['helpfulness'].mean())
#    print()
#
