import numpy as np
from scipy.integrate import quad, dblquad


#x_upper_limit = np.inf
#y_upper_limit = np.inf


y_upper_limit = 10000
x_upper_limit = 10000


def calculate_ET_srv(Lambda, T):
    def f(x):
        return np.exp(-x)

    def pT(x):
        return 1 - np.exp(-T/x) if x != 0 else 1

    def g(x, y):
        return np.exp((-x - y)/x)  if x != 0 else 0

    # function for rho''_q
    def rho_prime_prime(q_value):
        def integrand_rho_q_1_adjusted(x):
            return pT(x) * x * f(x)

        def integrand_rho_q_2_adjusted(x, y):
            return (1 - pT(x)) * x * g(x, y)

        rho_q_1_adjusted, _ = quad(integrand_rho_q_1_adjusted, 0.001, x_upper_limit, limit=1000)
        rho_q_2_adjusted, _ = dblquad(integrand_rho_q_2_adjusted, 0.001, q_value, lambda x: 0.001, lambda x: x_upper_limit)
        return Lambda * (rho_q_1_adjusted + rho_q_2_adjusted)

    # function for E[T(x, y)]_ext^PL
    def ET_ext_PL(x, y):
        rho_q = rho_prime_prime(y)
        integral_1, _ = quad(lambda x: pT(x) * x**2 * f(x), 0.001, x_upper_limit, limit=1000)
        integral_2, _ = dblquad(lambda x, y: (1 - pT(x)) * x**2 * g(x, y), 0.001, y, lambda x: 0.001, lambda x: x_upper_limit)
        integral_3, _ = dblquad(lambda x, t: (1 - pT(x)) * g(x, t) * (x - (t - y))**2, y,y_upper_limit, lambda t: t - y, lambda t: x_upper_limit)
        integral_last_part, _ = quad(lambda a: 1 / (1 - rho_prime_prime(max(0, y - a))), 0.001, x, limit=1000)
        return (Lambda / (2 * (1 - rho_q)**2)) * (integral_1 + integral_2 + integral_3) + integral_last_part

    # Calculating E[T_srv]
    #E_T_srv, _ = dblquad(lambda x, y: g(x, y) * ET_ext_PL(x, y), 0.001, np.inf, lambda x: 0.001, lambda x: np.inf)
    #E_T_srv = ET_ext_PL(1.2, 1.8)


    E_T_srv, _ = dblquad(lambda x, y: g(x, y) * ET_ext_PL(x, y), 0.1, 1, lambda x: 0.1, lambda x: 1)

    print(E_T_srv)
    return E_T_srv

def save_results_to_file(Lambda, T, E_T_srv, filename="ET_srv_results_to1.txt"):
    with open(filename, "w") as file:
        file.write(f"Lambda: {Lambda}\n")
        file.write(f"T: {T}\n")
        file.write(f"E[T_srv]: {E_T_srv}\n")


Lambda = 0.5
T = 3

E_T_srv = calculate_ET_srv(Lambda, T)
save_results_to_file(Lambda, T, E_T_srv)