import simpy
import random

ARRIVAL_RATE = 5
SERVICE_RATE = 7
T = 10
response_times = []

CHEAP_PREDICTION_PRIORITY = 0
REAL_SHORT_JOB_PRIORITY = 1
EXPENSIVE_PREDICTION_PRIORITY = 2
REAL_LONG_JOB_PRIORITY = 3

def S1():
    #TODO: distribution of cheap predictions
    return 0.1

def S2():
    #TODO: distribution of expensive predictions
    return 0.1

def predict_service_time(j):
    #TODO: simulated predictor
    return j*0.5

def cheap_prediction(env, server, j):
    with server.request(priority=CHEAP_PREDICTION_PRIORITY) as req:
        yield req
        prediction_time = S1()
        yield env.timeout(prediction_time)
        predicted_service_time = predict_service_time(j)

        if predicted_service_time > T:
            env.process(expensive_prediction(env, server, j))
            env.process(real_long_job(env, server, j))
        else:
            env.process(real_short_job(env, server, j))

def expensive_prediction(env, server, j):
    with server.request(priority=EXPENSIVE_PREDICTION_PRIORITY) as req:
        yield req
        service_time = S2()
        yield env.timeout(service_time)

def real_short_job(env, server, j):
    with server.request(priority=REAL_SHORT_JOB_PRIORITY) as req:
        yield req
        waiting_time = random.expovariate(SERVICE_RATE) #replace with expected waiting time for a job
        yield env.timeout(waiting_time)

        response_time = env.now - j
        response_times.append(response_time)

def real_long_job(env, server, j):
    with server.request(priority=REAL_LONG_JOB_PRIORITY) as req:
        yield req
        waiting_time = random.expovariate(SERVICE_RATE) #replace with expected waiting time for a job
        yield env.timeout(waiting_time)

        response_time = env.now - j
        response_times.append(response_time)


def job_generator(env, server):
    while True:
        yield env.timeout(random.expovariate(ARRIVAL_RATE))  # waiting time between arrivals
        j = env.now
        env.process(cheap_prediction(env, server, j))

env = simpy.Environment()
server = simpy.PriorityResource(env, capacity=1)  # single server with priority
env.process(job_generator(env, server))

SIMULATION_TIME = 50
env.run(until=SIMULATION_TIME)

mean_response_time = sum(response_times) / len(response_times)
print(f"\nMean Response Time: {mean_response_time:.2f} time units")
