## Non-asymptotic Approximation Error Bounds of Parameterized Quantum Circuits

This repository is the official implementation of [https://arxiv.org/abs/2310.07528]().

#### Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

#### Training

To train the localization model in the paper, run this command: (We set $K=2$ in this context. You can also set other values of $K$.)

```train
python localization.py
```

To train the Taylor expansion model in the paper, run this command:

```
python main.py
```

Note that there two training procedure have a fixed order. You must first train a localization model. And the trained localization model should be a part of the Taylor expansion model. Btw, the parameters in the localization model will no change during the training of the Taylor expansion model.

#### Evaluation

To evaluate my model, run:

```eval
python plot_pqc_K2.py
python plot_pqc_K5.py
python plot_pqc_K10.py
```

The target function and the pqc outputs are shown in the PNG files.

#### Results

Our model achieves the following performance:

![1716383286052](image/README/1716383286052.png)
