
import json
import os
import sys
import time
import argparse

parser = argparse.ArgumentParser()
parser.add_argument(
    "--dataset",
    type=str,
    default='nsd',
)

parser.add_argument(
    "--subject",
    type=str,
    default='subj01',
)

parser.add_argument(
    "--model",
    type=str,
    default='',
)

args = parser.parse_args()


def main():
    root_dir = f'/mnt/NSD_dataset/datasets/{args.dataset}/results/{args.subject}/llava_captions/{args.model}'
    merged = []
    for i in range(8):
        fname = f'{root_dir}_slice_{i}.json'
        with open(fname, 'r') as f:
            data = json.load(f)
            # print(data)
            merged.extend(data)

    with open(f'{root_dir}.json', 'w') as f:
        json.dump(merged, f, indent=4)


if __name__ == '__main__':
    main()
