#!/bin/bash

deepspeed llava/train/train_mem.py \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path meta-llama/Meta-Llama-3-8B-Instruct \
    --version v1 \
    --data_path /mnt/NSD_dataset/datasets/nsd/sft_data/all/sft_all_tr.json \
    --val_data_path /mnt/NSD_dataset/datasets/nsd/sft_data/all/sft_all_te.json \
    --vision_tower path/to/vision_tower \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --mm_vision_patch_size 14 \
    --requires_vision_embeds False \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --bf16 True \
    --output_dir ./checkpoints/brain-llava-adapter-vit3d-all-nsdgeneral-v1.5-13b \
    --num_train_epochs 1 \
    --per_device_train_batch_size 24 \
    --per_device_eval_batch_size 16 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "steps" \
    --save_strategy "steps" \
    --save_steps 1000 \
    --save_total_limit 1 \
    --learning_rate 2e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 25 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 8 \
    --do_eval True \
    --load_best_model_at_end True \
    --eval_steps 1000 \
    --report_to wandb \
    --lazy_preprocess True \
    --pretrain_mm_mlp_adapter path/to/mm_projector.bin

