import torch


def quantization_matrix(qf=10):
    """
    Quantization coefficients directly from torchjpeg.
    The default pip repo depends on older versions of torch and torchvision, so we decide not to include this dependency.
    """
    if qf == 1:
        q1 = torch.tensor(
            [
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 1:
        q1 = torch.tensor(
            [
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 2:
        q1 = torch.tensor(
            [
                [255.0, 255.0, 250.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 3:
        q1 = torch.tensor(
            [
                [255.0, 183.0, 167.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [200.0, 200.0, 233.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [233.0, 217.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [233.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 4:
        q1 = torch.tensor(
            [
                [200.0, 138.0, 125.0, 200.0, 255.0, 255.0, 255.0, 255.0],
                [150.0, 150.0, 175.0, 238.0, 255.0, 255.0, 255.0, 255.0],
                [175.0, 163.0, 200.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [175.0, 213.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [225.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [213.0, 225.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [225.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 5:
        q1 = torch.tensor(
            [
                [160.0, 110.0, 100.0, 160.0, 240.0, 255.0, 255.0, 255.0],
                [120.0, 120.0, 140.0, 190.0, 255.0, 255.0, 255.0, 255.0],
                [140.0, 130.0, 160.0, 240.0, 255.0, 255.0, 255.0, 255.0],
                [140.0, 170.0, 220.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [180.0, 220.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [240.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [170.0, 180.0, 240.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [180.0, 210.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [240.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 6:
        q1 = torch.tensor(
            [
                [133.0, 92.0, 83.0, 133.0, 200.0, 255.0, 255.0, 255.0],
                [100.0, 100.0, 117.0, 158.0, 217.0, 255.0, 255.0, 255.0],
                [117.0, 108.0, 133.0, 200.0, 255.0, 255.0, 255.0, 255.0],
                [117.0, 142.0, 183.0, 242.0, 255.0, 255.0, 255.0, 255.0],
                [150.0, 183.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [200.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [142.0, 150.0, 200.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [150.0, 175.0, 217.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [200.0, 217.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 7:
        q1 = torch.tensor(
            [
                [114.0, 79.0, 71.0, 114.0, 171.0, 255.0, 255.0, 255.0],
                [86.0, 86.0, 100.0, 136.0, 186.0, 255.0, 255.0, 255.0],
                [100.0, 93.0, 114.0, 171.0, 255.0, 255.0, 255.0, 255.0],
                [100.0, 121.0, 157.0, 207.0, 255.0, 255.0, 255.0, 255.0],
                [129.0, 157.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [171.0, 250.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [121.0, 129.0, 171.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [129.0, 150.0, 186.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [171.0, 186.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 8:
        q1 = torch.tensor(
            [
                [100.0, 69.0, 63.0, 100.0, 150.0, 250.0, 255.0, 255.0],
                [75.0, 75.0, 88.0, 119.0, 163.0, 255.0, 255.0, 255.0],
                [88.0, 81.0, 100.0, 150.0, 250.0, 255.0, 255.0, 255.0],
                [88.0, 106.0, 138.0, 181.0, 255.0, 255.0, 255.0, 255.0],
                [113.0, 138.0, 231.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [150.0, 219.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [106.0, 113.0, 150.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [113.0, 131.0, 163.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [150.0, 163.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 9:
        q1 = torch.tensor(
            [
                [89.0, 61.0, 56.0, 89.0, 133.0, 222.0, 255.0, 255.0],
                [67.0, 67.0, 78.0, 105.0, 144.0, 255.0, 255.0, 255.0],
                [78.0, 72.0, 89.0, 133.0, 222.0, 255.0, 255.0, 255.0],
                [78.0, 94.0, 122.0, 161.0, 255.0, 255.0, 255.0, 255.0],
                [100.0, 122.0, 205.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [133.0, 194.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [94.0, 100.0, 133.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [100.0, 117.0, 144.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [133.0, 144.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 10:
        q1 = torch.tensor(
            [
                [80.0, 55.0, 50.0, 80.0, 120.0, 200.0, 255.0, 255.0],
                [60.0, 60.0, 70.0, 95.0, 130.0, 255.0, 255.0, 255.0],
                [70.0, 65.0, 80.0, 120.0, 200.0, 255.0, 255.0, 255.0],
                [70.0, 85.0, 110.0, 145.0, 255.0, 255.0, 255.0, 255.0],
                [90.0, 110.0, 185.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [120.0, 175.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [245.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [85.0, 90.0, 120.0, 235.0, 255.0, 255.0, 255.0, 255.0],
                [90.0, 105.0, 130.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [120.0, 130.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [235.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 11:
        q1 = torch.tensor(
            [
                [73.0, 50.0, 45.0, 73.0, 109.0, 182.0, 232.0, 255.0],
                [54.0, 54.0, 64.0, 86.0, 118.0, 255.0, 255.0, 250.0],
                [64.0, 59.0, 73.0, 109.0, 182.0, 255.0, 255.0, 254.0],
                [64.0, 77.0, 100.0, 132.0, 232.0, 255.0, 255.0, 255.0],
                [82.0, 100.0, 168.0, 254.0, 255.0, 255.0, 255.0, 255.0],
                [109.0, 159.0, 250.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [222.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [77.0, 82.0, 109.0, 213.0, 255.0, 255.0, 255.0, 255.0],
                [82.0, 95.0, 118.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [109.0, 118.0, 254.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [213.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 12:
        q1 = torch.tensor(
            [
                [67.0, 46.0, 42.0, 67.0, 100.0, 166.0, 212.0, 254.0],
                [50.0, 50.0, 58.0, 79.0, 108.0, 241.0, 250.0, 229.0],
                [58.0, 54.0, 67.0, 100.0, 166.0, 237.0, 255.0, 233.0],
                [58.0, 71.0, 92.0, 121.0, 212.0, 255.0, 255.0, 255.0],
                [75.0, 92.0, 154.0, 233.0, 255.0, 255.0, 255.0, 255.0],
                [100.0, 146.0, 229.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [204.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [71.0, 75.0, 100.0, 196.0, 255.0, 255.0, 255.0, 255.0],
                [75.0, 87.0, 108.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [100.0, 108.0, 233.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [196.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 13:
        q1 = torch.tensor(
            [
                [61.0, 42.0, 38.0, 61.0, 92.0, 154.0, 196.0, 234.0],
                [46.0, 46.0, 54.0, 73.0, 100.0, 223.0, 230.0, 211.0],
                [54.0, 50.0, 61.0, 92.0, 154.0, 219.0, 255.0, 215.0],
                [54.0, 65.0, 84.0, 111.0, 196.0, 255.0, 255.0, 238.0],
                [69.0, 84.0, 142.0, 215.0, 255.0, 255.0, 255.0, 255.0],
                [92.0, 134.0, 211.0, 246.0, 255.0, 255.0, 255.0, 255.0],
                [188.0, 246.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [65.0, 69.0, 92.0, 180.0, 255.0, 255.0, 255.0, 255.0],
                [69.0, 81.0, 100.0, 253.0, 255.0, 255.0, 255.0, 255.0],
                [92.0, 100.0, 215.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [180.0, 253.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 14:
        q1 = torch.tensor(
            [
                [57.0, 39.0, 36.0, 57.0, 86.0, 143.0, 182.0, 218.0],
                [43.0, 43.0, 50.0, 68.0, 93.0, 207.0, 214.0, 196.0],
                [50.0, 46.0, 57.0, 86.0, 143.0, 203.0, 246.0, 200.0],
                [50.0, 61.0, 79.0, 104.0, 182.0, 255.0, 255.0, 221.0],
                [64.0, 79.0, 132.0, 200.0, 243.0, 255.0, 255.0, 255.0],
                [86.0, 125.0, 196.0, 228.0, 255.0, 255.0, 255.0, 255.0],
                [175.0, 228.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [61.0, 64.0, 86.0, 168.0, 255.0, 255.0, 255.0, 255.0],
                [64.0, 75.0, 93.0, 236.0, 255.0, 255.0, 255.0, 255.0],
                [86.0, 93.0, 200.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [168.0, 236.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 15:
        q1 = torch.tensor(
            [
                [53.0, 37.0, 33.0, 53.0, 80.0, 133.0, 170.0, 203.0],
                [40.0, 40.0, 47.0, 63.0, 87.0, 193.0, 200.0, 183.0],
                [47.0, 43.0, 53.0, 80.0, 133.0, 190.0, 230.0, 186.0],
                [47.0, 57.0, 73.0, 97.0, 170.0, 255.0, 255.0, 206.0],
                [60.0, 73.0, 123.0, 186.0, 226.0, 255.0, 255.0, 255.0],
                [80.0, 117.0, 183.0, 213.0, 255.0, 255.0, 255.0, 255.0],
                [163.0, 213.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [240.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [57.0, 60.0, 80.0, 157.0, 255.0, 255.0, 255.0, 255.0],
                [60.0, 70.0, 87.0, 220.0, 255.0, 255.0, 255.0, 255.0],
                [80.0, 87.0, 186.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [157.0, 220.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 16:
        q1 = torch.tensor(
            [
                [50.0, 34.0, 31.0, 50.0, 75.0, 125.0, 159.0, 190.0],
                [37.0, 37.0, 44.0, 59.0, 81.0, 181.0, 187.0, 172.0],
                [44.0, 41.0, 50.0, 75.0, 125.0, 178.0, 215.0, 175.0],
                [44.0, 53.0, 69.0, 90.0, 159.0, 255.0, 250.0, 193.0],
                [56.0, 69.0, 115.0, 175.0, 212.0, 255.0, 255.0, 240.0],
                [75.0, 109.0, 172.0, 200.0, 253.0, 255.0, 255.0, 255.0],
                [153.0, 200.0, 243.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [225.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [53.0, 56.0, 75.0, 147.0, 255.0, 255.0, 255.0, 255.0],
                [56.0, 66.0, 81.0, 206.0, 255.0, 255.0, 255.0, 255.0],
                [75.0, 81.0, 175.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [147.0, 206.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 17:
        q1 = torch.tensor(
            [
                [47.0, 32.0, 29.0, 47.0, 71.0, 118.0, 150.0, 179.0],
                [35.0, 35.0, 41.0, 56.0, 76.0, 171.0, 176.0, 162.0],
                [41.0, 38.0, 47.0, 71.0, 118.0, 168.0, 203.0, 165.0],
                [41.0, 50.0, 65.0, 85.0, 150.0, 255.0, 235.0, 182.0],
                [53.0, 65.0, 109.0, 165.0, 200.0, 255.0, 255.0, 226.0],
                [71.0, 103.0, 162.0, 188.0, 238.0, 255.0, 255.0, 255.0],
                [144.0, 188.0, 229.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [212.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [50.0, 53.0, 71.0, 138.0, 255.0, 255.0, 255.0, 255.0],
                [53.0, 62.0, 76.0, 194.0, 255.0, 255.0, 255.0, 255.0],
                [71.0, 76.0, 165.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [138.0, 194.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 18:
        q1 = torch.tensor(
            [
                [44.0, 30.0, 28.0, 44.0, 66.0, 111.0, 141.0, 169.0],
                [33.0, 33.0, 39.0, 53.0, 72.0, 161.0, 166.0, 152.0],
                [39.0, 36.0, 44.0, 66.0, 111.0, 158.0, 191.0, 155.0],
                [39.0, 47.0, 61.0, 80.0, 141.0, 241.0, 222.0, 172.0],
                [50.0, 61.0, 102.0, 155.0, 188.0, 255.0, 255.0, 213.0],
                [66.0, 97.0, 152.0, 177.0, 224.0, 255.0, 255.0, 255.0],
                [136.0, 177.0, 216.0, 241.0, 255.0, 255.0, 255.0, 255.0],
                [199.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [47.0, 50.0, 66.0, 130.0, 255.0, 255.0, 255.0, 255.0],
                [50.0, 58.0, 72.0, 183.0, 255.0, 255.0, 255.0, 255.0],
                [66.0, 72.0, 155.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [130.0, 183.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 19:
        q1 = torch.tensor(
            [
                [42.0, 29.0, 26.0, 42.0, 63.0, 105.0, 134.0, 160.0],
                [32.0, 32.0, 37.0, 50.0, 68.0, 153.0, 158.0, 145.0],
                [37.0, 34.0, 42.0, 63.0, 105.0, 150.0, 181.0, 147.0],
                [37.0, 45.0, 58.0, 76.0, 134.0, 229.0, 210.0, 163.0],
                [47.0, 58.0, 97.0, 147.0, 179.0, 255.0, 255.0, 203.0],
                [63.0, 92.0, 145.0, 168.0, 213.0, 255.0, 255.0, 242.0],
                [129.0, 168.0, 205.0, 229.0, 255.0, 255.0, 255.0, 255.0],
                [189.0, 242.0, 250.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
        q2 = torch.tensor(
            [
                [45.0, 47.0, 63.0, 124.0, 255.0, 255.0, 255.0, 255.0],
                [47.0, 55.0, 68.0, 174.0, 255.0, 255.0, 255.0, 255.0],
                [63.0, 68.0, 147.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [124.0, 174.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ]
        )
    elif qf == 20:
        q1 = torch.tensor(
            [
                [40.0, 28.0, 25.0, 40.0, 60.0, 100.0, 128.0, 153.0],
                [30.0, 30.0, 35.0, 48.0, 65.0, 145.0, 150.0, 138.0],
                [35.0, 33.0, 40.0, 60.0, 100.0, 143.0, 173.0, 140.0],
                [35.0, 43.0, 55.0, 73.0, 128.0, 218.0, 200.0, 155.0],
                [45.0, 55.0, 93.0, 140.0, 170.0, 255.0, 255.0, 193.0],
                [60.0, 88.0, 138.0, 160.0, 203.0, 255.0, 255.0, 230.0],
                [123.0, 160.0, 195.0, 218.0, 255.0, 255.0, 255.0, 253.0],
                [180.0, 230.0, 238.0, 245.0, 255.0, 250.0, 255.0, 248.0],
            ]
        )
        q2 = torch.tensor(
            [
                [43.0, 45.0, 60.0, 118.0, 248.0, 248.0, 248.0, 248.0],
                [45.0, 53.0, 65.0, 165.0, 248.0, 248.0, 248.0, 248.0],
                [60.0, 65.0, 140.0, 248.0, 248.0, 248.0, 248.0, 248.0],
                [118.0, 165.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0],
                [248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0],
                [248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0],
                [248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0],
                [248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0, 248.0],
            ]
        )
    elif qf == 21:
        q1 = torch.tensor(
            [
                [38.0, 26.0, 24.0, 38.0, 57.0, 95.0, 121.0, 145.0],
                [29.0, 29.0, 33.0, 45.0, 62.0, 138.0, 143.0, 131.0],
                [33.0, 31.0, 38.0, 57.0, 95.0, 136.0, 164.0, 133.0],
                [33.0, 40.0, 52.0, 69.0, 121.0, 207.0, 190.0, 148.0],
                [43.0, 52.0, 88.0, 133.0, 162.0, 255.0, 245.0, 183.0],
                [57.0, 83.0, 131.0, 152.0, 193.0, 248.0, 255.0, 219.0],
                [117.0, 152.0, 186.0, 207.0, 245.0, 255.0, 255.0, 240.0],
                [171.0, 219.0, 226.0, 233.0, 255.0, 238.0, 245.0, 236.0],
            ]
        )
        q2 = torch.tensor(
            [
                [40.0, 43.0, 57.0, 112.0, 236.0, 236.0, 236.0, 236.0],
                [43.0, 50.0, 62.0, 157.0, 236.0, 236.0, 236.0, 236.0],
                [57.0, 62.0, 133.0, 236.0, 236.0, 236.0, 236.0, 236.0],
                [112.0, 157.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0],
                [236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0],
                [236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0],
                [236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0],
                [236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0, 236.0],
            ]
        )
    elif qf == 22:
        q1 = torch.tensor(
            [
                [36.0, 25.0, 23.0, 36.0, 54.0, 91.0, 116.0, 138.0],
                [27.0, 27.0, 32.0, 43.0, 59.0, 132.0, 136.0, 125.0],
                [32.0, 30.0, 36.0, 54.0, 91.0, 129.0, 157.0, 127.0],
                [32.0, 39.0, 50.0, 66.0, 116.0, 197.0, 182.0, 141.0],
                [41.0, 50.0, 84.0, 127.0, 154.0, 247.0, 234.0, 175.0],
                [54.0, 79.0, 125.0, 145.0, 184.0, 236.0, 255.0, 209.0],
                [111.0, 145.0, 177.0, 197.0, 234.0, 255.0, 255.0, 229.0],
                [163.0, 209.0, 216.0, 222.0, 254.0, 227.0, 234.0, 225.0],
            ]
        )
        q2 = torch.tensor(
            [
                [39.0, 41.0, 54.0, 107.0, 225.0, 225.0, 225.0, 225.0],
                [41.0, 48.0, 59.0, 150.0, 225.0, 225.0, 225.0, 225.0],
                [54.0, 59.0, 127.0, 225.0, 225.0, 225.0, 225.0, 225.0],
                [107.0, 150.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0],
                [225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0],
                [225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0],
                [225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0],
                [225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0],
            ]
        )
    elif qf == 23:
        q1 = torch.tensor(
            [
                [35.0, 24.0, 22.0, 35.0, 52.0, 87.0, 111.0, 132.0],
                [26.0, 26.0, 30.0, 41.0, 56.0, 126.0, 130.0, 119.0],
                [30.0, 28.0, 35.0, 52.0, 87.0, 124.0, 150.0, 122.0],
                [30.0, 37.0, 48.0, 63.0, 111.0, 189.0, 174.0, 135.0],
                [39.0, 48.0, 80.0, 122.0, 148.0, 237.0, 224.0, 167.0],
                [52.0, 76.0, 119.0, 139.0, 176.0, 226.0, 245.0, 200.0],
                [106.0, 139.0, 169.0, 189.0, 224.0, 255.0, 255.0, 219.0],
                [156.0, 200.0, 206.0, 213.0, 243.0, 217.0, 224.0, 215.0],
            ]
        )
        q2 = torch.tensor(
            [
                [37.0, 39.0, 52.0, 102.0, 215.0, 215.0, 215.0, 215.0],
                [39.0, 46.0, 56.0, 143.0, 215.0, 215.0, 215.0, 215.0],
                [52.0, 56.0, 122.0, 215.0, 215.0, 215.0, 215.0, 215.0],
                [102.0, 143.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0],
                [215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0],
                [215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0],
                [215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0],
                [215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0, 215.0],
            ]
        )
    elif qf == 24:
        q1 = torch.tensor(
            [
                [33.0, 23.0, 21.0, 33.0, 50.0, 83.0, 106.0, 127.0],
                [25.0, 25.0, 29.0, 40.0, 54.0, 121.0, 125.0, 114.0],
                [29.0, 27.0, 33.0, 50.0, 83.0, 119.0, 144.0, 116.0],
                [29.0, 35.0, 46.0, 60.0, 106.0, 181.0, 166.0, 129.0],
                [37.0, 46.0, 77.0, 116.0, 141.0, 227.0, 214.0, 160.0],
                [50.0, 73.0, 114.0, 133.0, 168.0, 216.0, 235.0, 191.0],
                [102.0, 133.0, 162.0, 181.0, 214.0, 252.0, 250.0, 210.0],
                [150.0, 191.0, 198.0, 204.0, 233.0, 208.0, 214.0, 206.0],
            ]
        )
        q2 = torch.tensor(
            [
                [35.0, 37.0, 50.0, 98.0, 206.0, 206.0, 206.0, 206.0],
                [37.0, 44.0, 54.0, 137.0, 206.0, 206.0, 206.0, 206.0],
                [50.0, 54.0, 116.0, 206.0, 206.0, 206.0, 206.0, 206.0],
                [98.0, 137.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0],
                [206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0],
                [206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0],
                [206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0],
                [206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0],
            ]
        )
    elif qf == 25:
        q1 = torch.tensor(
            [
                [32.0, 22.0, 20.0, 32.0, 48.0, 80.0, 102.0, 122.0],
                [24.0, 24.0, 28.0, 38.0, 52.0, 116.0, 120.0, 110.0],
                [28.0, 26.0, 32.0, 48.0, 80.0, 114.0, 138.0, 112.0],
                [28.0, 34.0, 44.0, 58.0, 102.0, 174.0, 160.0, 124.0],
                [36.0, 44.0, 74.0, 112.0, 136.0, 218.0, 206.0, 154.0],
                [48.0, 70.0, 110.0, 128.0, 162.0, 208.0, 226.0, 184.0],
                [98.0, 128.0, 156.0, 174.0, 206.0, 242.0, 240.0, 202.0],
                [144.0, 184.0, 190.0, 196.0, 224.0, 200.0, 206.0, 198.0],
            ]
        )
        q2 = torch.tensor(
            [
                [34.0, 36.0, 48.0, 94.0, 198.0, 198.0, 198.0, 198.0],
                [36.0, 42.0, 52.0, 132.0, 198.0, 198.0, 198.0, 198.0],
                [48.0, 52.0, 112.0, 198.0, 198.0, 198.0, 198.0, 198.0],
                [94.0, 132.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0],
                [198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0],
                [198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0],
                [198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0],
                [198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0, 198.0],
            ]
        )
    elif qf == 26:
        q1 = torch.tensor(
            [
                [31.0, 21.0, 19.0, 31.0, 46.0, 77.0, 98.0, 117.0],
                [23.0, 23.0, 27.0, 36.0, 50.0, 111.0, 115.0, 106.0],
                [27.0, 25.0, 31.0, 46.0, 77.0, 109.0, 132.0, 108.0],
                [27.0, 33.0, 42.0, 56.0, 98.0, 167.0, 154.0, 119.0],
                [35.0, 42.0, 71.0, 108.0, 131.0, 209.0, 198.0, 148.0],
                [46.0, 67.0, 106.0, 123.0, 156.0, 200.0, 217.0, 177.0],
                [94.0, 123.0, 150.0, 167.0, 198.0, 232.0, 230.0, 194.0],
                [138.0, 177.0, 182.0, 188.0, 215.0, 192.0, 198.0, 190.0],
            ]
        )
        q2 = torch.tensor(
            [
                [33.0, 35.0, 46.0, 90.0, 190.0, 190.0, 190.0, 190.0],
                [35.0, 40.0, 50.0, 127.0, 190.0, 190.0, 190.0, 190.0],
                [46.0, 50.0, 108.0, 190.0, 190.0, 190.0, 190.0, 190.0],
                [90.0, 127.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0],
                [190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0],
                [190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0],
                [190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0],
                [190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0, 190.0],
            ]
        )
    elif qf == 27:
        q1 = torch.tensor(
            [
                [30.0, 20.0, 19.0, 30.0, 44.0, 74.0, 94.0, 113.0],
                [22.0, 22.0, 26.0, 35.0, 48.0, 107.0, 111.0, 102.0],
                [26.0, 24.0, 30.0, 44.0, 74.0, 105.0, 128.0, 104.0],
                [26.0, 31.0, 41.0, 54.0, 94.0, 161.0, 148.0, 115.0],
                [33.0, 41.0, 68.0, 104.0, 126.0, 202.0, 191.0, 142.0],
                [44.0, 65.0, 102.0, 118.0, 150.0, 192.0, 209.0, 170.0],
                [91.0, 118.0, 144.0, 161.0, 191.0, 224.0, 222.0, 187.0],
                [133.0, 170.0, 176.0, 181.0, 207.0, 185.0, 191.0, 183.0],
            ]
        )
        q2 = torch.tensor(
            [
                [31.0, 33.0, 44.0, 87.0, 183.0, 183.0, 183.0, 183.0],
                [33.0, 39.0, 48.0, 122.0, 183.0, 183.0, 183.0, 183.0],
                [44.0, 48.0, 104.0, 183.0, 183.0, 183.0, 183.0, 183.0],
                [87.0, 122.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0],
                [183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0],
                [183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0],
                [183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0],
                [183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0, 183.0],
            ]
        )
    elif qf == 28:
        q1 = torch.tensor(
            [
                [28.0, 20.0, 18.0, 28.0, 43.0, 71.0, 91.0, 109.0],
                [21.0, 21.0, 25.0, 34.0, 46.0, 103.0, 107.0, 98.0],
                [25.0, 23.0, 28.0, 43.0, 71.0, 101.0, 123.0, 100.0],
                [25.0, 30.0, 39.0, 52.0, 91.0, 155.0, 142.0, 110.0],
                [32.0, 39.0, 66.0, 100.0, 121.0, 194.0, 183.0, 137.0],
                [43.0, 62.0, 98.0, 114.0, 144.0, 185.0, 201.0, 164.0],
                [87.0, 114.0, 139.0, 155.0, 183.0, 215.0, 214.0, 180.0],
                [128.0, 164.0, 169.0, 174.0, 199.0, 178.0, 183.0, 176.0],
            ]
        )
        q2 = torch.tensor(
            [
                [30.0, 32.0, 43.0, 84.0, 176.0, 176.0, 176.0, 176.0],
                [32.0, 37.0, 46.0, 117.0, 176.0, 176.0, 176.0, 176.0],
                [43.0, 46.0, 100.0, 176.0, 176.0, 176.0, 176.0, 176.0],
                [84.0, 117.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0],
                [176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0],
                [176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0],
                [176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0],
                [176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0, 176.0],
            ]
        )
    elif qf == 29:
        q1 = torch.tensor(
            [
                [28.0, 19.0, 17.0, 28.0, 41.0, 69.0, 88.0, 105.0],
                [21.0, 21.0, 24.0, 33.0, 45.0, 100.0, 103.0, 95.0],
                [24.0, 22.0, 28.0, 41.0, 69.0, 98.0, 119.0, 96.0],
                [24.0, 29.0, 38.0, 50.0, 88.0, 150.0, 138.0, 107.0],
                [31.0, 38.0, 64.0, 96.0, 117.0, 187.0, 177.0, 132.0],
                [41.0, 60.0, 95.0, 110.0, 139.0, 179.0, 194.0, 158.0],
                [84.0, 110.0, 134.0, 150.0, 177.0, 208.0, 206.0, 174.0],
                [124.0, 158.0, 163.0, 169.0, 193.0, 172.0, 177.0, 170.0],
            ]
        )
        q2 = torch.tensor(
            [
                [29.0, 31.0, 41.0, 81.0, 170.0, 170.0, 170.0, 170.0],
                [31.0, 36.0, 45.0, 114.0, 170.0, 170.0, 170.0, 170.0],
                [41.0, 45.0, 96.0, 170.0, 170.0, 170.0, 170.0, 170.0],
                [81.0, 114.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0],
                [170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0],
                [170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0],
                [170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0],
                [170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0],
            ]
        )
    elif qf == 30:
        q1 = torch.tensor(
            [
                [27.0, 18.0, 17.0, 27.0, 40.0, 66.0, 85.0, 101.0],
                [20.0, 20.0, 23.0, 32.0, 43.0, 96.0, 100.0, 91.0],
                [23.0, 22.0, 27.0, 40.0, 66.0, 95.0, 115.0, 93.0],
                [23.0, 28.0, 37.0, 48.0, 85.0, 144.0, 133.0, 103.0],
                [30.0, 37.0, 61.0, 93.0, 113.0, 181.0, 171.0, 128.0],
                [40.0, 58.0, 91.0, 106.0, 134.0, 173.0, 188.0, 153.0],
                [81.0, 106.0, 129.0, 144.0, 171.0, 201.0, 199.0, 168.0],
                [120.0, 153.0, 158.0, 163.0, 186.0, 166.0, 171.0, 164.0],
            ]
        )
        q2 = torch.tensor(
            [
                [28.0, 30.0, 40.0, 78.0, 164.0, 164.0, 164.0, 164.0],
                [30.0, 35.0, 43.0, 110.0, 164.0, 164.0, 164.0, 164.0],
                [40.0, 43.0, 93.0, 164.0, 164.0, 164.0, 164.0, 164.0],
                [78.0, 110.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0],
                [164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0],
                [164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0],
                [164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0],
                [164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0, 164.0],
            ]
        )
    elif qf == 31:
        q1 = torch.tensor(
            [
                [26.0, 18.0, 16.0, 26.0, 39.0, 64.0, 82.0, 98.0],
                [19.0, 19.0, 23.0, 31.0, 42.0, 93.0, 97.0, 89.0],
                [23.0, 21.0, 26.0, 39.0, 64.0, 92.0, 111.0, 90.0],
                [23.0, 27.0, 35.0, 47.0, 82.0, 140.0, 129.0, 100.0],
                [29.0, 35.0, 60.0, 90.0, 109.0, 175.0, 166.0, 124.0],
                [39.0, 56.0, 89.0, 103.0, 130.0, 167.0, 182.0, 148.0],
                [79.0, 103.0, 126.0, 140.0, 166.0, 195.0, 193.0, 163.0],
                [116.0, 148.0, 153.0, 158.0, 180.0, 161.0, 166.0, 159.0],
            ]
        )
        q2 = torch.tensor(
            [
                [27.0, 29.0, 39.0, 76.0, 159.0, 159.0, 159.0, 159.0],
                [29.0, 34.0, 42.0, 106.0, 159.0, 159.0, 159.0, 159.0],
                [39.0, 42.0, 90.0, 159.0, 159.0, 159.0, 159.0, 159.0],
                [76.0, 106.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0],
                [159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0],
                [159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0],
                [159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0],
                [159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0, 159.0],
            ]
        )
    elif qf == 32:
        q1 = torch.tensor(
            [
                [25.0, 17.0, 16.0, 25.0, 37.0, 62.0, 80.0, 95.0],
                [19.0, 19.0, 22.0, 30.0, 41.0, 90.0, 94.0, 86.0],
                [22.0, 20.0, 25.0, 37.0, 62.0, 89.0, 108.0, 87.0],
                [22.0, 27.0, 34.0, 45.0, 80.0, 136.0, 125.0, 97.0],
                [28.0, 34.0, 58.0, 87.0, 106.0, 170.0, 161.0, 120.0],
                [37.0, 55.0, 86.0, 100.0, 126.0, 162.0, 176.0, 144.0],
                [76.0, 100.0, 122.0, 136.0, 161.0, 189.0, 187.0, 158.0],
                [112.0, 144.0, 148.0, 153.0, 175.0, 156.0, 161.0, 154.0],
            ]
        )
        q2 = torch.tensor(
            [
                [27.0, 28.0, 37.0, 73.0, 154.0, 154.0, 154.0, 154.0],
                [28.0, 33.0, 41.0, 103.0, 154.0, 154.0, 154.0, 154.0],
                [37.0, 41.0, 87.0, 154.0, 154.0, 154.0, 154.0, 154.0],
                [73.0, 103.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0],
                [154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0],
                [154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0],
                [154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0],
                [154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0, 154.0],
            ]
        )
    elif qf == 33:
        q1 = torch.tensor(
            [
                [24.0, 17.0, 15.0, 24.0, 36.0, 60.0, 77.0, 92.0],
                [18.0, 18.0, 21.0, 29.0, 39.0, 88.0, 91.0, 83.0],
                [21.0, 20.0, 24.0, 36.0, 60.0, 86.0, 104.0, 85.0],
                [21.0, 26.0, 33.0, 44.0, 77.0, 131.0, 121.0, 94.0],
                [27.0, 33.0, 56.0, 85.0, 103.0, 165.0, 156.0, 116.0],
                [36.0, 53.0, 83.0, 97.0, 122.0, 157.0, 171.0, 139.0],
                [74.0, 97.0, 118.0, 131.0, 156.0, 183.0, 181.0, 153.0],
                [109.0, 139.0, 143.0, 148.0, 169.0, 151.0, 156.0, 149.0],
            ]
        )
        q2 = torch.tensor(
            [
                [26.0, 27.0, 36.0, 71.0, 149.0, 149.0, 149.0, 149.0],
                [27.0, 32.0, 39.0, 100.0, 149.0, 149.0, 149.0, 149.0],
                [36.0, 39.0, 85.0, 149.0, 149.0, 149.0, 149.0, 149.0],
                [71.0, 100.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0],
                [149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0],
                [149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0],
                [149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0],
                [149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0, 149.0],
            ]
        )
    elif qf == 34:
        q1 = torch.tensor(
            [
                [24.0, 16.0, 15.0, 24.0, 35.0, 59.0, 75.0, 90.0],
                [18.0, 18.0, 21.0, 28.0, 38.0, 85.0, 88.0, 81.0],
                [21.0, 19.0, 24.0, 35.0, 59.0, 84.0, 101.0, 82.0],
                [21.0, 25.0, 32.0, 43.0, 75.0, 128.0, 118.0, 91.0],
                [26.0, 32.0, 54.0, 82.0, 100.0, 160.0, 151.0, 113.0],
                [35.0, 51.0, 81.0, 94.0, 119.0, 153.0, 166.0, 135.0],
                [72.0, 94.0, 115.0, 128.0, 151.0, 178.0, 176.0, 148.0],
                [106.0, 135.0, 140.0, 144.0, 165.0, 147.0, 151.0, 146.0],
            ]
        )
        q2 = torch.tensor(
            [
                [25.0, 26.0, 35.0, 69.0, 146.0, 146.0, 146.0, 146.0],
                [26.0, 31.0, 38.0, 97.0, 146.0, 146.0, 146.0, 146.0],
                [35.0, 38.0, 82.0, 146.0, 146.0, 146.0, 146.0, 146.0],
                [69.0, 97.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0],
                [146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0],
                [146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0],
                [146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0],
                [146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0, 146.0],
            ]
        )
    elif qf == 35:
        q1 = torch.tensor(
            [
                [23.0, 16.0, 14.0, 23.0, 34.0, 57.0, 72.0, 87.0],
                [17.0, 17.0, 20.0, 27.0, 37.0, 82.0, 85.0, 78.0],
                [20.0, 18.0, 23.0, 34.0, 57.0, 81.0, 98.0, 80.0],
                [20.0, 24.0, 31.0, 41.0, 72.0, 124.0, 114.0, 88.0],
                [26.0, 31.0, 53.0, 80.0, 97.0, 155.0, 146.0, 109.0],
                [34.0, 50.0, 78.0, 91.0, 115.0, 148.0, 160.0, 131.0],
                [70.0, 91.0, 111.0, 124.0, 146.0, 172.0, 170.0, 143.0],
                [102.0, 131.0, 135.0, 139.0, 159.0, 142.0, 146.0, 141.0],
            ]
        )
        q2 = torch.tensor(
            [
                [24.0, 26.0, 34.0, 67.0, 141.0, 141.0, 141.0, 141.0],
                [26.0, 30.0, 37.0, 94.0, 141.0, 141.0, 141.0, 141.0],
                [34.0, 37.0, 80.0, 141.0, 141.0, 141.0, 141.0, 141.0],
                [67.0, 94.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0],
                [141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0],
                [141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0],
                [141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0],
                [141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0, 141.0],
            ]
        )
    elif qf == 36:
        q1 = torch.tensor(
            [
                [22.0, 15.0, 14.0, 22.0, 33.0, 55.0, 70.0, 84.0],
                [17.0, 17.0, 19.0, 26.0, 36.0, 80.0, 83.0, 76.0],
                [19.0, 18.0, 22.0, 33.0, 55.0, 79.0, 95.0, 77.0],
                [19.0, 23.0, 30.0, 40.0, 70.0, 120.0, 110.0, 86.0],
                [25.0, 30.0, 51.0, 77.0, 94.0, 150.0, 142.0, 106.0],
                [33.0, 48.0, 76.0, 88.0, 112.0, 144.0, 156.0, 127.0],
                [68.0, 88.0, 108.0, 120.0, 142.0, 167.0, 166.0, 139.0],
                [99.0, 127.0, 131.0, 135.0, 155.0, 138.0, 142.0, 137.0],
            ]
        )
        q2 = torch.tensor(
            [
                [23.0, 25.0, 33.0, 65.0, 137.0, 137.0, 137.0, 137.0],
                [25.0, 29.0, 36.0, 91.0, 137.0, 137.0, 137.0, 137.0],
                [33.0, 36.0, 77.0, 137.0, 137.0, 137.0, 137.0, 137.0],
                [65.0, 91.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0],
                [137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0],
                [137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0],
                [137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0],
                [137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0, 137.0],
            ]
        )
    elif qf == 37:
        q1 = torch.tensor(
            [
                [22.0, 15.0, 14.0, 22.0, 32.0, 54.0, 69.0, 82.0],
                [16.0, 16.0, 19.0, 26.0, 35.0, 78.0, 81.0, 74.0],
                [19.0, 18.0, 22.0, 32.0, 54.0, 77.0, 93.0, 76.0],
                [19.0, 23.0, 30.0, 39.0, 69.0, 117.0, 108.0, 84.0],
                [24.0, 30.0, 50.0, 76.0, 92.0, 147.0, 139.0, 104.0],
                [32.0, 47.0, 74.0, 86.0, 109.0, 140.0, 153.0, 124.0],
                [66.0, 86.0, 105.0, 117.0, 139.0, 163.0, 162.0, 136.0],
                [97.0, 124.0, 128.0, 132.0, 151.0, 135.0, 139.0, 134.0],
            ]
        )
        q2 = torch.tensor(
            [
                [23.0, 24.0, 32.0, 63.0, 134.0, 134.0, 134.0, 134.0],
                [24.0, 28.0, 35.0, 89.0, 134.0, 134.0, 134.0, 134.0],
                [32.0, 35.0, 76.0, 134.0, 134.0, 134.0, 134.0, 134.0],
                [63.0, 89.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0],
                [134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0],
                [134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0],
                [134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0],
                [134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0],
            ]
        )
    elif qf == 38:
        q1 = torch.tensor(
            [
                [21.0, 14.0, 13.0, 21.0, 31.0, 52.0, 67.0, 80.0],
                [16.0, 16.0, 18.0, 25.0, 34.0, 76.0, 79.0, 72.0],
                [18.0, 17.0, 21.0, 31.0, 52.0, 75.0, 90.0, 73.0],
                [18.0, 22.0, 29.0, 38.0, 67.0, 114.0, 105.0, 81.0],
                [24.0, 29.0, 48.0, 73.0, 89.0, 143.0, 135.0, 101.0],
                [31.0, 46.0, 72.0, 84.0, 106.0, 136.0, 148.0, 121.0],
                [64.0, 84.0, 102.0, 114.0, 135.0, 159.0, 157.0, 132.0],
                [94.0, 121.0, 124.0, 128.0, 147.0, 131.0, 135.0, 130.0],
            ]
        )
        q2 = torch.tensor(
            [
                [22.0, 24.0, 31.0, 62.0, 130.0, 130.0, 130.0, 130.0],
                [24.0, 28.0, 34.0, 86.0, 130.0, 130.0, 130.0, 130.0],
                [31.0, 34.0, 73.0, 130.0, 130.0, 130.0, 130.0, 130.0],
                [62.0, 86.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0],
                [130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0],
                [130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0],
                [130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0],
                [130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0, 130.0],
            ]
        )
    elif qf == 39:
        q1 = torch.tensor(
            [
                [20.0, 14.0, 13.0, 20.0, 31.0, 51.0, 65.0, 78.0],
                [15.0, 15.0, 18.0, 24.0, 33.0, 74.0, 77.0, 70.0],
                [18.0, 17.0, 20.0, 31.0, 51.0, 73.0, 88.0, 72.0],
                [18.0, 22.0, 28.0, 37.0, 65.0, 111.0, 102.0, 79.0],
                [23.0, 28.0, 47.0, 72.0, 87.0, 140.0, 132.0, 99.0],
                [31.0, 45.0, 70.0, 82.0, 104.0, 133.0, 145.0, 118.0],
                [63.0, 82.0, 100.0, 111.0, 132.0, 155.0, 154.0, 129.0],
                [92.0, 118.0, 122.0, 125.0, 143.0, 128.0, 132.0, 127.0],
            ]
        )
        q2 = torch.tensor(
            [
                [22.0, 23.0, 31.0, 60.0, 127.0, 127.0, 127.0, 127.0],
                [23.0, 27.0, 33.0, 84.0, 127.0, 127.0, 127.0, 127.0],
                [31.0, 33.0, 72.0, 127.0, 127.0, 127.0, 127.0, 127.0],
                [60.0, 84.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0],
                [127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0],
                [127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0],
                [127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0],
                [127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0],
            ]
        )
    elif qf == 40:
        q1 = torch.tensor(
            [
                [20.0, 14.0, 13.0, 20.0, 30.0, 50.0, 64.0, 76.0],
                [15.0, 15.0, 18.0, 24.0, 33.0, 73.0, 75.0, 69.0],
                [18.0, 16.0, 20.0, 30.0, 50.0, 71.0, 86.0, 70.0],
                [18.0, 21.0, 28.0, 36.0, 64.0, 109.0, 100.0, 78.0],
                [23.0, 28.0, 46.0, 70.0, 85.0, 136.0, 129.0, 96.0],
                [30.0, 44.0, 69.0, 80.0, 101.0, 130.0, 141.0, 115.0],
                [61.0, 80.0, 98.0, 109.0, 129.0, 151.0, 150.0, 126.0],
                [90.0, 115.0, 119.0, 123.0, 140.0, 125.0, 129.0, 124.0],
            ]
        )
        q2 = torch.tensor(
            [
                [21.0, 23.0, 30.0, 59.0, 124.0, 124.0, 124.0, 124.0],
                [23.0, 26.0, 33.0, 83.0, 124.0, 124.0, 124.0, 124.0],
                [30.0, 33.0, 70.0, 124.0, 124.0, 124.0, 124.0, 124.0],
                [59.0, 83.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0],
                [124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0],
                [124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0],
                [124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0],
                [124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0, 124.0],
            ]
        )
    elif qf == 41:
        q1 = torch.tensor(
            [
                [19.0, 13.0, 12.0, 19.0, 29.0, 48.0, 62.0, 74.0],
                [15.0, 15.0, 17.0, 23.0, 31.0, 70.0, 73.0, 67.0],
                [17.0, 16.0, 19.0, 29.0, 48.0, 69.0, 83.0, 68.0],
                [17.0, 21.0, 27.0, 35.0, 62.0, 105.0, 97.0, 75.0],
                [22.0, 27.0, 45.0, 68.0, 82.0, 132.0, 125.0, 93.0],
                [29.0, 42.0, 67.0, 77.0, 98.0, 126.0, 137.0, 111.0],
                [59.0, 77.0, 94.0, 105.0, 125.0, 146.0, 145.0, 122.0],
                [87.0, 111.0, 115.0, 119.0, 136.0, 121.0, 125.0, 120.0],
            ]
        )
        q2 = torch.tensor(
            [
                [21.0, 22.0, 29.0, 57.0, 120.0, 120.0, 120.0, 120.0],
                [22.0, 25.0, 31.0, 80.0, 120.0, 120.0, 120.0, 120.0],
                [29.0, 31.0, 68.0, 120.0, 120.0, 120.0, 120.0, 120.0],
                [57.0, 80.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0],
                [120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0],
                [120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0],
                [120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0],
                [120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0],
            ]
        )
    elif qf == 42:
        q1 = torch.tensor(
            [
                [19.0, 13.0, 12.0, 19.0, 29.0, 48.0, 61.0, 73.0],
                [14.0, 14.0, 17.0, 23.0, 31.0, 69.0, 71.0, 65.0],
                [17.0, 15.0, 19.0, 29.0, 48.0, 68.0, 82.0, 67.0],
                [17.0, 20.0, 26.0, 35.0, 61.0, 104.0, 95.0, 74.0],
                [21.0, 26.0, 44.0, 67.0, 81.0, 130.0, 123.0, 92.0],
                [29.0, 42.0, 65.0, 76.0, 96.0, 124.0, 134.0, 109.0],
                [58.0, 76.0, 93.0, 104.0, 123.0, 144.0, 143.0, 120.0],
                [86.0, 109.0, 113.0, 117.0, 133.0, 119.0, 123.0, 118.0],
            ]
        )
        q2 = torch.tensor(
            [
                [20.0, 21.0, 29.0, 56.0, 118.0, 118.0, 118.0, 118.0],
                [21.0, 25.0, 31.0, 79.0, 118.0, 118.0, 118.0, 118.0],
                [29.0, 31.0, 67.0, 118.0, 118.0, 118.0, 118.0, 118.0],
                [56.0, 79.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0],
                [118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0],
                [118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0],
                [118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0],
                [118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0, 118.0],
            ]
        )
    elif qf == 43:
        q1 = torch.tensor(
            [
                [19.0, 13.0, 12.0, 19.0, 28.0, 46.0, 59.0, 71.0],
                [14.0, 14.0, 16.0, 22.0, 30.0, 67.0, 70.0, 64.0],
                [16.0, 15.0, 19.0, 28.0, 46.0, 66.0, 80.0, 65.0],
                [16.0, 20.0, 26.0, 34.0, 59.0, 101.0, 93.0, 72.0],
                [21.0, 26.0, 43.0, 65.0, 79.0, 126.0, 119.0, 89.0],
                [28.0, 41.0, 64.0, 74.0, 94.0, 121.0, 131.0, 107.0],
                [57.0, 74.0, 90.0, 101.0, 119.0, 140.0, 139.0, 117.0],
                [84.0, 107.0, 110.0, 114.0, 130.0, 116.0, 119.0, 115.0],
            ]
        )
        q2 = torch.tensor(
            [
                [20.0, 21.0, 28.0, 55.0, 115.0, 115.0, 115.0, 115.0],
                [21.0, 24.0, 30.0, 77.0, 115.0, 115.0, 115.0, 115.0],
                [28.0, 30.0, 65.0, 115.0, 115.0, 115.0, 115.0, 115.0],
                [55.0, 77.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0],
                [115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0],
                [115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0],
                [115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0],
                [115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0, 115.0],
            ]
        )
    elif qf == 44:
        q1 = torch.tensor(
            [
                [18.0, 12.0, 11.0, 18.0, 27.0, 45.0, 58.0, 69.0],
                [14.0, 14.0, 16.0, 21.0, 29.0, 66.0, 68.0, 62.0],
                [16.0, 15.0, 18.0, 27.0, 45.0, 64.0, 78.0, 63.0],
                [16.0, 19.0, 25.0, 33.0, 58.0, 98.0, 90.0, 70.0],
                [20.0, 25.0, 42.0, 63.0, 77.0, 123.0, 116.0, 87.0],
                [27.0, 40.0, 62.0, 72.0, 92.0, 118.0, 128.0, 104.0],
                [55.0, 72.0, 88.0, 98.0, 116.0, 137.0, 136.0, 114.0],
                [81.0, 104.0, 107.0, 111.0, 127.0, 113.0, 116.0, 112.0],
            ]
        )
        q2 = torch.tensor(
            [
                [19.0, 20.0, 27.0, 53.0, 112.0, 112.0, 112.0, 112.0],
                [20.0, 24.0, 29.0, 75.0, 112.0, 112.0, 112.0, 112.0],
                [27.0, 29.0, 63.0, 112.0, 112.0, 112.0, 112.0, 112.0],
                [53.0, 75.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0],
                [112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0],
                [112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0],
                [112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0],
                [112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0, 112.0],
            ]
        )
    elif qf == 45:
        q1 = torch.tensor(
            [
                [18.0, 12.0, 11.0, 18.0, 27.0, 44.0, 57.0, 68.0],
                [13.0, 13.0, 16.0, 21.0, 29.0, 64.0, 67.0, 61.0],
                [16.0, 14.0, 18.0, 27.0, 44.0, 63.0, 77.0, 62.0],
                [16.0, 19.0, 24.0, 32.0, 57.0, 97.0, 89.0, 69.0],
                [20.0, 24.0, 41.0, 62.0, 75.0, 121.0, 114.0, 85.0],
                [27.0, 39.0, 61.0, 71.0, 90.0, 115.0, 125.0, 102.0],
                [54.0, 71.0, 87.0, 97.0, 114.0, 134.0, 133.0, 112.0],
                [80.0, 102.0, 105.0, 109.0, 124.0, 111.0, 114.0, 110.0],
            ]
        )
        q2 = torch.tensor(
            [
                [19.0, 20.0, 27.0, 52.0, 110.0, 110.0, 110.0, 110.0],
                [20.0, 23.0, 29.0, 73.0, 110.0, 110.0, 110.0, 110.0],
                [27.0, 29.0, 62.0, 110.0, 110.0, 110.0, 110.0, 110.0],
                [52.0, 73.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0],
                [110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0],
                [110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0],
                [110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0],
                [110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0, 110.0],
            ]
        )
    elif qf == 46:
        q1 = torch.tensor(
            [
                [17.0, 12.0, 11.0, 17.0, 26.0, 43.0, 55.0, 66.0],
                [13.0, 13.0, 15.0, 21.0, 28.0, 63.0, 65.0, 59.0],
                [15.0, 14.0, 17.0, 26.0, 43.0, 62.0, 75.0, 60.0],
                [15.0, 18.0, 24.0, 31.0, 55.0, 94.0, 86.0, 67.0],
                [19.0, 24.0, 40.0, 60.0, 73.0, 118.0, 111.0, 83.0],
                [26.0, 38.0, 59.0, 69.0, 87.0, 112.0, 122.0, 99.0],
                [53.0, 69.0, 84.0, 94.0, 111.0, 131.0, 130.0, 109.0],
                [78.0, 99.0, 103.0, 106.0, 121.0, 108.0, 111.0, 107.0],
            ]
        )
        q2 = torch.tensor(
            [
                [18.0, 19.0, 26.0, 51.0, 107.0, 107.0, 107.0, 107.0],
                [19.0, 23.0, 28.0, 71.0, 107.0, 107.0, 107.0, 107.0],
                [26.0, 28.0, 60.0, 107.0, 107.0, 107.0, 107.0, 107.0],
                [51.0, 71.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0],
                [107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0],
                [107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0],
                [107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0],
                [107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0, 107.0],
            ]
        )
    elif qf == 47:
        q1 = torch.tensor(
            [
                [17.0, 12.0, 11.0, 17.0, 25.0, 42.0, 54.0, 65.0],
                [13.0, 13.0, 15.0, 20.0, 28.0, 61.0, 64.0, 58.0],
                [15.0, 14.0, 17.0, 25.0, 42.0, 60.0, 73.0, 59.0],
                [15.0, 18.0, 23.0, 31.0, 54.0, 92.0, 85.0, 66.0],
                [19.0, 23.0, 39.0, 59.0, 72.0, 116.0, 109.0, 82.0],
                [25.0, 37.0, 58.0, 68.0, 86.0, 110.0, 120.0, 98.0],
                [52.0, 68.0, 83.0, 92.0, 109.0, 128.0, 127.0, 107.0],
                [76.0, 98.0, 101.0, 104.0, 119.0, 106.0, 109.0, 105.0],
            ]
        )
        q2 = torch.tensor(
            [
                [18.0, 19.0, 25.0, 50.0, 105.0, 105.0, 105.0, 105.0],
                [19.0, 22.0, 28.0, 70.0, 105.0, 105.0, 105.0, 105.0],
                [25.0, 28.0, 59.0, 105.0, 105.0, 105.0, 105.0, 105.0],
                [50.0, 70.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0],
                [105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0],
                [105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0],
                [105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0],
                [105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0, 105.0],
            ]
        )
    elif qf == 48:
        q1 = torch.tensor(
            [
                [17.0, 11.0, 10.0, 17.0, 25.0, 42.0, 53.0, 63.0],
                [12.0, 12.0, 15.0, 20.0, 27.0, 60.0, 62.0, 57.0],
                [15.0, 14.0, 17.0, 25.0, 42.0, 59.0, 72.0, 58.0],
                [15.0, 18.0, 23.0, 30.0, 53.0, 90.0, 83.0, 64.0],
                [19.0, 23.0, 38.0, 58.0, 71.0, 113.0, 107.0, 80.0],
                [25.0, 36.0, 57.0, 67.0, 84.0, 108.0, 118.0, 96.0],
                [51.0, 67.0, 81.0, 90.0, 107.0, 126.0, 125.0, 105.0],
                [75.0, 96.0, 99.0, 102.0, 116.0, 104.0, 107.0, 103.0],
            ]
        )
        q2 = torch.tensor(
            [
                [18.0, 19.0, 25.0, 49.0, 103.0, 103.0, 103.0, 103.0],
                [19.0, 22.0, 27.0, 69.0, 103.0, 103.0, 103.0, 103.0],
                [25.0, 27.0, 58.0, 103.0, 103.0, 103.0, 103.0, 103.0],
                [49.0, 69.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0],
                [103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0],
                [103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0],
                [103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0],
                [103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0, 103.0],
            ]
        )
    elif qf == 49:
        q1 = torch.tensor(
            [
                [16.0, 11.0, 10.0, 16.0, 24.0, 41.0, 52.0, 62.0],
                [12.0, 12.0, 14.0, 19.0, 27.0, 59.0, 61.0, 56.0],
                [14.0, 13.0, 16.0, 24.0, 41.0, 58.0, 70.0, 57.0],
                [14.0, 17.0, 22.0, 30.0, 52.0, 89.0, 82.0, 63.0],
                [18.0, 22.0, 38.0, 57.0, 69.0, 111.0, 105.0, 79.0],
                [24.0, 36.0, 56.0, 65.0, 83.0, 106.0, 115.0, 94.0],
                [50.0, 65.0, 80.0, 89.0, 105.0, 123.0, 122.0, 103.0],
                [73.0, 94.0, 97.0, 100.0, 114.0, 102.0, 105.0, 101.0],
            ]
        )
        q2 = torch.tensor(
            [
                [17.0, 18.0, 24.0, 48.0, 101.0, 101.0, 101.0, 101.0],
                [18.0, 21.0, 27.0, 67.0, 101.0, 101.0, 101.0, 101.0],
                [24.0, 27.0, 57.0, 101.0, 101.0, 101.0, 101.0, 101.0],
                [48.0, 67.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0],
                [101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0],
                [101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0],
                [101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0],
                [101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0, 101.0],
            ]
        )
    elif qf == 50:
        q1 = torch.tensor(
            [
                [16.0, 11.0, 10.0, 16.0, 24.0, 40.0, 51.0, 61.0],
                [12.0, 12.0, 14.0, 19.0, 26.0, 58.0, 60.0, 55.0],
                [14.0, 13.0, 16.0, 24.0, 40.0, 57.0, 69.0, 56.0],
                [14.0, 17.0, 22.0, 29.0, 51.0, 87.0, 80.0, 62.0],
                [18.0, 22.0, 37.0, 56.0, 68.0, 109.0, 103.0, 77.0],
                [24.0, 35.0, 55.0, 64.0, 81.0, 104.0, 113.0, 92.0],
                [49.0, 64.0, 78.0, 87.0, 103.0, 121.0, 120.0, 101.0],
                [72.0, 92.0, 95.0, 98.0, 112.0, 100.0, 103.0, 99.0],
            ]
        )
        q2 = torch.tensor(
            [
                [17.0, 18.0, 24.0, 47.0, 99.0, 99.0, 99.0, 99.0],
                [18.0, 21.0, 26.0, 66.0, 99.0, 99.0, 99.0, 99.0],
                [24.0, 26.0, 56.0, 99.0, 99.0, 99.0, 99.0, 99.0],
                [47.0, 66.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0],
                [99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0],
                [99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0],
                [99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0],
                [99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0],
            ]
        )
    elif qf == 51:
        q1 = torch.tensor(
            [
                [16.0, 11.0, 10.0, 16.0, 24.0, 39.0, 50.0, 60.0],
                [12.0, 12.0, 14.0, 19.0, 25.0, 57.0, 59.0, 54.0],
                [14.0, 13.0, 16.0, 24.0, 39.0, 56.0, 68.0, 55.0],
                [14.0, 17.0, 22.0, 28.0, 50.0, 85.0, 78.0, 61.0],
                [18.0, 22.0, 36.0, 55.0, 67.0, 107.0, 101.0, 75.0],
                [24.0, 34.0, 54.0, 63.0, 79.0, 102.0, 111.0, 90.0],
                [48.0, 63.0, 76.0, 85.0, 101.0, 119.0, 118.0, 99.0],
                [71.0, 90.0, 93.0, 96.0, 110.0, 98.0, 101.0, 97.0],
            ]
        )
        q2 = torch.tensor(
            [
                [17.0, 18.0, 24.0, 46.0, 97.0, 97.0, 97.0, 97.0],
                [18.0, 21.0, 25.0, 65.0, 97.0, 97.0, 97.0, 97.0],
                [24.0, 25.0, 55.0, 97.0, 97.0, 97.0, 97.0, 97.0],
                [46.0, 65.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0],
                [97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0],
                [97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0],
                [97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0],
                [97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0],
            ]
        )
    elif qf == 52:
        q1 = torch.tensor(
            [
                [15.0, 11.0, 10.0, 15.0, 23.0, 38.0, 49.0, 59.0],
                [12.0, 12.0, 13.0, 18.0, 25.0, 56.0, 58.0, 53.0],
                [13.0, 12.0, 15.0, 23.0, 38.0, 55.0, 66.0, 54.0],
                [13.0, 16.0, 21.0, 28.0, 49.0, 84.0, 77.0, 60.0],
                [17.0, 21.0, 36.0, 54.0, 65.0, 105.0, 99.0, 74.0],
                [23.0, 34.0, 53.0, 61.0, 78.0, 100.0, 108.0, 88.0],
                [47.0, 61.0, 75.0, 84.0, 99.0, 116.0, 115.0, 97.0],
                [69.0, 88.0, 91.0, 94.0, 108.0, 96.0, 99.0, 95.0],
            ]
        )
        q2 = torch.tensor(
            [
                [16.0, 17.0, 23.0, 45.0, 95.0, 95.0, 95.0, 95.0],
                [17.0, 20.0, 25.0, 63.0, 95.0, 95.0, 95.0, 95.0],
                [23.0, 25.0, 54.0, 95.0, 95.0, 95.0, 95.0, 95.0],
                [45.0, 63.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0],
                [95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0],
                [95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0],
                [95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0],
                [95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0],
            ]
        )
    elif qf == 53:
        q1 = torch.tensor(
            [
                [15.0, 10.0, 9.0, 15.0, 23.0, 38.0, 48.0, 57.0],
                [11.0, 11.0, 13.0, 18.0, 24.0, 55.0, 56.0, 52.0],
                [13.0, 12.0, 15.0, 23.0, 38.0, 54.0, 65.0, 53.0],
                [13.0, 16.0, 21.0, 27.0, 48.0, 82.0, 75.0, 58.0],
                [17.0, 21.0, 35.0, 53.0, 64.0, 102.0, 97.0, 72.0],
                [23.0, 33.0, 52.0, 60.0, 76.0, 98.0, 106.0, 86.0],
                [46.0, 60.0, 73.0, 82.0, 97.0, 114.0, 113.0, 95.0],
                [68.0, 86.0, 89.0, 92.0, 105.0, 94.0, 97.0, 93.0],
            ]
        )
        q2 = torch.tensor(
            [
                [16.0, 17.0, 23.0, 44.0, 93.0, 93.0, 93.0, 93.0],
                [17.0, 20.0, 24.0, 62.0, 93.0, 93.0, 93.0, 93.0],
                [23.0, 24.0, 53.0, 93.0, 93.0, 93.0, 93.0, 93.0],
                [44.0, 62.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0],
                [93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0],
                [93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0],
                [93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0],
                [93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0, 93.0],
            ]
        )
    elif qf == 54:
        q1 = torch.tensor(
            [
                [15.0, 10.0, 9.0, 15.0, 22.0, 37.0, 47.0, 56.0],
                [11.0, 11.0, 13.0, 17.0, 24.0, 53.0, 55.0, 51.0],
                [13.0, 12.0, 15.0, 22.0, 37.0, 52.0, 63.0, 52.0],
                [13.0, 16.0, 20.0, 27.0, 47.0, 80.0, 74.0, 57.0],
                [17.0, 20.0, 34.0, 52.0, 63.0, 100.0, 95.0, 71.0],
                [22.0, 32.0, 51.0, 59.0, 75.0, 96.0, 104.0, 85.0],
                [45.0, 59.0, 72.0, 80.0, 95.0, 111.0, 110.0, 93.0],
                [66.0, 85.0, 87.0, 90.0, 103.0, 92.0, 95.0, 91.0],
            ]
        )
        q2 = torch.tensor(
            [
                [16.0, 17.0, 22.0, 43.0, 91.0, 91.0, 91.0, 91.0],
                [17.0, 19.0, 24.0, 61.0, 91.0, 91.0, 91.0, 91.0],
                [22.0, 24.0, 52.0, 91.0, 91.0, 91.0, 91.0, 91.0],
                [43.0, 61.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0],
                [91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0],
                [91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0],
                [91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0],
                [91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0, 91.0],
            ]
        )
    elif qf == 55:
        q1 = torch.tensor(
            [
                [14.0, 10.0, 9.0, 14.0, 22.0, 36.0, 46.0, 55.0],
                [11.0, 11.0, 13.0, 17.0, 23.0, 52.0, 54.0, 50.0],
                [13.0, 12.0, 14.0, 22.0, 36.0, 51.0, 62.0, 50.0],
                [13.0, 15.0, 20.0, 26.0, 46.0, 78.0, 72.0, 56.0],
                [16.0, 20.0, 33.0, 50.0, 61.0, 98.0, 93.0, 69.0],
                [22.0, 32.0, 50.0, 58.0, 73.0, 94.0, 102.0, 83.0],
                [44.0, 58.0, 70.0, 78.0, 93.0, 109.0, 108.0, 91.0],
                [65.0, 83.0, 86.0, 88.0, 101.0, 90.0, 93.0, 89.0],
            ]
        )
        q2 = torch.tensor(
            [
                [15.0, 16.0, 22.0, 42.0, 89.0, 89.0, 89.0, 89.0],
                [16.0, 19.0, 23.0, 59.0, 89.0, 89.0, 89.0, 89.0],
                [22.0, 23.0, 50.0, 89.0, 89.0, 89.0, 89.0, 89.0],
                [42.0, 59.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0],
                [89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0],
                [89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0],
                [89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0],
                [89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0],
            ]
        )
    elif qf == 56:
        q1 = torch.tensor(
            [
                [14.0, 10.0, 9.0, 14.0, 21.0, 35.0, 45.0, 54.0],
                [11.0, 11.0, 12.0, 17.0, 23.0, 51.0, 53.0, 48.0],
                [12.0, 11.0, 14.0, 21.0, 35.0, 50.0, 61.0, 49.0],
                [12.0, 15.0, 19.0, 26.0, 45.0, 77.0, 70.0, 55.0],
                [16.0, 19.0, 33.0, 49.0, 60.0, 96.0, 91.0, 68.0],
                [21.0, 31.0, 48.0, 56.0, 71.0, 92.0, 99.0, 81.0],
                [43.0, 56.0, 69.0, 77.0, 91.0, 106.0, 106.0, 89.0],
                [63.0, 81.0, 84.0, 86.0, 99.0, 88.0, 91.0, 87.0],
            ]
        )
        q2 = torch.tensor(
            [
                [15.0, 16.0, 21.0, 41.0, 87.0, 87.0, 87.0, 87.0],
                [16.0, 18.0, 23.0, 58.0, 87.0, 87.0, 87.0, 87.0],
                [21.0, 23.0, 49.0, 87.0, 87.0, 87.0, 87.0, 87.0],
                [41.0, 58.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0],
                [87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0],
                [87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0],
                [87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0],
                [87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0],
            ]
        )
    elif qf == 57:
        q1 = torch.tensor(
            [
                [14.0, 9.0, 9.0, 14.0, 21.0, 34.0, 44.0, 52.0],
                [10.0, 10.0, 12.0, 16.0, 22.0, 50.0, 52.0, 47.0],
                [12.0, 11.0, 14.0, 21.0, 34.0, 49.0, 59.0, 48.0],
                [12.0, 15.0, 19.0, 25.0, 44.0, 75.0, 69.0, 53.0],
                [15.0, 19.0, 32.0, 48.0, 58.0, 94.0, 89.0, 66.0],
                [21.0, 30.0, 47.0, 55.0, 70.0, 89.0, 97.0, 79.0],
                [42.0, 55.0, 67.0, 75.0, 89.0, 104.0, 103.0, 87.0],
                [62.0, 79.0, 82.0, 84.0, 96.0, 86.0, 89.0, 85.0],
            ]
        )
        q2 = torch.tensor(
            [
                [15.0, 15.0, 21.0, 40.0, 85.0, 85.0, 85.0, 85.0],
                [15.0, 18.0, 22.0, 57.0, 85.0, 85.0, 85.0, 85.0],
                [21.0, 22.0, 48.0, 85.0, 85.0, 85.0, 85.0, 85.0],
                [40.0, 57.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0],
                [85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0],
                [85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0],
                [85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0],
                [85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0],
            ]
        )
    elif qf == 58:
        q1 = torch.tensor(
            [
                [13.0, 9.0, 8.0, 13.0, 20.0, 34.0, 43.0, 51.0],
                [10.0, 10.0, 12.0, 16.0, 22.0, 49.0, 50.0, 46.0],
                [12.0, 11.0, 13.0, 20.0, 34.0, 48.0, 58.0, 47.0],
                [12.0, 14.0, 18.0, 24.0, 43.0, 73.0, 67.0, 52.0],
                [15.0, 18.0, 31.0, 47.0, 57.0, 92.0, 87.0, 65.0],
                [20.0, 29.0, 46.0, 54.0, 68.0, 87.0, 95.0, 77.0],
                [41.0, 54.0, 66.0, 73.0, 87.0, 102.0, 101.0, 85.0],
                [60.0, 77.0, 80.0, 82.0, 94.0, 84.0, 87.0, 83.0],
            ]
        )
        q2 = torch.tensor(
            [
                [14.0, 15.0, 20.0, 39.0, 83.0, 83.0, 83.0, 83.0],
                [15.0, 18.0, 22.0, 55.0, 83.0, 83.0, 83.0, 83.0],
                [20.0, 22.0, 47.0, 83.0, 83.0, 83.0, 83.0, 83.0],
                [39.0, 55.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0],
                [83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0],
                [83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0],
                [83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0],
                [83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0],
            ]
        )
    elif qf == 59:
        q1 = torch.tensor(
            [
                [13.0, 9.0, 8.0, 13.0, 20.0, 33.0, 42.0, 50.0],
                [10.0, 10.0, 11.0, 16.0, 21.0, 48.0, 49.0, 45.0],
                [11.0, 11.0, 13.0, 20.0, 33.0, 47.0, 57.0, 46.0],
                [11.0, 14.0, 18.0, 24.0, 42.0, 71.0, 66.0, 51.0],
                [15.0, 18.0, 30.0, 46.0, 56.0, 89.0, 84.0, 63.0],
                [20.0, 29.0, 45.0, 52.0, 66.0, 85.0, 93.0, 75.0],
                [40.0, 52.0, 64.0, 71.0, 84.0, 99.0, 98.0, 83.0],
                [59.0, 75.0, 78.0, 80.0, 92.0, 82.0, 84.0, 81.0],
            ]
        )
        q2 = torch.tensor(
            [
                [14.0, 15.0, 20.0, 39.0, 81.0, 81.0, 81.0, 81.0],
                [15.0, 17.0, 21.0, 54.0, 81.0, 81.0, 81.0, 81.0],
                [20.0, 21.0, 46.0, 81.0, 81.0, 81.0, 81.0, 81.0],
                [39.0, 54.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0],
                [81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0],
                [81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0],
                [81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0],
                [81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0],
            ]
        )
    elif qf == 60:
        q1 = torch.tensor(
            [
                [13.0, 9.0, 8.0, 13.0, 19.0, 32.0, 41.0, 49.0],
                [10.0, 10.0, 11.0, 15.0, 21.0, 46.0, 48.0, 44.0],
                [11.0, 10.0, 13.0, 19.0, 32.0, 46.0, 55.0, 45.0],
                [11.0, 14.0, 18.0, 23.0, 41.0, 70.0, 64.0, 50.0],
                [14.0, 18.0, 30.0, 45.0, 54.0, 87.0, 82.0, 62.0],
                [19.0, 28.0, 44.0, 51.0, 65.0, 83.0, 90.0, 74.0],
                [39.0, 51.0, 62.0, 70.0, 82.0, 97.0, 96.0, 81.0],
                [58.0, 74.0, 76.0, 78.0, 90.0, 80.0, 82.0, 79.0],
            ]
        )
        q2 = torch.tensor(
            [
                [14.0, 14.0, 19.0, 38.0, 79.0, 79.0, 79.0, 79.0],
                [14.0, 17.0, 21.0, 53.0, 79.0, 79.0, 79.0, 79.0],
                [19.0, 21.0, 45.0, 79.0, 79.0, 79.0, 79.0, 79.0],
                [38.0, 53.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0],
                [79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0],
                [79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0],
                [79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0],
                [79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0],
            ]
        )
    elif qf == 61:
        q1 = torch.tensor(
            [
                [12.0, 9.0, 8.0, 12.0, 19.0, 31.0, 40.0, 48.0],
                [9.0, 9.0, 11.0, 15.0, 20.0, 45.0, 47.0, 43.0],
                [11.0, 10.0, 12.0, 19.0, 31.0, 44.0, 54.0, 44.0],
                [11.0, 13.0, 17.0, 23.0, 40.0, 68.0, 62.0, 48.0],
                [14.0, 17.0, 29.0, 44.0, 53.0, 85.0, 80.0, 60.0],
                [19.0, 27.0, 43.0, 50.0, 63.0, 81.0, 88.0, 72.0],
                [38.0, 50.0, 61.0, 68.0, 80.0, 94.0, 94.0, 79.0],
                [56.0, 72.0, 74.0, 76.0, 87.0, 78.0, 80.0, 77.0],
            ]
        )
        q2 = torch.tensor(
            [
                [13.0, 14.0, 19.0, 37.0, 77.0, 77.0, 77.0, 77.0],
                [14.0, 16.0, 20.0, 51.0, 77.0, 77.0, 77.0, 77.0],
                [19.0, 20.0, 44.0, 77.0, 77.0, 77.0, 77.0, 77.0],
                [37.0, 51.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0],
                [77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0],
                [77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0],
                [77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0],
                [77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0, 77.0],
            ]
        )
    elif qf == 62:
        q1 = torch.tensor(
            [
                [12.0, 8.0, 8.0, 12.0, 18.0, 30.0, 39.0, 46.0],
                [9.0, 9.0, 11.0, 14.0, 20.0, 44.0, 46.0, 42.0],
                [11.0, 10.0, 12.0, 18.0, 30.0, 43.0, 52.0, 43.0],
                [11.0, 13.0, 17.0, 22.0, 39.0, 66.0, 61.0, 47.0],
                [14.0, 17.0, 28.0, 43.0, 52.0, 83.0, 78.0, 59.0],
                [18.0, 27.0, 42.0, 49.0, 62.0, 79.0, 86.0, 70.0],
                [37.0, 49.0, 59.0, 66.0, 78.0, 92.0, 91.0, 77.0],
                [55.0, 70.0, 72.0, 74.0, 85.0, 76.0, 78.0, 75.0],
            ]
        )
        q2 = torch.tensor(
            [
                [13.0, 14.0, 18.0, 36.0, 75.0, 75.0, 75.0, 75.0],
                [14.0, 16.0, 20.0, 50.0, 75.0, 75.0, 75.0, 75.0],
                [18.0, 20.0, 43.0, 75.0, 75.0, 75.0, 75.0, 75.0],
                [36.0, 50.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0],
                [75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0],
                [75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0],
                [75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0],
                [75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0],
            ]
        )
    elif qf == 63:
        q1 = torch.tensor(
            [
                [12.0, 8.0, 7.0, 12.0, 18.0, 30.0, 38.0, 45.0],
                [9.0, 9.0, 10.0, 14.0, 19.0, 43.0, 44.0, 41.0],
                [10.0, 10.0, 12.0, 18.0, 30.0, 42.0, 51.0, 41.0],
                [10.0, 13.0, 16.0, 21.0, 38.0, 64.0, 59.0, 46.0],
                [13.0, 16.0, 27.0, 41.0, 50.0, 81.0, 76.0, 57.0],
                [18.0, 26.0, 41.0, 47.0, 60.0, 77.0, 84.0, 68.0],
                [36.0, 47.0, 58.0, 64.0, 76.0, 90.0, 89.0, 75.0],
                [53.0, 68.0, 70.0, 73.0, 83.0, 74.0, 76.0, 73.0],
            ]
        )
        q2 = torch.tensor(
            [
                [13.0, 13.0, 18.0, 35.0, 73.0, 73.0, 73.0, 73.0],
                [13.0, 16.0, 19.0, 49.0, 73.0, 73.0, 73.0, 73.0],
                [18.0, 19.0, 41.0, 73.0, 73.0, 73.0, 73.0, 73.0],
                [35.0, 49.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0],
                [73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0],
                [73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0],
                [73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0],
                [73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0],
            ]
        )
    elif qf == 64:
        q1 = torch.tensor(
            [
                [12.0, 8.0, 7.0, 12.0, 17.0, 29.0, 37.0, 44.0],
                [9.0, 9.0, 10.0, 14.0, 19.0, 42.0, 43.0, 40.0],
                [10.0, 9.0, 12.0, 17.0, 29.0, 41.0, 50.0, 40.0],
                [10.0, 12.0, 16.0, 21.0, 37.0, 63.0, 58.0, 45.0],
                [13.0, 16.0, 27.0, 40.0, 49.0, 78.0, 74.0, 55.0],
                [17.0, 25.0, 40.0, 46.0, 58.0, 75.0, 81.0, 66.0],
                [35.0, 46.0, 56.0, 63.0, 74.0, 87.0, 86.0, 73.0],
                [52.0, 66.0, 68.0, 71.0, 81.0, 72.0, 74.0, 71.0],
            ]
        )
        q2 = torch.tensor(
            [
                [12.0, 13.0, 17.0, 34.0, 71.0, 71.0, 71.0, 71.0],
                [13.0, 15.0, 19.0, 48.0, 71.0, 71.0, 71.0, 71.0],
                [17.0, 19.0, 40.0, 71.0, 71.0, 71.0, 71.0, 71.0],
                [34.0, 48.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0],
                [71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0],
                [71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0],
                [71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0],
                [71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0],
            ]
        )
    elif qf == 65:
        q1 = torch.tensor(
            [
                [11.0, 8.0, 7.0, 11.0, 17.0, 28.0, 36.0, 43.0],
                [8.0, 8.0, 10.0, 13.0, 18.0, 41.0, 42.0, 39.0],
                [10.0, 9.0, 11.0, 17.0, 28.0, 40.0, 48.0, 39.0],
                [10.0, 12.0, 15.0, 20.0, 36.0, 61.0, 56.0, 43.0],
                [13.0, 15.0, 26.0, 39.0, 48.0, 76.0, 72.0, 54.0],
                [17.0, 25.0, 39.0, 45.0, 57.0, 73.0, 79.0, 64.0],
                [34.0, 45.0, 55.0, 61.0, 72.0, 85.0, 84.0, 71.0],
                [50.0, 64.0, 67.0, 69.0, 78.0, 70.0, 72.0, 69.0],
            ]
        )
        q2 = torch.tensor(
            [
                [12.0, 13.0, 17.0, 33.0, 69.0, 69.0, 69.0, 69.0],
                [13.0, 15.0, 18.0, 46.0, 69.0, 69.0, 69.0, 69.0],
                [17.0, 18.0, 39.0, 69.0, 69.0, 69.0, 69.0, 69.0],
                [33.0, 46.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0],
                [69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0],
                [69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0],
                [69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0],
                [69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 69.0],
            ]
        )
    elif qf == 66:
        q1 = torch.tensor(
            [
                [11.0, 7.0, 7.0, 11.0, 16.0, 27.0, 35.0, 41.0],
                [8.0, 8.0, 10.0, 13.0, 18.0, 39.0, 41.0, 37.0],
                [10.0, 9.0, 11.0, 16.0, 27.0, 39.0, 47.0, 38.0],
                [10.0, 12.0, 15.0, 20.0, 35.0, 59.0, 54.0, 42.0],
                [12.0, 15.0, 25.0, 38.0, 46.0, 74.0, 70.0, 52.0],
                [16.0, 24.0, 37.0, 44.0, 55.0, 71.0, 77.0, 63.0],
                [33.0, 44.0, 53.0, 59.0, 70.0, 82.0, 82.0, 69.0],
                [49.0, 63.0, 65.0, 67.0, 76.0, 68.0, 70.0, 67.0],
            ]
        )
        q2 = torch.tensor(
            [
                [12.0, 12.0, 16.0, 32.0, 67.0, 67.0, 67.0, 67.0],
                [12.0, 14.0, 18.0, 45.0, 67.0, 67.0, 67.0, 67.0],
                [16.0, 18.0, 38.0, 67.0, 67.0, 67.0, 67.0, 67.0],
                [32.0, 45.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0],
                [67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0],
                [67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0],
                [67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0],
                [67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0, 67.0],
            ]
        )
    elif qf == 67:
        q1 = torch.tensor(
            [
                [11.0, 7.0, 7.0, 11.0, 16.0, 26.0, 34.0, 40.0],
                [8.0, 8.0, 9.0, 13.0, 17.0, 38.0, 40.0, 36.0],
                [9.0, 9.0, 11.0, 16.0, 26.0, 38.0, 46.0, 37.0],
                [9.0, 11.0, 15.0, 19.0, 34.0, 57.0, 53.0, 41.0],
                [12.0, 15.0, 24.0, 37.0, 45.0, 72.0, 68.0, 51.0],
                [16.0, 23.0, 36.0, 42.0, 53.0, 69.0, 75.0, 61.0],
                [32.0, 42.0, 51.0, 57.0, 68.0, 80.0, 79.0, 67.0],
                [48.0, 61.0, 63.0, 65.0, 74.0, 66.0, 68.0, 65.0],
            ]
        )
        q2 = torch.tensor(
            [
                [11.0, 12.0, 16.0, 31.0, 65.0, 65.0, 65.0, 65.0],
                [12.0, 14.0, 17.0, 44.0, 65.0, 65.0, 65.0, 65.0],
                [16.0, 17.0, 37.0, 65.0, 65.0, 65.0, 65.0, 65.0],
                [31.0, 44.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0],
                [65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0],
                [65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0],
                [65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0],
                [65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0, 65.0],
            ]
        )
    elif qf == 68:
        q1 = torch.tensor(
            [
                [10.0, 7.0, 6.0, 10.0, 15.0, 26.0, 33.0, 39.0],
                [8.0, 8.0, 9.0, 12.0, 17.0, 37.0, 38.0, 35.0],
                [9.0, 8.0, 10.0, 15.0, 26.0, 36.0, 44.0, 36.0],
                [9.0, 11.0, 14.0, 19.0, 33.0, 56.0, 51.0, 40.0],
                [12.0, 14.0, 24.0, 36.0, 44.0, 70.0, 66.0, 49.0],
                [15.0, 22.0, 35.0, 41.0, 52.0, 67.0, 72.0, 59.0],
                [31.0, 41.0, 50.0, 56.0, 66.0, 77.0, 77.0, 65.0],
                [46.0, 59.0, 61.0, 63.0, 72.0, 64.0, 66.0, 63.0],
            ]
        )
        q2 = torch.tensor(
            [
                [11.0, 12.0, 15.0, 30.0, 63.0, 63.0, 63.0, 63.0],
                [12.0, 13.0, 17.0, 42.0, 63.0, 63.0, 63.0, 63.0],
                [15.0, 17.0, 36.0, 63.0, 63.0, 63.0, 63.0, 63.0],
                [30.0, 42.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0],
                [63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0],
                [63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0],
                [63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0],
                [63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0, 63.0],
            ]
        )
    elif qf == 69:
        q1 = torch.tensor(
            [
                [10.0, 7.0, 6.0, 10.0, 15.0, 25.0, 32.0, 38.0],
                [7.0, 7.0, 9.0, 12.0, 16.0, 36.0, 37.0, 34.0],
                [9.0, 8.0, 10.0, 15.0, 25.0, 35.0, 43.0, 35.0],
                [9.0, 11.0, 14.0, 18.0, 32.0, 54.0, 50.0, 38.0],
                [11.0, 14.0, 23.0, 35.0, 42.0, 68.0, 64.0, 48.0],
                [15.0, 22.0, 34.0, 40.0, 50.0, 64.0, 70.0, 57.0],
                [30.0, 40.0, 48.0, 54.0, 64.0, 75.0, 74.0, 63.0],
                [45.0, 57.0, 59.0, 61.0, 69.0, 62.0, 64.0, 61.0],
            ]
        )
        q2 = torch.tensor(
            [
                [11.0, 11.0, 15.0, 29.0, 61.0, 61.0, 61.0, 61.0],
                [11.0, 13.0, 16.0, 41.0, 61.0, 61.0, 61.0, 61.0],
                [15.0, 16.0, 35.0, 61.0, 61.0, 61.0, 61.0, 61.0],
                [29.0, 41.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0],
                [61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0],
                [61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0],
                [61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0],
                [61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0],
            ]
        )
    elif qf == 70:
        q1 = torch.tensor(
            [
                [10.0, 7.0, 6.0, 10.0, 14.0, 24.0, 31.0, 37.0],
                [7.0, 7.0, 8.0, 11.0, 16.0, 35.0, 36.0, 33.0],
                [8.0, 8.0, 10.0, 14.0, 24.0, 34.0, 41.0, 34.0],
                [8.0, 10.0, 13.0, 17.0, 31.0, 52.0, 48.0, 37.0],
                [11.0, 13.0, 22.0, 34.0, 41.0, 65.0, 62.0, 46.0],
                [14.0, 21.0, 33.0, 38.0, 49.0, 62.0, 68.0, 55.0],
                [29.0, 38.0, 47.0, 52.0, 62.0, 73.0, 72.0, 61.0],
                [43.0, 55.0, 57.0, 59.0, 67.0, 60.0, 62.0, 59.0],
            ]
        )
        q2 = torch.tensor(
            [
                [10.0, 11.0, 14.0, 28.0, 59.0, 59.0, 59.0, 59.0],
                [11.0, 13.0, 16.0, 40.0, 59.0, 59.0, 59.0, 59.0],
                [14.0, 16.0, 34.0, 59.0, 59.0, 59.0, 59.0, 59.0],
                [28.0, 40.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0],
                [59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0],
                [59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0],
                [59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0],
                [59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0, 59.0],
            ]
        )
    elif qf == 71:
        q1 = torch.tensor(
            [
                [9.0, 6.0, 6.0, 9.0, 14.0, 23.0, 30.0, 35.0],
                [7.0, 7.0, 8.0, 11.0, 15.0, 34.0, 35.0, 32.0],
                [8.0, 8.0, 9.0, 14.0, 23.0, 33.0, 40.0, 32.0],
                [8.0, 10.0, 13.0, 17.0, 30.0, 50.0, 46.0, 36.0],
                [10.0, 13.0, 21.0, 32.0, 39.0, 63.0, 60.0, 45.0],
                [14.0, 20.0, 32.0, 37.0, 47.0, 60.0, 66.0, 53.0],
                [28.0, 37.0, 45.0, 50.0, 60.0, 70.0, 70.0, 59.0],
                [42.0, 53.0, 55.0, 57.0, 65.0, 58.0, 60.0, 57.0],
            ]
        )
        q2 = torch.tensor(
            [
                [10.0, 10.0, 14.0, 27.0, 57.0, 57.0, 57.0, 57.0],
                [10.0, 12.0, 15.0, 38.0, 57.0, 57.0, 57.0, 57.0],
                [14.0, 15.0, 32.0, 57.0, 57.0, 57.0, 57.0, 57.0],
                [27.0, 38.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0],
                [57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0],
                [57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0],
                [57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0],
                [57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0, 57.0],
            ]
        )
    elif qf == 72:
        q1 = torch.tensor(
            [
                [9.0, 6.0, 6.0, 9.0, 13.0, 22.0, 29.0, 34.0],
                [7.0, 7.0, 8.0, 11.0, 15.0, 32.0, 34.0, 31.0],
                [8.0, 7.0, 9.0, 13.0, 22.0, 32.0, 39.0, 31.0],
                [8.0, 10.0, 12.0, 16.0, 29.0, 49.0, 45.0, 35.0],
                [10.0, 12.0, 21.0, 31.0, 38.0, 61.0, 58.0, 43.0],
                [13.0, 20.0, 31.0, 36.0, 45.0, 58.0, 63.0, 52.0],
                [27.0, 36.0, 44.0, 49.0, 58.0, 68.0, 67.0, 57.0],
                [40.0, 52.0, 53.0, 55.0, 63.0, 56.0, 58.0, 55.0],
            ]
        )
        q2 = torch.tensor(
            [
                [10.0, 10.0, 13.0, 26.0, 55.0, 55.0, 55.0, 55.0],
                [10.0, 12.0, 15.0, 37.0, 55.0, 55.0, 55.0, 55.0],
                [13.0, 15.0, 31.0, 55.0, 55.0, 55.0, 55.0, 55.0],
                [26.0, 37.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0],
                [55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0],
                [55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0],
                [55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0],
                [55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0],
            ]
        )
    elif qf == 73:
        q1 = torch.tensor(
            [
                [9.0, 6.0, 5.0, 9.0, 13.0, 22.0, 28.0, 33.0],
                [6.0, 6.0, 8.0, 10.0, 14.0, 31.0, 32.0, 30.0],
                [8.0, 7.0, 9.0, 13.0, 22.0, 31.0, 37.0, 30.0],
                [8.0, 9.0, 12.0, 16.0, 28.0, 47.0, 43.0, 33.0],
                [10.0, 12.0, 20.0, 30.0, 37.0, 59.0, 56.0, 42.0],
                [13.0, 19.0, 30.0, 35.0, 44.0, 56.0, 61.0, 50.0],
                [26.0, 35.0, 42.0, 47.0, 56.0, 65.0, 65.0, 55.0],
                [39.0, 50.0, 51.0, 53.0, 60.0, 54.0, 56.0, 53.0],
            ]
        )
        q2 = torch.tensor(
            [
                [9.0, 10.0, 13.0, 25.0, 53.0, 53.0, 53.0, 53.0],
                [10.0, 11.0, 14.0, 36.0, 53.0, 53.0, 53.0, 53.0],
                [13.0, 14.0, 30.0, 53.0, 53.0, 53.0, 53.0, 53.0],
                [25.0, 36.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0],
                [53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0],
                [53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0],
                [53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0],
                [53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0, 53.0],
            ]
        )
    elif qf == 74:
        q1 = torch.tensor(
            [
                [8.0, 6.0, 5.0, 8.0, 12.0, 21.0, 27.0, 32.0],
                [6.0, 6.0, 7.0, 10.0, 14.0, 30.0, 31.0, 29.0],
                [7.0, 7.0, 8.0, 12.0, 21.0, 30.0, 36.0, 29.0],
                [7.0, 9.0, 11.0, 15.0, 27.0, 45.0, 42.0, 32.0],
                [9.0, 11.0, 19.0, 29.0, 35.0, 57.0, 54.0, 40.0],
                [12.0, 18.0, 29.0, 33.0, 42.0, 54.0, 59.0, 48.0],
                [25.0, 33.0, 41.0, 45.0, 54.0, 63.0, 62.0, 53.0],
                [37.0, 48.0, 49.0, 51.0, 58.0, 52.0, 54.0, 51.0],
            ]
        )
        q2 = torch.tensor(
            [
                [9.0, 9.0, 12.0, 24.0, 51.0, 51.0, 51.0, 51.0],
                [9.0, 11.0, 14.0, 34.0, 51.0, 51.0, 51.0, 51.0],
                [12.0, 14.0, 29.0, 51.0, 51.0, 51.0, 51.0, 51.0],
                [24.0, 34.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0],
                [51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0],
                [51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0],
                [51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0],
                [51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0],
            ]
        )
    elif qf == 75:
        q1 = torch.tensor(
            [
                [8.0, 6.0, 5.0, 8.0, 12.0, 20.0, 26.0, 31.0],
                [6.0, 6.0, 7.0, 10.0, 13.0, 29.0, 30.0, 28.0],
                [7.0, 7.0, 8.0, 12.0, 20.0, 29.0, 35.0, 28.0],
                [7.0, 9.0, 11.0, 15.0, 26.0, 44.0, 40.0, 31.0],
                [9.0, 11.0, 19.0, 28.0, 34.0, 55.0, 52.0, 39.0],
                [12.0, 18.0, 28.0, 32.0, 41.0, 52.0, 57.0, 46.0],
                [25.0, 32.0, 39.0, 44.0, 52.0, 61.0, 60.0, 51.0],
                [36.0, 46.0, 48.0, 49.0, 56.0, 50.0, 52.0, 50.0],
            ]
        )
        q2 = torch.tensor(
            [
                [9.0, 9.0, 12.0, 24.0, 50.0, 50.0, 50.0, 50.0],
                [9.0, 11.0, 13.0, 33.0, 50.0, 50.0, 50.0, 50.0],
                [12.0, 13.0, 28.0, 50.0, 50.0, 50.0, 50.0, 50.0],
                [24.0, 33.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0],
                [50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0],
                [50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0],
                [50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0],
                [50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0],
            ]
        )
    elif qf == 76:
        q1 = torch.tensor(
            [
                [8.0, 5.0, 5.0, 8.0, 12.0, 19.0, 24.0, 29.0],
                [6.0, 6.0, 7.0, 9.0, 12.0, 28.0, 29.0, 26.0],
                [7.0, 6.0, 8.0, 12.0, 19.0, 27.0, 33.0, 27.0],
                [7.0, 8.0, 11.0, 14.0, 24.0, 42.0, 38.0, 30.0],
                [9.0, 11.0, 18.0, 27.0, 33.0, 52.0, 49.0, 37.0],
                [12.0, 17.0, 26.0, 31.0, 39.0, 50.0, 54.0, 44.0],
                [24.0, 31.0, 37.0, 42.0, 49.0, 58.0, 58.0, 48.0],
                [35.0, 44.0, 46.0, 47.0, 54.0, 48.0, 49.0, 48.0],
            ]
        )
        q2 = torch.tensor(
            [
                [8.0, 9.0, 12.0, 23.0, 48.0, 48.0, 48.0, 48.0],
                [9.0, 10.0, 12.0, 32.0, 48.0, 48.0, 48.0, 48.0],
                [12.0, 12.0, 27.0, 48.0, 48.0, 48.0, 48.0, 48.0],
                [23.0, 32.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0],
                [48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0],
                [48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0],
                [48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0],
                [48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0],
            ]
        )
    elif qf == 77:
        q1 = torch.tensor(
            [
                [7.0, 5.0, 5.0, 7.0, 11.0, 18.0, 23.0, 28.0],
                [6.0, 6.0, 6.0, 9.0, 12.0, 27.0, 28.0, 25.0],
                [6.0, 6.0, 7.0, 11.0, 18.0, 26.0, 32.0, 26.0],
                [6.0, 8.0, 10.0, 13.0, 23.0, 40.0, 37.0, 29.0],
                [8.0, 10.0, 17.0, 26.0, 31.0, 50.0, 47.0, 35.0],
                [11.0, 16.0, 25.0, 29.0, 37.0, 48.0, 52.0, 42.0],
                [23.0, 29.0, 36.0, 40.0, 47.0, 56.0, 55.0, 46.0],
                [33.0, 42.0, 44.0, 45.0, 52.0, 46.0, 47.0, 46.0],
            ]
        )
        q2 = torch.tensor(
            [
                [8.0, 8.0, 11.0, 22.0, 46.0, 46.0, 46.0, 46.0],
                [8.0, 10.0, 12.0, 30.0, 46.0, 46.0, 46.0, 46.0],
                [11.0, 12.0, 26.0, 46.0, 46.0, 46.0, 46.0, 46.0],
                [22.0, 30.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0],
                [46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0],
                [46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0],
                [46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0],
                [46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0],
            ]
        )
    elif qf == 78:
        q1 = torch.tensor(
            [
                [7.0, 5.0, 4.0, 7.0, 11.0, 18.0, 22.0, 27.0],
                [5.0, 5.0, 6.0, 8.0, 11.0, 26.0, 26.0, 24.0],
                [6.0, 6.0, 7.0, 11.0, 18.0, 25.0, 30.0, 25.0],
                [6.0, 7.0, 10.0, 13.0, 22.0, 38.0, 35.0, 27.0],
                [8.0, 10.0, 16.0, 25.0, 30.0, 48.0, 45.0, 34.0],
                [11.0, 15.0, 24.0, 28.0, 36.0, 46.0, 50.0, 40.0],
                [22.0, 28.0, 34.0, 38.0, 45.0, 53.0, 53.0, 44.0],
                [32.0, 40.0, 42.0, 43.0, 49.0, 44.0, 45.0, 44.0],
            ]
        )
        q2 = torch.tensor(
            [
                [7.0, 8.0, 11.0, 21.0, 44.0, 44.0, 44.0, 44.0],
                [8.0, 9.0, 11.0, 29.0, 44.0, 44.0, 44.0, 44.0],
                [11.0, 11.0, 25.0, 44.0, 44.0, 44.0, 44.0, 44.0],
                [21.0, 29.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0],
                [44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0],
                [44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0],
                [44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0],
                [44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0],
            ]
        )
    elif qf == 79:
        q1 = torch.tensor(
            [
                [7.0, 5.0, 4.0, 7.0, 10.0, 17.0, 21.0, 26.0],
                [5.0, 5.0, 6.0, 8.0, 11.0, 24.0, 25.0, 23.0],
                [6.0, 5.0, 7.0, 10.0, 17.0, 24.0, 29.0, 24.0],
                [6.0, 7.0, 9.0, 12.0, 21.0, 37.0, 34.0, 26.0],
                [8.0, 9.0, 16.0, 24.0, 29.0, 46.0, 43.0, 32.0],
                [10.0, 15.0, 23.0, 27.0, 34.0, 44.0, 47.0, 39.0],
                [21.0, 27.0, 33.0, 37.0, 43.0, 51.0, 50.0, 42.0],
                [30.0, 39.0, 40.0, 41.0, 47.0, 42.0, 43.0, 42.0],
            ]
        )
        q2 = torch.tensor(
            [
                [7.0, 8.0, 10.0, 20.0, 42.0, 42.0, 42.0, 42.0],
                [8.0, 9.0, 11.0, 28.0, 42.0, 42.0, 42.0, 42.0],
                [10.0, 11.0, 24.0, 42.0, 42.0, 42.0, 42.0, 42.0],
                [20.0, 28.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0],
                [42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0],
                [42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0],
                [42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0],
                [42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0],
            ]
        )
    elif qf == 80:
        q1 = torch.tensor(
            [
                [6.0, 4.0, 4.0, 6.0, 10.0, 16.0, 20.0, 24.0],
                [5.0, 5.0, 6.0, 8.0, 10.0, 23.0, 24.0, 22.0],
                [6.0, 5.0, 6.0, 10.0, 16.0, 23.0, 28.0, 22.0],
                [6.0, 7.0, 9.0, 12.0, 20.0, 35.0, 32.0, 25.0],
                [7.0, 9.0, 15.0, 22.0, 27.0, 44.0, 41.0, 31.0],
                [10.0, 14.0, 22.0, 26.0, 32.0, 42.0, 45.0, 37.0],
                [20.0, 26.0, 31.0, 35.0, 41.0, 48.0, 48.0, 40.0],
                [29.0, 37.0, 38.0, 39.0, 45.0, 40.0, 41.0, 40.0],
            ]
        )
        q2 = torch.tensor(
            [
                [7.0, 7.0, 10.0, 19.0, 40.0, 40.0, 40.0, 40.0],
                [7.0, 8.0, 10.0, 26.0, 40.0, 40.0, 40.0, 40.0],
                [10.0, 10.0, 22.0, 40.0, 40.0, 40.0, 40.0, 40.0],
                [19.0, 26.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0],
                [40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0],
                [40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0],
                [40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0],
                [40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0],
            ]
        )
    elif qf == 81:
        q1 = torch.tensor(
            [
                [6.0, 4.0, 4.0, 6.0, 9.0, 15.0, 19.0, 23.0],
                [5.0, 5.0, 5.0, 7.0, 10.0, 22.0, 23.0, 21.0],
                [5.0, 5.0, 6.0, 9.0, 15.0, 22.0, 26.0, 21.0],
                [5.0, 6.0, 8.0, 11.0, 19.0, 33.0, 30.0, 24.0],
                [7.0, 8.0, 14.0, 21.0, 26.0, 41.0, 39.0, 29.0],
                [9.0, 13.0, 21.0, 24.0, 31.0, 40.0, 43.0, 35.0],
                [19.0, 24.0, 30.0, 33.0, 39.0, 46.0, 46.0, 38.0],
                [27.0, 35.0, 36.0, 37.0, 43.0, 38.0, 39.0, 38.0],
            ]
        )
        q2 = torch.tensor(
            [
                [6.0, 7.0, 9.0, 18.0, 38.0, 38.0, 38.0, 38.0],
                [7.0, 8.0, 10.0, 25.0, 38.0, 38.0, 38.0, 38.0],
                [9.0, 10.0, 21.0, 38.0, 38.0, 38.0, 38.0, 38.0],
                [18.0, 25.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0],
                [38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0],
                [38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0],
                [38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0],
                [38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0],
            ]
        )
    elif qf == 82:
        q1 = torch.tensor(
            [
                [6.0, 4.0, 4.0, 6.0, 9.0, 14.0, 18.0, 22.0],
                [4.0, 4.0, 5.0, 7.0, 9.0, 21.0, 22.0, 20.0],
                [5.0, 5.0, 6.0, 9.0, 14.0, 21.0, 25.0, 20.0],
                [5.0, 6.0, 8.0, 10.0, 18.0, 31.0, 29.0, 22.0],
                [6.0, 8.0, 13.0, 20.0, 24.0, 39.0, 37.0, 28.0],
                [9.0, 13.0, 20.0, 23.0, 29.0, 37.0, 41.0, 33.0],
                [18.0, 23.0, 28.0, 31.0, 37.0, 44.0, 43.0, 36.0],
                [26.0, 33.0, 34.0, 35.0, 40.0, 36.0, 37.0, 36.0],
            ]
        )
        q2 = torch.tensor(
            [
                [6.0, 6.0, 9.0, 17.0, 36.0, 36.0, 36.0, 36.0],
                [6.0, 8.0, 9.0, 24.0, 36.0, 36.0, 36.0, 36.0],
                [9.0, 9.0, 20.0, 36.0, 36.0, 36.0, 36.0, 36.0],
                [17.0, 24.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0],
                [36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0],
                [36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0],
                [36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0],
                [36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0],
            ]
        )
    elif qf == 83:
        q1 = torch.tensor(
            [
                [5.0, 4.0, 3.0, 5.0, 8.0, 14.0, 17.0, 21.0],
                [4.0, 4.0, 5.0, 6.0, 9.0, 20.0, 20.0, 19.0],
                [5.0, 4.0, 5.0, 8.0, 14.0, 19.0, 23.0, 19.0],
                [5.0, 6.0, 7.0, 10.0, 17.0, 30.0, 27.0, 21.0],
                [6.0, 7.0, 13.0, 19.0, 23.0, 37.0, 35.0, 26.0],
                [8.0, 12.0, 19.0, 22.0, 28.0, 35.0, 38.0, 31.0],
                [17.0, 22.0, 27.0, 30.0, 35.0, 41.0, 41.0, 34.0],
                [24.0, 31.0, 32.0, 33.0, 38.0, 34.0, 35.0, 34.0],
            ]
        )
        q2 = torch.tensor(
            [
                [6.0, 6.0, 8.0, 16.0, 34.0, 34.0, 34.0, 34.0],
                [6.0, 7.0, 9.0, 22.0, 34.0, 34.0, 34.0, 34.0],
                [8.0, 9.0, 19.0, 34.0, 34.0, 34.0, 34.0, 34.0],
                [16.0, 22.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0],
                [34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0],
                [34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0],
                [34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0],
                [34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0],
            ]
        )
    elif qf == 84:
        q1 = torch.tensor(
            [
                [5.0, 4.0, 3.0, 5.0, 8.0, 13.0, 16.0, 20.0],
                [4.0, 4.0, 4.0, 6.0, 8.0, 19.0, 19.0, 18.0],
                [4.0, 4.0, 5.0, 8.0, 13.0, 18.0, 22.0, 18.0],
                [4.0, 5.0, 7.0, 9.0, 16.0, 28.0, 26.0, 20.0],
                [6.0, 7.0, 12.0, 18.0, 22.0, 35.0, 33.0, 25.0],
                [8.0, 11.0, 18.0, 20.0, 26.0, 33.0, 36.0, 29.0],
                [16.0, 20.0, 25.0, 28.0, 33.0, 39.0, 38.0, 32.0],
                [23.0, 29.0, 30.0, 31.0, 36.0, 32.0, 33.0, 32.0],
            ]
        )
        q2 = torch.tensor(
            [
                [5.0, 6.0, 8.0, 15.0, 32.0, 32.0, 32.0, 32.0],
                [6.0, 7.0, 8.0, 21.0, 32.0, 32.0, 32.0, 32.0],
                [8.0, 8.0, 18.0, 32.0, 32.0, 32.0, 32.0, 32.0],
                [15.0, 21.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0],
                [32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0],
                [32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0],
                [32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0],
                [32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0],
            ]
        )
    elif qf == 85:
        q1 = torch.tensor(
            [
                [5.0, 3.0, 3.0, 5.0, 7.0, 12.0, 15.0, 18.0],
                [4.0, 4.0, 4.0, 6.0, 8.0, 17.0, 18.0, 17.0],
                [4.0, 4.0, 5.0, 7.0, 12.0, 17.0, 21.0, 17.0],
                [4.0, 5.0, 7.0, 9.0, 15.0, 26.0, 24.0, 19.0],
                [5.0, 7.0, 11.0, 17.0, 20.0, 33.0, 31.0, 23.0],
                [7.0, 11.0, 17.0, 19.0, 24.0, 31.0, 34.0, 28.0],
                [15.0, 19.0, 23.0, 26.0, 31.0, 36.0, 36.0, 30.0],
                [22.0, 28.0, 29.0, 29.0, 34.0, 30.0, 31.0, 30.0],
            ]
        )
        q2 = torch.tensor(
            [
                [5.0, 5.0, 7.0, 14.0, 30.0, 30.0, 30.0, 30.0],
                [5.0, 6.0, 8.0, 20.0, 30.0, 30.0, 30.0, 30.0],
                [7.0, 8.0, 17.0, 30.0, 30.0, 30.0, 30.0, 30.0],
                [14.0, 20.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0],
                [30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0],
                [30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0],
                [30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0],
                [30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0],
            ]
        )
    elif qf == 86:
        q1 = torch.tensor(
            [
                [4.0, 3.0, 3.0, 4.0, 7.0, 11.0, 14.0, 17.0],
                [3.0, 3.0, 4.0, 5.0, 7.0, 16.0, 17.0, 15.0],
                [4.0, 4.0, 4.0, 7.0, 11.0, 16.0, 19.0, 16.0],
                [4.0, 5.0, 6.0, 8.0, 14.0, 24.0, 22.0, 17.0],
                [5.0, 6.0, 10.0, 16.0, 19.0, 31.0, 29.0, 22.0],
                [7.0, 10.0, 15.0, 18.0, 23.0, 29.0, 32.0, 26.0],
                [14.0, 18.0, 22.0, 24.0, 29.0, 34.0, 34.0, 28.0],
                [20.0, 26.0, 27.0, 27.0, 31.0, 28.0, 29.0, 28.0],
            ]
        )
        q2 = torch.tensor(
            [
                [5.0, 5.0, 7.0, 13.0, 28.0, 28.0, 28.0, 28.0],
                [5.0, 6.0, 7.0, 18.0, 28.0, 28.0, 28.0, 28.0],
                [7.0, 7.0, 16.0, 28.0, 28.0, 28.0, 28.0, 28.0],
                [13.0, 18.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0],
                [28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0],
                [28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0],
                [28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0],
                [28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0],
            ]
        )
    elif qf == 87:
        q1 = torch.tensor(
            [
                [4.0, 3.0, 3.0, 4.0, 6.0, 10.0, 13.0, 16.0],
                [3.0, 3.0, 4.0, 5.0, 7.0, 15.0, 16.0, 14.0],
                [4.0, 3.0, 4.0, 6.0, 10.0, 15.0, 18.0, 15.0],
                [4.0, 4.0, 6.0, 8.0, 13.0, 23.0, 21.0, 16.0],
                [5.0, 6.0, 10.0, 15.0, 18.0, 28.0, 27.0, 20.0],
                [6.0, 9.0, 14.0, 17.0, 21.0, 27.0, 29.0, 24.0],
                [13.0, 17.0, 20.0, 23.0, 27.0, 31.0, 31.0, 26.0],
                [19.0, 24.0, 25.0, 25.0, 29.0, 26.0, 27.0, 26.0],
            ]
        )
        q2 = torch.tensor(
            [
                [4.0, 5.0, 6.0, 12.0, 26.0, 26.0, 26.0, 26.0],
                [5.0, 5.0, 7.0, 17.0, 26.0, 26.0, 26.0, 26.0],
                [6.0, 7.0, 15.0, 26.0, 26.0, 26.0, 26.0, 26.0],
                [12.0, 17.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0],
                [26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0],
                [26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0],
                [26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0],
                [26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0],
            ]
        )
    elif qf == 88:
        q1 = torch.tensor(
            [
                [4.0, 3.0, 2.0, 4.0, 6.0, 10.0, 12.0, 15.0],
                [3.0, 3.0, 3.0, 5.0, 6.0, 14.0, 14.0, 13.0],
                [3.0, 3.0, 4.0, 6.0, 10.0, 14.0, 17.0, 13.0],
                [3.0, 4.0, 5.0, 7.0, 12.0, 21.0, 19.0, 15.0],
                [4.0, 5.0, 9.0, 13.0, 16.0, 26.0, 25.0, 18.0],
                [6.0, 8.0, 13.0, 15.0, 19.0, 25.0, 27.0, 22.0],
                [12.0, 15.0, 19.0, 21.0, 25.0, 29.0, 29.0, 24.0],
                [17.0, 22.0, 23.0, 24.0, 27.0, 24.0, 25.0, 24.0],
            ]
        )
        q2 = torch.tensor(
            [
                [4.0, 4.0, 6.0, 11.0, 24.0, 24.0, 24.0, 24.0],
                [4.0, 5.0, 6.0, 16.0, 24.0, 24.0, 24.0, 24.0],
                [6.0, 6.0, 13.0, 24.0, 24.0, 24.0, 24.0, 24.0],
                [11.0, 16.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0],
                [24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0],
                [24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0],
                [24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0],
                [24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0],
            ]
        )
    elif qf == 89:
        q1 = torch.tensor(
            [
                [4.0, 2.0, 2.0, 4.0, 5.0, 9.0, 11.0, 13.0],
                [3.0, 3.0, 3.0, 4.0, 6.0, 13.0, 13.0, 12.0],
                [3.0, 3.0, 4.0, 5.0, 9.0, 13.0, 15.0, 12.0],
                [3.0, 4.0, 5.0, 6.0, 11.0, 19.0, 18.0, 14.0],
                [4.0, 5.0, 8.0, 12.0, 15.0, 24.0, 23.0, 17.0],
                [5.0, 8.0, 12.0, 14.0, 18.0, 23.0, 25.0, 20.0],
                [11.0, 14.0, 17.0, 19.0, 23.0, 27.0, 26.0, 22.0],
                [16.0, 20.0, 21.0, 22.0, 25.0, 22.0, 23.0, 22.0],
            ]
        )
        q2 = torch.tensor(
            [
                [4.0, 4.0, 5.0, 10.0, 22.0, 22.0, 22.0, 22.0],
                [4.0, 5.0, 6.0, 15.0, 22.0, 22.0, 22.0, 22.0],
                [5.0, 6.0, 12.0, 22.0, 22.0, 22.0, 22.0, 22.0],
                [10.0, 15.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0],
                [22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0],
                [22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0],
                [22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0],
                [22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0],
            ]
        )
    elif qf == 90:
        q1 = torch.tensor(
            [
                [3.0, 2.0, 2.0, 3.0, 5.0, 8.0, 10.0, 12.0],
                [2.0, 2.0, 3.0, 4.0, 5.0, 12.0, 12.0, 11.0],
                [3.0, 3.0, 3.0, 5.0, 8.0, 11.0, 14.0, 11.0],
                [3.0, 3.0, 4.0, 6.0, 10.0, 17.0, 16.0, 12.0],
                [4.0, 4.0, 7.0, 11.0, 14.0, 22.0, 21.0, 15.0],
                [5.0, 7.0, 11.0, 13.0, 16.0, 21.0, 23.0, 18.0],
                [10.0, 13.0, 16.0, 17.0, 21.0, 24.0, 24.0, 20.0],
                [14.0, 18.0, 19.0, 20.0, 22.0, 20.0, 21.0, 20.0],
            ]
        )
        q2 = torch.tensor(
            [
                [3.0, 4.0, 5.0, 9.0, 20.0, 20.0, 20.0, 20.0],
                [4.0, 4.0, 5.0, 13.0, 20.0, 20.0, 20.0, 20.0],
                [5.0, 5.0, 11.0, 20.0, 20.0, 20.0, 20.0, 20.0],
                [9.0, 13.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0],
                [20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0],
                [20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0],
                [20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0],
                [20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0],
            ]
        )
    elif qf == 91:
        q1 = torch.tensor(
            [
                [3.0, 2.0, 2.0, 3.0, 4.0, 7.0, 9.0, 11.0],
                [2.0, 2.0, 3.0, 3.0, 5.0, 10.0, 11.0, 10.0],
                [3.0, 2.0, 3.0, 4.0, 7.0, 10.0, 12.0, 10.0],
                [3.0, 3.0, 4.0, 5.0, 9.0, 16.0, 14.0, 11.0],
                [3.0, 4.0, 7.0, 10.0, 12.0, 20.0, 19.0, 14.0],
                [4.0, 6.0, 10.0, 12.0, 15.0, 19.0, 20.0, 17.0],
                [9.0, 12.0, 14.0, 16.0, 19.0, 22.0, 22.0, 18.0],
                [13.0, 17.0, 17.0, 18.0, 20.0, 18.0, 19.0, 18.0],
            ]
        )
        q2 = torch.tensor(
            [
                [3.0, 3.0, 4.0, 8.0, 18.0, 18.0, 18.0, 18.0],
                [3.0, 4.0, 5.0, 12.0, 18.0, 18.0, 18.0, 18.0],
                [4.0, 5.0, 10.0, 18.0, 18.0, 18.0, 18.0, 18.0],
                [8.0, 12.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0],
                [18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0],
                [18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0],
                [18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0],
                [18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0],
            ]
        )
    elif qf == 92:
        q1 = torch.tensor(
            [
                [3.0, 2.0, 2.0, 3.0, 4.0, 6.0, 8.0, 10.0],
                [2.0, 2.0, 2.0, 3.0, 4.0, 9.0, 10.0, 9.0],
                [2.0, 2.0, 3.0, 4.0, 6.0, 9.0, 11.0, 9.0],
                [2.0, 3.0, 4.0, 5.0, 8.0, 14.0, 13.0, 10.0],
                [3.0, 4.0, 6.0, 9.0, 11.0, 17.0, 16.0, 12.0],
                [4.0, 6.0, 9.0, 10.0, 13.0, 17.0, 18.0, 15.0],
                [8.0, 10.0, 12.0, 14.0, 16.0, 19.0, 19.0, 16.0],
                [12.0, 15.0, 15.0, 16.0, 18.0, 16.0, 16.0, 16.0],
            ]
        )
        q2 = torch.tensor(
            [
                [3.0, 3.0, 4.0, 8.0, 16.0, 16.0, 16.0, 16.0],
                [3.0, 3.0, 4.0, 11.0, 16.0, 16.0, 16.0, 16.0],
                [4.0, 4.0, 9.0, 16.0, 16.0, 16.0, 16.0, 16.0],
                [8.0, 11.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0],
                [16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0],
                [16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0],
                [16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0],
                [16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0],
            ]
        )
    elif qf == 93:
        q1 = torch.tensor(
            [
                [2.0, 2.0, 1.0, 2.0, 3.0, 6.0, 7.0, 9.0],
                [2.0, 2.0, 2.0, 3.0, 4.0, 8.0, 8.0, 8.0],
                [2.0, 2.0, 2.0, 3.0, 6.0, 8.0, 10.0, 8.0],
                [2.0, 2.0, 3.0, 4.0, 7.0, 12.0, 11.0, 9.0],
                [3.0, 3.0, 5.0, 8.0, 10.0, 15.0, 14.0, 11.0],
                [3.0, 5.0, 8.0, 9.0, 11.0, 15.0, 16.0, 13.0],
                [7.0, 9.0, 11.0, 12.0, 14.0, 17.0, 17.0, 14.0],
                [10.0, 13.0, 13.0, 14.0, 16.0, 14.0, 14.0, 14.0],
            ]
        )
        q2 = torch.tensor(
            [
                [2.0, 3.0, 3.0, 7.0, 14.0, 14.0, 14.0, 14.0],
                [3.0, 3.0, 4.0, 9.0, 14.0, 14.0, 14.0, 14.0],
                [3.0, 4.0, 8.0, 14.0, 14.0, 14.0, 14.0, 14.0],
                [7.0, 9.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0],
                [14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0],
                [14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0],
                [14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0],
                [14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0],
            ]
        )
    elif qf == 94:
        q1 = torch.tensor(
            [
                [2.0, 1.0, 1.0, 2.0, 3.0, 5.0, 6.0, 7.0],
                [1.0, 1.0, 2.0, 2.0, 3.0, 7.0, 7.0, 7.0],
                [2.0, 2.0, 2.0, 3.0, 5.0, 7.0, 8.0, 7.0],
                [2.0, 2.0, 3.0, 3.0, 6.0, 10.0, 10.0, 7.0],
                [2.0, 3.0, 4.0, 7.0, 8.0, 13.0, 12.0, 9.0],
                [3.0, 4.0, 7.0, 8.0, 10.0, 12.0, 14.0, 11.0],
                [6.0, 8.0, 9.0, 10.0, 12.0, 15.0, 14.0, 12.0],
                [9.0, 11.0, 11.0, 12.0, 13.0, 12.0, 12.0, 12.0],
            ]
        )
        q2 = torch.tensor(
            [
                [2.0, 2.0, 3.0, 6.0, 12.0, 12.0, 12.0, 12.0],
                [2.0, 3.0, 3.0, 8.0, 12.0, 12.0, 12.0, 12.0],
                [3.0, 3.0, 7.0, 12.0, 12.0, 12.0, 12.0, 12.0],
                [6.0, 8.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0],
                [12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0],
                [12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0],
                [12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0],
                [12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0],
            ]
        )
    elif qf == 95:
        q1 = torch.tensor(
            [
                [2.0, 1.0, 1.0, 2.0, 2.0, 4.0, 5.0, 6.0],
                [1.0, 1.0, 1.0, 2.0, 3.0, 6.0, 6.0, 6.0],
                [1.0, 1.0, 2.0, 2.0, 4.0, 6.0, 7.0, 6.0],
                [1.0, 2.0, 2.0, 3.0, 5.0, 9.0, 8.0, 6.0],
                [2.0, 2.0, 4.0, 6.0, 7.0, 11.0, 10.0, 8.0],
                [2.0, 4.0, 6.0, 6.0, 8.0, 10.0, 11.0, 9.0],
                [5.0, 6.0, 8.0, 9.0, 10.0, 12.0, 12.0, 10.0],
                [7.0, 9.0, 10.0, 10.0, 11.0, 10.0, 10.0, 10.0],
            ]
        )
        q2 = torch.tensor(
            [
                [2.0, 2.0, 2.0, 5.0, 10.0, 10.0, 10.0, 10.0],
                [2.0, 2.0, 3.0, 7.0, 10.0, 10.0, 10.0, 10.0],
                [2.0, 3.0, 6.0, 10.0, 10.0, 10.0, 10.0, 10.0],
                [5.0, 7.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0],
                [10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0],
                [10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0],
                [10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0],
                [10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0],
            ]
        )
    elif qf == 96:
        q1 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0],
                [1.0, 1.0, 1.0, 2.0, 2.0, 5.0, 5.0, 4.0],
                [1.0, 1.0, 1.0, 2.0, 3.0, 5.0, 6.0, 4.0],
                [1.0, 1.0, 2.0, 2.0, 4.0, 7.0, 6.0, 5.0],
                [1.0, 2.0, 3.0, 4.0, 5.0, 9.0, 8.0, 6.0],
                [2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 9.0, 7.0],
                [4.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 8.0],
                [6.0, 7.0, 8.0, 8.0, 9.0, 8.0, 8.0, 8.0],
            ]
        )
        q2 = torch.tensor(
            [
                [1.0, 1.0, 2.0, 4.0, 8.0, 8.0, 8.0, 8.0],
                [1.0, 2.0, 2.0, 5.0, 8.0, 8.0, 8.0, 8.0],
                [2.0, 2.0, 4.0, 8.0, 8.0, 8.0, 8.0, 8.0],
                [4.0, 5.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0],
                [8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0],
                [8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0],
                [8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0],
                [8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0],
            ]
        )
    elif qf == 97:
        q1 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 4.0],
                [1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 4.0, 3.0],
                [1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 4.0, 3.0],
                [1.0, 1.0, 1.0, 2.0, 3.0, 5.0, 5.0, 4.0],
                [1.0, 1.0, 2.0, 3.0, 4.0, 7.0, 6.0, 5.0],
                [1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 6.0],
                [3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 7.0, 6.0],
                [4.0, 6.0, 6.0, 6.0, 7.0, 6.0, 6.0, 6.0],
            ]
        )
        q2 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 3.0, 6.0, 6.0, 6.0, 6.0],
                [1.0, 1.0, 2.0, 4.0, 6.0, 6.0, 6.0, 6.0],
                [1.0, 2.0, 3.0, 6.0, 6.0, 6.0, 6.0, 6.0],
                [3.0, 4.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0],
                [6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0],
                [6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0],
                [6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0],
                [6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0],
            ]
        )
    elif qf == 98:
        q1 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 2.0],
                [1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 3.0, 2.0],
                [1.0, 1.0, 1.0, 2.0, 3.0, 4.0, 4.0, 3.0],
                [1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 4.0],
                [2.0, 3.0, 3.0, 3.0, 4.0, 5.0, 5.0, 4.0],
                [3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
            ]
        )
        q2 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 2.0, 4.0, 4.0, 4.0, 4.0],
                [1.0, 1.0, 1.0, 3.0, 4.0, 4.0, 4.0, 4.0],
                [1.0, 1.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0],
                [2.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
                [4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
                [4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
                [4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
                [4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
            ]
        )
    elif qf == 99:
        q1 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
                [1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
            ]
        )
        q2 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0],
                [1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
                [2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
                [2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
                [2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
                [2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
            ]
        )
    elif qf == 100:
        q1 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
            ]
        )
        q2 = torch.tensor(
            [
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
            ]
        )
    else:
        raise ValueError("Quality factor must be between 1 and 100.")

    return q1, q2
