# seeg_decoding

# Pre-reqs
- Create a conda environment with `python=3.7` 
- Install pytorch (see [here](https://pytorch.org/get-started/locally/))
- `pip install -r requirements.txt`

# Running linear decoding
```
python3 run_time_tests.py +exp=timed_tests ++exp.runner.num_workers=0 +data=decoding_base \
+model=classification_regression_model +task=timed_tests +criterion=empty_criterion ++data.interval_duration=3.0 \
++data.name="sentence_onset_regression" +test=held_out_subjects \
++test.test_split_path=/storage/czw/seeg_decoding/data/test_split_trials.json \
++test.test_electrodes_path="None" ++data.movie_transcripts_dir="/storage/czw/seeg_decoding/updated_word_features" \
++task.windows_start=-1 ++task.windows_end=1 ++task.window_duration=0.250 ++task.window_step=0.1 \
++test.out_dir="/storage/czw/seeg_decoding/outputs/reg_cross_validate_sentence_onset_debug/"
```

# Running t-tests
```
python3 -m stats.word_onset_tests +data=tstat_word_onset +exp=word_onset ++data.duration=2.0 \
++data.interval_duration=2.0 +test=all_trials ++data.delta=-1.0 ++test.glm_results_path="/storage/czw/seeg_decoding/\
glm_results_sparse_normalized_fixed_new_features" ++data.movie_transcripts_dir="/storage/czw/seeg_decoding/updated_word_features" \
++exp.control_type="sub_sample" ++exp.out_dir="/storage/czw/seeg_decoding/outputs/word_onsets_sub_sample_vary_debug"
```
