class BaseMethod:
    def __init__(self, return_history=True, name="BaseName", EPS=1e-14, EPS_GAMMA=1e-14, *args, **kwargs):
        """
        :param return_history: bool, if True, method saves history
        """
        self.name = name
        self.return_history = return_history
        self.history = []
        self.X = None
        self.Y = None
        self._old_grad = None
        self._new_grad = None
        self._old_X = None
        self._old_Y = None
        self.gamma = None
        self.gamma_prev = None
        self.EPS = EPS
        self.EPS_GAMMA = EPS_GAMMA

    def update_gamma(self,  *args, **kwargs):
        pass

    def __call__(self,  *args, **kwargs):
        pass
