#!/bin/bash

echo "Starting tmux sessions for seeker training..."

echo "Starting baseline..."
tmux new-session -d -s t_seeker_base "source activate action_masking; python3 action_masking/experiments/benchmark_seeker.py --approach=baseline"

for mm in "generator" "ray" "distribution"
do
    echo "Starting t_seeker_$mm..."
    tmux new-session -d -s t_seeker_$mm "source activate action_masking; python3 action_masking/experiments/benchmark_seeker.py --approach=masking --masking-mode=$mm"
done