#!/bin/bash

echo "Starting tmux sessions for seeker hyperparameter tuning..."

echo "Starting baseline..."
tmux new-session -d -s o_seeker_base "source activate action_masking; python3 action_masking/experiments/benchmark_seeker.py --approach=baseline --optimize"

for mm in "generator" "ray" "distribution"
do
    echo "Starting o_seeker_$mm..."
    tmux new-session -d -s o_seeker_$mm "source activate action_masking; python3 action_masking/experiments/benchmark_seeker.py --approach=masking --masking-mode=$mm --optimize"
done