import numpy as np


def project_onto_ball(point, radius):
    direction = point
    distance = np.linalg.norm(direction, 2)
    if distance <= radius:
        return point
    else:
        normalized_direction = direction / distance
        projected_point = normalized_direction * radius
        return projected_point


def project_onto_ball_first_quadrant(point, radius):
    direction = point
    distance = np.linalg.norm(direction, 2)
    if distance <= radius:
        return np.fmax(point, 0)
    else:
        normalized_direction = direction / distance
        projected_point = normalized_direction * radius
        return np.fmax(projected_point, 0)


import numpy as np


def read_assignp(file_name):
    with open(file_name) as file:
        for k, line in enumerate(file.readlines()):
            if k == 0:
                n = int(line.strip())
                m = int(n / 100)
                s = n
                utility_coeff_matrix = np.zeros(shape=(n, s))
            else:
                i, j, utility_coeff = [int(_) for _ in line.strip().split(' ')]
                utility_coeff_matrix[i-1, j-1] = utility_coeff

    requests = []
    for i in range(n):
        request = [utility_coeff_matrix[i],
                   np.concatenate([np.eye(m)] * int(n / m), axis=-1),
                   None]
        requests.append(request)

    return requests


def read_problem(problem_name, gamma=None, dir=''):
    requests = []
    exp_params = {}

    # --- workforce scheduling problem
    if problem_name == 'workforce_scheduling_gurobi_demo':
        from gurobi_optimods import datasets
        data = datasets.load_workforce()

        # --- worker data
        pivot_tab = data.availability.pivot(index='Worker', columns='Shift', values='Preference')
        pivot_tab.fillna(-9999999, inplace=True)
        workers_list = pivot_tab.index.values
        preferences = pivot_tab.values
        num_of_days = pivot_tab.shape[1]

        # --- shift req (LHS)
        b = np.ones(num_of_days)
        ngammab = data.shift_requirements.Required.values
        gamma = ngammab / len(workers_list) / b

        # --- indiv_assign_bds
        worker_limits = data.worker_limits
        worker_limits.sort_values('Worker', inplace=True)
        totalassign_bds = worker_limits[['MinShifts', 'MaxShifts']].values
        totalassign_lbs, totalassign_ubs = totalassign_bds.transpose()
        # --- construct requests and exp_params
        n, m, s = len(workers_list), num_of_days, num_of_days
        for i, worker in enumerate(workers_list):
            utility_coeff = preferences[i]
            A = np.eye(num_of_days)
            bd = None
            requests.append([utility_coeff, A, bd])
        exp_params = {'m': m,
                      'n': n,
                      's': s,
                      'gamma': gamma,
                      'requests': requests,
                      'b': b,
                      'indiv_totalassign_ubs': totalassign_ubs,
                      'indiv_totalassign_lbs': totalassign_lbs
                      }

    # --- assignment_problems
    if problem_name.startswith('assignp'):
        file_name = dir + 'data/assignment/' + problem_name + '.txt'
        requests = read_assignp(file_name)
        n = len(requests)
        m, s = requests[0][1].shape
        assert gamma is not None, 'provide a gamma between (0, 1]'
        exp_params = {'m': m,
                      'n': n,
                      's': s,
                      'gamma': gamma,
                      'requests': requests,
                      'b': np.ones(m),
                      'indiv_totalassign_ubs': np.ones(n),
                      'indiv_totalassign_lbs': np.zeros(n)
                      }

    return exp_params



