#!/bin/bash

#SBATCH --job-name=i_llama_full
#SBATCH --output=i_llama_full.out
#SBATCH --error=i_llama_full.err
# SBATCH --job-name=i_llama_full_scrp
# SBATCH --output=i_llama_full_scrp.out
# SBATCH --error=i_llama_full_scrp.err

#SBATCH --partition=compute
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1
#SBATCH --gres=gpu:A100:4
#SBATCH --time=23:00:00
#SBATCH --mail-type=ALL
#SBATCH --mail-user=bo@andrew.cmu.edu


source ~/.bashrc
conda activate agent


accelerate launch  --main_process_port 29510 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/agent-model/LLaMA-Factory/src/train_bash.py \
    --stage sft \
    --model_name_or_path /data/b_ou/ckpts/llama2/models--meta-llama--Llama-2-7b-chat-hf/snapshots/c1b0db933684edbfe29a06fa47eb19cc48025e93 \
    --do_predict \
    --dataset m2w_text_test \
    --dataset_dir /data/b_ou/agent/data/text/ \
    --template llama2 \
    --finetuning_type full \
    --checkpoint_dir /data/b_ou/ckpts/output_16k_llama2_full/checkpoint-855/ \
    --output_dir /data/b_ou/ckpts/output_16k_llama2_full/pred \
    --per_device_eval_batch_size 4 \
    --predict_with_generate True \
    --use_safetensors True \
    --cutoff_len 4096 \
    --bf16 True





# accelerate launch  --main_process_port 29511 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/LLaMA-Factory/src/train_bash.py \
#     --stage sft \
#     --model_name_or_path /data/b_ou/ckpts/llama2/models--meta-llama--Llama-2-7b-chat-hf/snapshots/c1b0db933684edbfe29a06fa47eb19cc48025e93 \
#     --do_predict \
#     --dataset m2w_text_scrape \
#     --dataset_dir /data/b_ou/agent/data/text_scrp/ \
#     --template llama2 \
#     --finetuning_type full \
#     --checkpoint_dir /data/b_ou/ckpts/output_8k_llama_full_scrp/checkpoint-780/ \
#     --output_dir /data/b_ou/ckpts/output_8k_llama_full_scrp/pred \
#     --per_device_eval_batch_size 16 \
#     --predict_with_generate \
#     --use_safetensors True \
#     --bf16 True
