BEGIN TRANSACTION;
CREATE TABLE Buildings (BuildingID INTEGER PRIMARY KEY, Name TEXT, Address TEXT);
INSERT INTO "Buildings" VALUES(1,'Engineering Building','1 University Drive');
INSERT INTO "Buildings" VALUES(2,'Liberal Arts Building','2 University Drive');
INSERT INTO "Buildings" VALUES(3,'Science Building','3 University Drive');
INSERT INTO "Buildings" VALUES(4,'Health Sciences Building','4 University Drive');
INSERT INTO "Buildings" VALUES(5,'Arts and Humanities Building','5 University Drive');
CREATE TABLE "Courses" (CourseID INTEGER PRIMARY KEY, CourseTitle TEXT, Location TEXT, StartTime TIME, EndTime TIME);
INSERT INTO "Courses" VALUES(1,'Introduction to Computer Science','Engineering','9AM','12PM');
INSERT INTO "Courses" VALUES(2,'Calculus I','Liberal Arts','10AM','1PM');
INSERT INTO "Courses" VALUES(3,'General Physics I','Science','1PM','4PM');
INSERT INTO "Courses" VALUES(4,'Human Biology','Health Sciences','2PM','5PM');
INSERT INTO "Courses" VALUES(5,'World History','Arts and Humanities','8AM','11AM');
CREATE TABLE Departments (DepartmentID INTEGER PRIMARY KEY, DepartmentName TEXT);
INSERT INTO "Departments" VALUES(1,'Computer Science');
INSERT INTO "Departments" VALUES(2,'Mathematics');
INSERT INTO "Departments" VALUES(3,'Physics');
INSERT INTO "Departments" VALUES(4,'Biology');
INSERT INTO "Departments" VALUES(5,'History');
CREATE TABLE Enrollments (EnrollmentID INTEGER PRIMARY KEY, CourseID INTEGER, StudentID INTEGER, FOREIGN KEY(CourseID) REFERENCES Courses(CourseID), FOREIGN KEY(StudentID) REFERENCES Students(StudentID));
CREATE TABLE Rooms (RoomID INTEGER PRIMARY KEY, BuildingID INTEGER, Capacity INTEGER, FOREIGN KEY(BuildingID) REFERENCES Buildings(BuildingID));
INSERT INTO "Rooms" VALUES(101,1,100);
INSERT INTO "Rooms" VALUES(201,2,200);
INSERT INTO "Rooms" VALUES(301,3,250);
INSERT INTO "Rooms" VALUES(401,4,150);
INSERT INTO "Rooms" VALUES(501,5,100);
CREATE TABLE Students (StudentID INTEGER PRIMARY KEY, FirstName TEXT, LastName TEXT);
INSERT INTO "Students" VALUES(1,'John','Doe');
INSERT INTO "Students" VALUES(2,'Jane','Smith');
INSERT INTO "Students" VALUES(3,'Michael','Brown');
INSERT INTO "Students" VALUES(4,'Alice','Green');
INSERT INTO "Students" VALUES(5,'Tom','White');
COMMIT;
